// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



/**
 * Defines the X.509 CertificatePolicies extension.
 */
class PolicyInformation private constructor(builder: BuilderImpl) {
    /**
     * Specifies the object identifier (OID) of the certificate policy under which the
     * certificate was issued. For more information, see NIST's definition of <a href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier
     * (OID).
     */
    val certPolicyId: String? = builder.certPolicyId
    /**
     * Modifies the given CertPolicyId with a qualifier. ACM Private CA supports the
     * certification practice statement (CPS) qualifier.
     */
    val policyQualifiers: List<PolicyQualifierInfo>? = builder.policyQualifiers

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PolicyInformation = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PolicyInformation(")
        append("certPolicyId=$certPolicyId,")
        append("policyQualifiers=$policyQualifiers)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certPolicyId?.hashCode() ?: 0
        result = 31 * result + (policyQualifiers?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PolicyInformation

        if (certPolicyId != other.certPolicyId) return false
        if (policyQualifiers != other.policyQualifiers) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PolicyInformation = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PolicyInformation
        /**
         * Specifies the object identifier (OID) of the certificate policy under which the
         * certificate was issued. For more information, see NIST's definition of <a href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier
         * (OID).
         */
        fun certPolicyId(certPolicyId: String): FluentBuilder
        /**
         * Modifies the given CertPolicyId with a qualifier. ACM Private CA supports the
         * certification practice statement (CPS) qualifier.
         */
        fun policyQualifiers(policyQualifiers: List<PolicyQualifierInfo>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specifies the object identifier (OID) of the certificate policy under which the
         * certificate was issued. For more information, see NIST's definition of <a href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier
         * (OID).
         */
        var certPolicyId: String?
        /**
         * Modifies the given CertPolicyId with a qualifier. ACM Private CA supports the
         * certification practice statement (CPS) qualifier.
         */
        var policyQualifiers: List<PolicyQualifierInfo>?

        fun build(): PolicyInformation
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var certPolicyId: String? = null
        override var policyQualifiers: List<PolicyQualifierInfo>? = null

        constructor(x: PolicyInformation) : this() {
            this.certPolicyId = x.certPolicyId
            this.policyQualifiers = x.policyQualifiers
        }

        override fun build(): PolicyInformation = PolicyInformation(this)
        override fun certPolicyId(certPolicyId: String): FluentBuilder = apply { this.certPolicyId = certPolicyId }
        override fun policyQualifiers(policyQualifiers: List<PolicyQualifierInfo>): FluentBuilder = apply { this.policyQualifiers = policyQualifiers }
    }
}
