// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



/**
 * Defines one or more purposes for which the key contained in the certificate can be
 * used. Default value for each option is false.
 */
class KeyUsage private constructor(builder: BuilderImpl) {
    /**
     * Key can be used to sign CRLs.
     */
    val crlSign: Boolean = builder.crlSign
    /**
     * Key can be used to decipher data.
     */
    val dataEncipherment: Boolean = builder.dataEncipherment
    /**
     * Key can be used only to decipher data.
     */
    val decipherOnly: Boolean = builder.decipherOnly
    /**
     * Key can be used for digital signing.
     */
    val digitalSignature: Boolean = builder.digitalSignature
    /**
     * Key can be used only to encipher data.
     */
    val encipherOnly: Boolean = builder.encipherOnly
    /**
     * Key can be used in a key-agreement protocol.
     */
    val keyAgreement: Boolean = builder.keyAgreement
    /**
     * Key can be used to sign certificates.
     */
    val keyCertSign: Boolean = builder.keyCertSign
    /**
     * Key can be used to encipher data.
     */
    val keyEncipherment: Boolean = builder.keyEncipherment
    /**
     * Key can be used for non-repudiation.
     */
    val nonRepudiation: Boolean = builder.nonRepudiation

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): KeyUsage = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("KeyUsage(")
        append("crlSign=$crlSign,")
        append("dataEncipherment=$dataEncipherment,")
        append("decipherOnly=$decipherOnly,")
        append("digitalSignature=$digitalSignature,")
        append("encipherOnly=$encipherOnly,")
        append("keyAgreement=$keyAgreement,")
        append("keyCertSign=$keyCertSign,")
        append("keyEncipherment=$keyEncipherment,")
        append("nonRepudiation=$nonRepudiation)")
    }

    override fun hashCode(): kotlin.Int {
        var result = crlSign.hashCode()
        result = 31 * result + (dataEncipherment.hashCode())
        result = 31 * result + (decipherOnly.hashCode())
        result = 31 * result + (digitalSignature.hashCode())
        result = 31 * result + (encipherOnly.hashCode())
        result = 31 * result + (keyAgreement.hashCode())
        result = 31 * result + (keyCertSign.hashCode())
        result = 31 * result + (keyEncipherment.hashCode())
        result = 31 * result + (nonRepudiation.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as KeyUsage

        if (crlSign != other.crlSign) return false
        if (dataEncipherment != other.dataEncipherment) return false
        if (decipherOnly != other.decipherOnly) return false
        if (digitalSignature != other.digitalSignature) return false
        if (encipherOnly != other.encipherOnly) return false
        if (keyAgreement != other.keyAgreement) return false
        if (keyCertSign != other.keyCertSign) return false
        if (keyEncipherment != other.keyEncipherment) return false
        if (nonRepudiation != other.nonRepudiation) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): KeyUsage = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): KeyUsage
        /**
         * Key can be used to sign CRLs.
         */
        fun crlSign(crlSign: Boolean): FluentBuilder
        /**
         * Key can be used to decipher data.
         */
        fun dataEncipherment(dataEncipherment: Boolean): FluentBuilder
        /**
         * Key can be used only to decipher data.
         */
        fun decipherOnly(decipherOnly: Boolean): FluentBuilder
        /**
         * Key can be used for digital signing.
         */
        fun digitalSignature(digitalSignature: Boolean): FluentBuilder
        /**
         * Key can be used only to encipher data.
         */
        fun encipherOnly(encipherOnly: Boolean): FluentBuilder
        /**
         * Key can be used in a key-agreement protocol.
         */
        fun keyAgreement(keyAgreement: Boolean): FluentBuilder
        /**
         * Key can be used to sign certificates.
         */
        fun keyCertSign(keyCertSign: Boolean): FluentBuilder
        /**
         * Key can be used to encipher data.
         */
        fun keyEncipherment(keyEncipherment: Boolean): FluentBuilder
        /**
         * Key can be used for non-repudiation.
         */
        fun nonRepudiation(nonRepudiation: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Key can be used to sign CRLs.
         */
        var crlSign: Boolean
        /**
         * Key can be used to decipher data.
         */
        var dataEncipherment: Boolean
        /**
         * Key can be used only to decipher data.
         */
        var decipherOnly: Boolean
        /**
         * Key can be used for digital signing.
         */
        var digitalSignature: Boolean
        /**
         * Key can be used only to encipher data.
         */
        var encipherOnly: Boolean
        /**
         * Key can be used in a key-agreement protocol.
         */
        var keyAgreement: Boolean
        /**
         * Key can be used to sign certificates.
         */
        var keyCertSign: Boolean
        /**
         * Key can be used to encipher data.
         */
        var keyEncipherment: Boolean
        /**
         * Key can be used for non-repudiation.
         */
        var nonRepudiation: Boolean

        fun build(): KeyUsage
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var crlSign: Boolean = false
        override var dataEncipherment: Boolean = false
        override var decipherOnly: Boolean = false
        override var digitalSignature: Boolean = false
        override var encipherOnly: Boolean = false
        override var keyAgreement: Boolean = false
        override var keyCertSign: Boolean = false
        override var keyEncipherment: Boolean = false
        override var nonRepudiation: Boolean = false

        constructor(x: KeyUsage) : this() {
            this.crlSign = x.crlSign
            this.dataEncipherment = x.dataEncipherment
            this.decipherOnly = x.decipherOnly
            this.digitalSignature = x.digitalSignature
            this.encipherOnly = x.encipherOnly
            this.keyAgreement = x.keyAgreement
            this.keyCertSign = x.keyCertSign
            this.keyEncipherment = x.keyEncipherment
            this.nonRepudiation = x.nonRepudiation
        }

        override fun build(): KeyUsage = KeyUsage(this)
        override fun crlSign(crlSign: Boolean): FluentBuilder = apply { this.crlSign = crlSign }
        override fun dataEncipherment(dataEncipherment: Boolean): FluentBuilder = apply { this.dataEncipherment = dataEncipherment }
        override fun decipherOnly(decipherOnly: Boolean): FluentBuilder = apply { this.decipherOnly = decipherOnly }
        override fun digitalSignature(digitalSignature: Boolean): FluentBuilder = apply { this.digitalSignature = digitalSignature }
        override fun encipherOnly(encipherOnly: Boolean): FluentBuilder = apply { this.encipherOnly = encipherOnly }
        override fun keyAgreement(keyAgreement: Boolean): FluentBuilder = apply { this.keyAgreement = keyAgreement }
        override fun keyCertSign(keyCertSign: Boolean): FluentBuilder = apply { this.keyCertSign = keyCertSign }
        override fun keyEncipherment(keyEncipherment: Boolean): FluentBuilder = apply { this.keyEncipherment = keyEncipherment }
        override fun nonRepudiation(nonRepudiation: Boolean): FluentBuilder = apply { this.nonRepudiation = nonRepudiation }
    }
}
