// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



/**
 * Describes an ASN.1 X.400 GeneralName as defined in <a href="https://tools.ietf.org/html/rfc5280">RFC 5280. Only one of the
 * following naming options should be provided. Providing more than one option results in
 * an InvalidArgsException error.
 */
class GeneralName private constructor(builder: BuilderImpl) {
    /**
     * Contains information about the certificate subject. The Subject field in
     * the certificate identifies the entity that owns or controls the public key in the
     * certificate. The entity can be a user, computer, device, or service. The Subject
     * must contain an X.500 distinguished name (DN). A DN is a sequence of relative
     * distinguished names (RDNs). The RDNs are separated by commas in the certificate.
     */
    val directoryName: Asn1Subject? = builder.directoryName
    /**
     * Represents GeneralName as a DNS name.
     */
    val dnsName: String? = builder.dnsName
    /**
     * Represents GeneralName as an EdiPartyName object.
     */
    val ediPartyName: EdiPartyName? = builder.ediPartyName
    /**
     * Represents GeneralName as an IPv4 or IPv6 address.
     */
    val ipAddress: String? = builder.ipAddress
    /**
     * Represents GeneralName using an OtherName object.
     */
    val otherName: OtherName? = builder.otherName
    /**
     * Represents GeneralName as an object identifier (OID).
     */
    val registeredId: String? = builder.registeredId
    /**
     * Represents GeneralName as an <a href="https://tools.ietf.org/html/rfc822">RFC 822 email address.
     */
    val rfc822Name: String? = builder.rfc822Name
    /**
     * Represents GeneralName as a URI.
     */
    val uniformResourceIdentifier: String? = builder.uniformResourceIdentifier

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GeneralName = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GeneralName(")
        append("directoryName=$directoryName,")
        append("dnsName=$dnsName,")
        append("ediPartyName=$ediPartyName,")
        append("ipAddress=$ipAddress,")
        append("otherName=$otherName,")
        append("registeredId=$registeredId,")
        append("rfc822Name=$rfc822Name,")
        append("uniformResourceIdentifier=$uniformResourceIdentifier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = directoryName?.hashCode() ?: 0
        result = 31 * result + (dnsName?.hashCode() ?: 0)
        result = 31 * result + (ediPartyName?.hashCode() ?: 0)
        result = 31 * result + (ipAddress?.hashCode() ?: 0)
        result = 31 * result + (otherName?.hashCode() ?: 0)
        result = 31 * result + (registeredId?.hashCode() ?: 0)
        result = 31 * result + (rfc822Name?.hashCode() ?: 0)
        result = 31 * result + (uniformResourceIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GeneralName

        if (directoryName != other.directoryName) return false
        if (dnsName != other.dnsName) return false
        if (ediPartyName != other.ediPartyName) return false
        if (ipAddress != other.ipAddress) return false
        if (otherName != other.otherName) return false
        if (registeredId != other.registeredId) return false
        if (rfc822Name != other.rfc822Name) return false
        if (uniformResourceIdentifier != other.uniformResourceIdentifier) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GeneralName = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GeneralName
        /**
         * Contains information about the certificate subject. The Subject field in
         * the certificate identifies the entity that owns or controls the public key in the
         * certificate. The entity can be a user, computer, device, or service. The Subject
         * must contain an X.500 distinguished name (DN). A DN is a sequence of relative
         * distinguished names (RDNs). The RDNs are separated by commas in the certificate.
         */
        fun directoryName(directoryName: Asn1Subject): FluentBuilder
        /**
         * Represents GeneralName as a DNS name.
         */
        fun dnsName(dnsName: String): FluentBuilder
        /**
         * Represents GeneralName as an EdiPartyName object.
         */
        fun ediPartyName(ediPartyName: EdiPartyName): FluentBuilder
        /**
         * Represents GeneralName as an IPv4 or IPv6 address.
         */
        fun ipAddress(ipAddress: String): FluentBuilder
        /**
         * Represents GeneralName using an OtherName object.
         */
        fun otherName(otherName: OtherName): FluentBuilder
        /**
         * Represents GeneralName as an object identifier (OID).
         */
        fun registeredId(registeredId: String): FluentBuilder
        /**
         * Represents GeneralName as an <a href="https://tools.ietf.org/html/rfc822">RFC 822 email address.
         */
        fun rfc822Name(rfc822Name: String): FluentBuilder
        /**
         * Represents GeneralName as a URI.
         */
        fun uniformResourceIdentifier(uniformResourceIdentifier: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Contains information about the certificate subject. The Subject field in
         * the certificate identifies the entity that owns or controls the public key in the
         * certificate. The entity can be a user, computer, device, or service. The Subject
         * must contain an X.500 distinguished name (DN). A DN is a sequence of relative
         * distinguished names (RDNs). The RDNs are separated by commas in the certificate.
         */
        var directoryName: Asn1Subject?
        /**
         * Represents GeneralName as a DNS name.
         */
        var dnsName: String?
        /**
         * Represents GeneralName as an EdiPartyName object.
         */
        var ediPartyName: EdiPartyName?
        /**
         * Represents GeneralName as an IPv4 or IPv6 address.
         */
        var ipAddress: String?
        /**
         * Represents GeneralName using an OtherName object.
         */
        var otherName: OtherName?
        /**
         * Represents GeneralName as an object identifier (OID).
         */
        var registeredId: String?
        /**
         * Represents GeneralName as an <a href="https://tools.ietf.org/html/rfc822">RFC 822 email address.
         */
        var rfc822Name: String?
        /**
         * Represents GeneralName as a URI.
         */
        var uniformResourceIdentifier: String?

        fun build(): GeneralName
        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.Asn1Subject] inside the given [block]
         */
        fun directoryName(block: Asn1Subject.DslBuilder.() -> kotlin.Unit) {
            this.directoryName = Asn1Subject.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.EdiPartyName] inside the given [block]
         */
        fun ediPartyName(block: EdiPartyName.DslBuilder.() -> kotlin.Unit) {
            this.ediPartyName = EdiPartyName.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.OtherName] inside the given [block]
         */
        fun otherName(block: OtherName.DslBuilder.() -> kotlin.Unit) {
            this.otherName = OtherName.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var directoryName: Asn1Subject? = null
        override var dnsName: String? = null
        override var ediPartyName: EdiPartyName? = null
        override var ipAddress: String? = null
        override var otherName: OtherName? = null
        override var registeredId: String? = null
        override var rfc822Name: String? = null
        override var uniformResourceIdentifier: String? = null

        constructor(x: GeneralName) : this() {
            this.directoryName = x.directoryName
            this.dnsName = x.dnsName
            this.ediPartyName = x.ediPartyName
            this.ipAddress = x.ipAddress
            this.otherName = x.otherName
            this.registeredId = x.registeredId
            this.rfc822Name = x.rfc822Name
            this.uniformResourceIdentifier = x.uniformResourceIdentifier
        }

        override fun build(): GeneralName = GeneralName(this)
        override fun directoryName(directoryName: Asn1Subject): FluentBuilder = apply { this.directoryName = directoryName }
        override fun dnsName(dnsName: String): FluentBuilder = apply { this.dnsName = dnsName }
        override fun ediPartyName(ediPartyName: EdiPartyName): FluentBuilder = apply { this.ediPartyName = ediPartyName }
        override fun ipAddress(ipAddress: String): FluentBuilder = apply { this.ipAddress = ipAddress }
        override fun otherName(otherName: OtherName): FluentBuilder = apply { this.otherName = otherName }
        override fun registeredId(registeredId: String): FluentBuilder = apply { this.registeredId = registeredId }
        override fun rfc822Name(rfc822Name: String): FluentBuilder = apply { this.rfc822Name = rfc822Name }
        override fun uniformResourceIdentifier(uniformResourceIdentifier: String): FluentBuilder = apply { this.uniformResourceIdentifier = uniformResourceIdentifier }
    }
}
