// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



/**
 * Specifies additional purposes for which the certified public key may be used other
 * than basic purposes indicated in the KeyUsage extension.
 */
class ExtendedKeyUsage private constructor(builder: BuilderImpl) {
    /**
     * Specifies a custom ExtendedKeyUsage with an object identifier
     * (OID).
     */
    val extendedKeyUsageObjectIdentifier: String? = builder.extendedKeyUsageObjectIdentifier
    /**
     * Specifies a standard ExtendedKeyUsage as defined as in <a href="https://tools.ietf.org/html/rfc5280#section-4.2.1.12">RFC 5280.
     */
    val extendedKeyUsageType: ExtendedKeyUsageType? = builder.extendedKeyUsageType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ExtendedKeyUsage = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ExtendedKeyUsage(")
        append("extendedKeyUsageObjectIdentifier=$extendedKeyUsageObjectIdentifier,")
        append("extendedKeyUsageType=$extendedKeyUsageType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = extendedKeyUsageObjectIdentifier?.hashCode() ?: 0
        result = 31 * result + (extendedKeyUsageType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ExtendedKeyUsage

        if (extendedKeyUsageObjectIdentifier != other.extendedKeyUsageObjectIdentifier) return false
        if (extendedKeyUsageType != other.extendedKeyUsageType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ExtendedKeyUsage = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ExtendedKeyUsage
        /**
         * Specifies a custom ExtendedKeyUsage with an object identifier
         * (OID).
         */
        fun extendedKeyUsageObjectIdentifier(extendedKeyUsageObjectIdentifier: String): FluentBuilder
        /**
         * Specifies a standard ExtendedKeyUsage as defined as in <a href="https://tools.ietf.org/html/rfc5280#section-4.2.1.12">RFC 5280.
         */
        fun extendedKeyUsageType(extendedKeyUsageType: ExtendedKeyUsageType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specifies a custom ExtendedKeyUsage with an object identifier
         * (OID).
         */
        var extendedKeyUsageObjectIdentifier: String?
        /**
         * Specifies a standard ExtendedKeyUsage as defined as in <a href="https://tools.ietf.org/html/rfc5280#section-4.2.1.12">RFC 5280.
         */
        var extendedKeyUsageType: ExtendedKeyUsageType?

        fun build(): ExtendedKeyUsage
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var extendedKeyUsageObjectIdentifier: String? = null
        override var extendedKeyUsageType: ExtendedKeyUsageType? = null

        constructor(x: ExtendedKeyUsage) : this() {
            this.extendedKeyUsageObjectIdentifier = x.extendedKeyUsageObjectIdentifier
            this.extendedKeyUsageType = x.extendedKeyUsageType
        }

        override fun build(): ExtendedKeyUsage = ExtendedKeyUsage(this)
        override fun extendedKeyUsageObjectIdentifier(extendedKeyUsageObjectIdentifier: String): FluentBuilder = apply { this.extendedKeyUsageObjectIdentifier = extendedKeyUsageObjectIdentifier }
        override fun extendedKeyUsageType(extendedKeyUsageType: ExtendedKeyUsageType): FluentBuilder = apply { this.extendedKeyUsageType = extendedKeyUsageType }
    }
}
