// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



class DeletePermissionRequest private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Number (ARN) of the private CA that issued the permissions. You
     * can find the CA's ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities action. This must have the following form:
     * arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
     * .
     */
    val certificateAuthorityArn: String? = builder.certificateAuthorityArn
    /**
     * The AWS service or identity that will have its CA permissions revoked. At this time,
     * the only valid service principal is acm.amazonaws.com
     */
    val principal: String? = builder.principal
    /**
     * The AWS account that calls this action.
     */
    val sourceAccount: String? = builder.sourceAccount

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DeletePermissionRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DeletePermissionRequest(")
        append("certificateAuthorityArn=$certificateAuthorityArn,")
        append("principal=$principal,")
        append("sourceAccount=$sourceAccount)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateAuthorityArn?.hashCode() ?: 0
        result = 31 * result + (principal?.hashCode() ?: 0)
        result = 31 * result + (sourceAccount?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DeletePermissionRequest

        if (certificateAuthorityArn != other.certificateAuthorityArn) return false
        if (principal != other.principal) return false
        if (sourceAccount != other.sourceAccount) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DeletePermissionRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DeletePermissionRequest
        /**
         * The Amazon Resource Number (ARN) of the private CA that issued the permissions. You
         * can find the CA's ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities action. This must have the following form:
         * arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
         * .
         */
        fun certificateAuthorityArn(certificateAuthorityArn: String): FluentBuilder
        /**
         * The AWS service or identity that will have its CA permissions revoked. At this time,
         * the only valid service principal is acm.amazonaws.com
         */
        fun principal(principal: String): FluentBuilder
        /**
         * The AWS account that calls this action.
         */
        fun sourceAccount(sourceAccount: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Number (ARN) of the private CA that issued the permissions. You
         * can find the CA's ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities action. This must have the following form:
         * arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
         * .
         */
        var certificateAuthorityArn: String?
        /**
         * The AWS service or identity that will have its CA permissions revoked. At this time,
         * the only valid service principal is acm.amazonaws.com
         */
        var principal: String?
        /**
         * The AWS account that calls this action.
         */
        var sourceAccount: String?

        fun build(): DeletePermissionRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var certificateAuthorityArn: String? = null
        override var principal: String? = null
        override var sourceAccount: String? = null

        constructor(x: DeletePermissionRequest) : this() {
            this.certificateAuthorityArn = x.certificateAuthorityArn
            this.principal = x.principal
            this.sourceAccount = x.sourceAccount
        }

        override fun build(): DeletePermissionRequest = DeletePermissionRequest(this)
        override fun certificateAuthorityArn(certificateAuthorityArn: String): FluentBuilder = apply { this.certificateAuthorityArn = certificateAuthorityArn }
        override fun principal(principal: String): FluentBuilder = apply { this.principal = principal }
        override fun sourceAccount(sourceAccount: String): FluentBuilder = apply { this.sourceAccount = sourceAccount }
    }
}
