// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



class CreatePermissionRequest private constructor(builder: BuilderImpl) {
    /**
     * The actions that the specified AWS service principal can use. These include
     * IssueCertificate, GetCertificate, and
     * ListPermissions.
     */
    val actions: List<ActionType>? = builder.actions
    /**
     * The Amazon Resource Name (ARN) of the CA that grants the permissions. You can find the
     * ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities action. This must have the following form:
     * arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
     * .
     */
    val certificateAuthorityArn: String? = builder.certificateAuthorityArn
    /**
     * The AWS service or identity that receives the permission. At this time, the only
     * valid principal is acm.amazonaws.com.
     */
    val principal: String? = builder.principal
    /**
     * The ID of the calling account.
     */
    val sourceAccount: String? = builder.sourceAccount

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreatePermissionRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreatePermissionRequest(")
        append("actions=$actions,")
        append("certificateAuthorityArn=$certificateAuthorityArn,")
        append("principal=$principal,")
        append("sourceAccount=$sourceAccount)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (certificateAuthorityArn?.hashCode() ?: 0)
        result = 31 * result + (principal?.hashCode() ?: 0)
        result = 31 * result + (sourceAccount?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreatePermissionRequest

        if (actions != other.actions) return false
        if (certificateAuthorityArn != other.certificateAuthorityArn) return false
        if (principal != other.principal) return false
        if (sourceAccount != other.sourceAccount) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreatePermissionRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreatePermissionRequest
        /**
         * The actions that the specified AWS service principal can use. These include
         * IssueCertificate, GetCertificate, and
         * ListPermissions.
         */
        fun actions(actions: List<ActionType>): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the CA that grants the permissions. You can find the
         * ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities action. This must have the following form:
         * arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
         * .
         */
        fun certificateAuthorityArn(certificateAuthorityArn: String): FluentBuilder
        /**
         * The AWS service or identity that receives the permission. At this time, the only
         * valid principal is acm.amazonaws.com.
         */
        fun principal(principal: String): FluentBuilder
        /**
         * The ID of the calling account.
         */
        fun sourceAccount(sourceAccount: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The actions that the specified AWS service principal can use. These include
         * IssueCertificate, GetCertificate, and
         * ListPermissions.
         */
        var actions: List<ActionType>?
        /**
         * The Amazon Resource Name (ARN) of the CA that grants the permissions. You can find the
         * ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities action. This must have the following form:
         * arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
         * .
         */
        var certificateAuthorityArn: String?
        /**
         * The AWS service or identity that receives the permission. At this time, the only
         * valid principal is acm.amazonaws.com.
         */
        var principal: String?
        /**
         * The ID of the calling account.
         */
        var sourceAccount: String?

        fun build(): CreatePermissionRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var actions: List<ActionType>? = null
        override var certificateAuthorityArn: String? = null
        override var principal: String? = null
        override var sourceAccount: String? = null

        constructor(x: CreatePermissionRequest) : this() {
            this.actions = x.actions
            this.certificateAuthorityArn = x.certificateAuthorityArn
            this.principal = x.principal
            this.sourceAccount = x.sourceAccount
        }

        override fun build(): CreatePermissionRequest = CreatePermissionRequest(this)
        override fun actions(actions: List<ActionType>): FluentBuilder = apply { this.actions = actions }
        override fun certificateAuthorityArn(certificateAuthorityArn: String): FluentBuilder = apply { this.certificateAuthorityArn = certificateAuthorityArn }
        override fun principal(principal: String): FluentBuilder = apply { this.principal = principal }
        override fun sourceAccount(sourceAccount: String): FluentBuilder = apply { this.sourceAccount = sourceAccount }
    }
}
