// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



class CreateCertificateAuthorityRequest private constructor(builder: BuilderImpl) {
    /**
     * Name and bit size of the private key algorithm, the name of the signing algorithm, and
     * X.500 certificate subject information.
     */
    val certificateAuthorityConfiguration: CertificateAuthorityConfiguration? = builder.certificateAuthorityConfiguration
    /**
     * The type of the certificate authority.
     */
    val certificateAuthorityType: CertificateAuthorityType? = builder.certificateAuthorityType
    /**
     * Custom string that can be used to distinguish between calls to the CreateCertificateAuthority action. Idempotency tokens for
     * CreateCertificateAuthority time out after five
     * minutes. Therefore, if you call CreateCertificateAuthority multiple times with the same idempotency
     * token within five minutes, ACM Private CA recognizes that you are requesting only certificate
     * authority and will issue only one. If you change the idempotency token for each call,
     * PCA recognizes that you are requesting multiple certificate authorities.
     */
    val idempotencyToken: String? = builder.idempotencyToken
    /**
     * Specifies a
     * cryptographic key management compliance standard used for handling CA keys.
     * Default: FIPS_140_2_LEVEL_3_OR_HIGHER
     * Note: FIPS_140_2_LEVEL_3_OR_HIGHER is not supported in Region
     * ap-northeast-3. When creating a CA in the ap-northeast-3, you must provide
     * FIPS_140_2_LEVEL_2_OR_HIGHER as the argument for
     * KeyStorageSecurityStandard. Failure to do this results in an
     * InvalidArgsException with the message, "A certificate authority cannot
     * be created in this region with the specified security standard."
     */
    val keyStorageSecurityStandard: KeyStorageSecurityStandard? = builder.keyStorageSecurityStandard
    /**
     * Contains information to enable Online Certificate Status Protocol (OCSP) support,
     * to enable a certificate revocation list (CRL), to enable both, or to enable neither. The
     * default is for both certificate validation mechanisms to be disabled. For more
     * information, see the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_OcspConfiguration.html">OcspConfiguration and <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CrlConfiguration.html">CrlConfiguration types.
     */
    val revocationConfiguration: RevocationConfiguration? = builder.revocationConfiguration
    /**
     * Key-value pairs that will be attached to the new private CA. You can associate up to
     * 50 tags with a private CA. For information using tags with IAM to manage permissions,
     * see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM Tags.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateCertificateAuthorityRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateCertificateAuthorityRequest(")
        append("certificateAuthorityConfiguration=$certificateAuthorityConfiguration,")
        append("certificateAuthorityType=$certificateAuthorityType,")
        append("idempotencyToken=$idempotencyToken,")
        append("keyStorageSecurityStandard=$keyStorageSecurityStandard,")
        append("revocationConfiguration=$revocationConfiguration,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateAuthorityConfiguration?.hashCode() ?: 0
        result = 31 * result + (certificateAuthorityType?.hashCode() ?: 0)
        result = 31 * result + (idempotencyToken?.hashCode() ?: 0)
        result = 31 * result + (keyStorageSecurityStandard?.hashCode() ?: 0)
        result = 31 * result + (revocationConfiguration?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateCertificateAuthorityRequest

        if (certificateAuthorityConfiguration != other.certificateAuthorityConfiguration) return false
        if (certificateAuthorityType != other.certificateAuthorityType) return false
        if (idempotencyToken != other.idempotencyToken) return false
        if (keyStorageSecurityStandard != other.keyStorageSecurityStandard) return false
        if (revocationConfiguration != other.revocationConfiguration) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateCertificateAuthorityRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateCertificateAuthorityRequest
        /**
         * Name and bit size of the private key algorithm, the name of the signing algorithm, and
         * X.500 certificate subject information.
         */
        fun certificateAuthorityConfiguration(certificateAuthorityConfiguration: CertificateAuthorityConfiguration): FluentBuilder
        /**
         * The type of the certificate authority.
         */
        fun certificateAuthorityType(certificateAuthorityType: CertificateAuthorityType): FluentBuilder
        /**
         * Custom string that can be used to distinguish between calls to the CreateCertificateAuthority action. Idempotency tokens for
         * CreateCertificateAuthority time out after five
         * minutes. Therefore, if you call CreateCertificateAuthority multiple times with the same idempotency
         * token within five minutes, ACM Private CA recognizes that you are requesting only certificate
         * authority and will issue only one. If you change the idempotency token for each call,
         * PCA recognizes that you are requesting multiple certificate authorities.
         */
        fun idempotencyToken(idempotencyToken: String): FluentBuilder
        /**
         * Specifies a
         * cryptographic key management compliance standard used for handling CA keys.
         * Default: FIPS_140_2_LEVEL_3_OR_HIGHER
         * Note: FIPS_140_2_LEVEL_3_OR_HIGHER is not supported in Region
         * ap-northeast-3. When creating a CA in the ap-northeast-3, you must provide
         * FIPS_140_2_LEVEL_2_OR_HIGHER as the argument for
         * KeyStorageSecurityStandard. Failure to do this results in an
         * InvalidArgsException with the message, "A certificate authority cannot
         * be created in this region with the specified security standard."
         */
        fun keyStorageSecurityStandard(keyStorageSecurityStandard: KeyStorageSecurityStandard): FluentBuilder
        /**
         * Contains information to enable Online Certificate Status Protocol (OCSP) support,
         * to enable a certificate revocation list (CRL), to enable both, or to enable neither. The
         * default is for both certificate validation mechanisms to be disabled. For more
         * information, see the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_OcspConfiguration.html">OcspConfiguration and <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CrlConfiguration.html">CrlConfiguration types.
         */
        fun revocationConfiguration(revocationConfiguration: RevocationConfiguration): FluentBuilder
        /**
         * Key-value pairs that will be attached to the new private CA. You can associate up to
         * 50 tags with a private CA. For information using tags with IAM to manage permissions,
         * see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM Tags.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Name and bit size of the private key algorithm, the name of the signing algorithm, and
         * X.500 certificate subject information.
         */
        var certificateAuthorityConfiguration: CertificateAuthorityConfiguration?
        /**
         * The type of the certificate authority.
         */
        var certificateAuthorityType: CertificateAuthorityType?
        /**
         * Custom string that can be used to distinguish between calls to the CreateCertificateAuthority action. Idempotency tokens for
         * CreateCertificateAuthority time out after five
         * minutes. Therefore, if you call CreateCertificateAuthority multiple times with the same idempotency
         * token within five minutes, ACM Private CA recognizes that you are requesting only certificate
         * authority and will issue only one. If you change the idempotency token for each call,
         * PCA recognizes that you are requesting multiple certificate authorities.
         */
        var idempotencyToken: String?
        /**
         * Specifies a
         * cryptographic key management compliance standard used for handling CA keys.
         * Default: FIPS_140_2_LEVEL_3_OR_HIGHER
         * Note: FIPS_140_2_LEVEL_3_OR_HIGHER is not supported in Region
         * ap-northeast-3. When creating a CA in the ap-northeast-3, you must provide
         * FIPS_140_2_LEVEL_2_OR_HIGHER as the argument for
         * KeyStorageSecurityStandard. Failure to do this results in an
         * InvalidArgsException with the message, "A certificate authority cannot
         * be created in this region with the specified security standard."
         */
        var keyStorageSecurityStandard: KeyStorageSecurityStandard?
        /**
         * Contains information to enable Online Certificate Status Protocol (OCSP) support,
         * to enable a certificate revocation list (CRL), to enable both, or to enable neither. The
         * default is for both certificate validation mechanisms to be disabled. For more
         * information, see the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_OcspConfiguration.html">OcspConfiguration and <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CrlConfiguration.html">CrlConfiguration types.
         */
        var revocationConfiguration: RevocationConfiguration?
        /**
         * Key-value pairs that will be attached to the new private CA. You can associate up to
         * 50 tags with a private CA. For information using tags with IAM to manage permissions,
         * see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM Tags.
         */
        var tags: List<Tag>?

        fun build(): CreateCertificateAuthorityRequest
        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.CertificateAuthorityConfiguration] inside the given [block]
         */
        fun certificateAuthorityConfiguration(block: CertificateAuthorityConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.certificateAuthorityConfiguration = CertificateAuthorityConfiguration.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.RevocationConfiguration] inside the given [block]
         */
        fun revocationConfiguration(block: RevocationConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.revocationConfiguration = RevocationConfiguration.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var certificateAuthorityConfiguration: CertificateAuthorityConfiguration? = null
        override var certificateAuthorityType: CertificateAuthorityType? = null
        override var idempotencyToken: String? = null
        override var keyStorageSecurityStandard: KeyStorageSecurityStandard? = null
        override var revocationConfiguration: RevocationConfiguration? = null
        override var tags: List<Tag>? = null

        constructor(x: CreateCertificateAuthorityRequest) : this() {
            this.certificateAuthorityConfiguration = x.certificateAuthorityConfiguration
            this.certificateAuthorityType = x.certificateAuthorityType
            this.idempotencyToken = x.idempotencyToken
            this.keyStorageSecurityStandard = x.keyStorageSecurityStandard
            this.revocationConfiguration = x.revocationConfiguration
            this.tags = x.tags
        }

        override fun build(): CreateCertificateAuthorityRequest = CreateCertificateAuthorityRequest(this)
        override fun certificateAuthorityConfiguration(certificateAuthorityConfiguration: CertificateAuthorityConfiguration): FluentBuilder = apply { this.certificateAuthorityConfiguration = certificateAuthorityConfiguration }
        override fun certificateAuthorityType(certificateAuthorityType: CertificateAuthorityType): FluentBuilder = apply { this.certificateAuthorityType = certificateAuthorityType }
        override fun idempotencyToken(idempotencyToken: String): FluentBuilder = apply { this.idempotencyToken = idempotencyToken }
        override fun keyStorageSecurityStandard(keyStorageSecurityStandard: KeyStorageSecurityStandard): FluentBuilder = apply { this.keyStorageSecurityStandard = keyStorageSecurityStandard }
        override fun revocationConfiguration(revocationConfiguration: RevocationConfiguration): FluentBuilder = apply { this.revocationConfiguration = revocationConfiguration }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
