// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



/**
 * Contains information about the certificate subject. The Subject field in
 * the certificate identifies the entity that owns or controls the public key in the
 * certificate. The entity can be a user, computer, device, or service. The Subject
 * must contain an X.500 distinguished name (DN). A DN is a sequence of relative
 * distinguished names (RDNs). The RDNs are separated by commas in the certificate.
 */
class Asn1Subject private constructor(builder: BuilderImpl) {
    /**
     * For CA and end-entity certificates in a private PKI, the common name (CN) can be any
     * string within the length limit.
     * Note: In publicly trusted certificates, the common name must be a fully qualified
     * domain name (FQDN) associated with the certificate subject.
     */
    val commonName: String? = builder.commonName
    /**
     * Two-digit code that specifies the country in which the certificate subject
     * located.
     */
    val country: String? = builder.country
    /**
     * Disambiguating information for the certificate subject.
     */
    val distinguishedNameQualifier: String? = builder.distinguishedNameQualifier
    /**
     * Typically a qualifier appended to the name of an individual. Examples include Jr. for
     * junior, Sr. for senior, and III for third.
     */
    val generationQualifier: String? = builder.generationQualifier
    /**
     * First name.
     */
    val givenName: String? = builder.givenName
    /**
     * Concatenation that typically contains the first letter of the GivenName, the first letter of the middle name if one exists, and the
     * first letter of the Surname.
     */
    val initials: String? = builder.initials
    /**
     * The locality (such as a city or town) in which the certificate subject is
     * located.
     */
    val locality: String? = builder.locality
    /**
     * Legal name of the organization with which the certificate subject is affiliated.
     */
    val organization: String? = builder.organization
    /**
     * A subdivision or unit of the organization (such as sales or finance) with which the
     * certificate subject is affiliated.
     */
    val organizationalUnit: String? = builder.organizationalUnit
    /**
     * Typically a shortened version of a longer GivenName.
     * For example, Jonathan is often shortened to John. Elizabeth is often shortened to Beth,
     * Liz, or Eliza.
     */
    val pseudonym: String? = builder.pseudonym
    /**
     * The certificate serial number.
     */
    val serialNumber: String? = builder.serialNumber
    /**
     * State in which the subject of the certificate is located.
     */
    val state: String? = builder.state
    /**
     * Family name. In the US and the UK, for example, the surname of an individual is
     * ordered last. In Asian cultures the surname is typically ordered first.
     */
    val surname: String? = builder.surname
    /**
     * A title such as Mr. or Ms., which is pre-pended to the name to refer formally to the
     * certificate subject.
     */
    val title: String? = builder.title

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Asn1Subject = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Asn1Subject(")
        append("commonName=$commonName,")
        append("country=$country,")
        append("distinguishedNameQualifier=$distinguishedNameQualifier,")
        append("generationQualifier=$generationQualifier,")
        append("givenName=$givenName,")
        append("initials=$initials,")
        append("locality=$locality,")
        append("organization=$organization,")
        append("organizationalUnit=$organizationalUnit,")
        append("pseudonym=$pseudonym,")
        append("serialNumber=$serialNumber,")
        append("state=$state,")
        append("surname=$surname,")
        append("title=$title)")
    }

    override fun hashCode(): kotlin.Int {
        var result = commonName?.hashCode() ?: 0
        result = 31 * result + (country?.hashCode() ?: 0)
        result = 31 * result + (distinguishedNameQualifier?.hashCode() ?: 0)
        result = 31 * result + (generationQualifier?.hashCode() ?: 0)
        result = 31 * result + (givenName?.hashCode() ?: 0)
        result = 31 * result + (initials?.hashCode() ?: 0)
        result = 31 * result + (locality?.hashCode() ?: 0)
        result = 31 * result + (organization?.hashCode() ?: 0)
        result = 31 * result + (organizationalUnit?.hashCode() ?: 0)
        result = 31 * result + (pseudonym?.hashCode() ?: 0)
        result = 31 * result + (serialNumber?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (surname?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Asn1Subject

        if (commonName != other.commonName) return false
        if (country != other.country) return false
        if (distinguishedNameQualifier != other.distinguishedNameQualifier) return false
        if (generationQualifier != other.generationQualifier) return false
        if (givenName != other.givenName) return false
        if (initials != other.initials) return false
        if (locality != other.locality) return false
        if (organization != other.organization) return false
        if (organizationalUnit != other.organizationalUnit) return false
        if (pseudonym != other.pseudonym) return false
        if (serialNumber != other.serialNumber) return false
        if (state != other.state) return false
        if (surname != other.surname) return false
        if (title != other.title) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Asn1Subject = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Asn1Subject
        /**
         * For CA and end-entity certificates in a private PKI, the common name (CN) can be any
         * string within the length limit.
         * Note: In publicly trusted certificates, the common name must be a fully qualified
         * domain name (FQDN) associated with the certificate subject.
         */
        fun commonName(commonName: String): FluentBuilder
        /**
         * Two-digit code that specifies the country in which the certificate subject
         * located.
         */
        fun country(country: String): FluentBuilder
        /**
         * Disambiguating information for the certificate subject.
         */
        fun distinguishedNameQualifier(distinguishedNameQualifier: String): FluentBuilder
        /**
         * Typically a qualifier appended to the name of an individual. Examples include Jr. for
         * junior, Sr. for senior, and III for third.
         */
        fun generationQualifier(generationQualifier: String): FluentBuilder
        /**
         * First name.
         */
        fun givenName(givenName: String): FluentBuilder
        /**
         * Concatenation that typically contains the first letter of the GivenName, the first letter of the middle name if one exists, and the
         * first letter of the Surname.
         */
        fun initials(initials: String): FluentBuilder
        /**
         * The locality (such as a city or town) in which the certificate subject is
         * located.
         */
        fun locality(locality: String): FluentBuilder
        /**
         * Legal name of the organization with which the certificate subject is affiliated.
         */
        fun organization(organization: String): FluentBuilder
        /**
         * A subdivision or unit of the organization (such as sales or finance) with which the
         * certificate subject is affiliated.
         */
        fun organizationalUnit(organizationalUnit: String): FluentBuilder
        /**
         * Typically a shortened version of a longer GivenName.
         * For example, Jonathan is often shortened to John. Elizabeth is often shortened to Beth,
         * Liz, or Eliza.
         */
        fun pseudonym(pseudonym: String): FluentBuilder
        /**
         * The certificate serial number.
         */
        fun serialNumber(serialNumber: String): FluentBuilder
        /**
         * State in which the subject of the certificate is located.
         */
        fun state(state: String): FluentBuilder
        /**
         * Family name. In the US and the UK, for example, the surname of an individual is
         * ordered last. In Asian cultures the surname is typically ordered first.
         */
        fun surname(surname: String): FluentBuilder
        /**
         * A title such as Mr. or Ms., which is pre-pended to the name to refer formally to the
         * certificate subject.
         */
        fun title(title: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * For CA and end-entity certificates in a private PKI, the common name (CN) can be any
         * string within the length limit.
         * Note: In publicly trusted certificates, the common name must be a fully qualified
         * domain name (FQDN) associated with the certificate subject.
         */
        var commonName: String?
        /**
         * Two-digit code that specifies the country in which the certificate subject
         * located.
         */
        var country: String?
        /**
         * Disambiguating information for the certificate subject.
         */
        var distinguishedNameQualifier: String?
        /**
         * Typically a qualifier appended to the name of an individual. Examples include Jr. for
         * junior, Sr. for senior, and III for third.
         */
        var generationQualifier: String?
        /**
         * First name.
         */
        var givenName: String?
        /**
         * Concatenation that typically contains the first letter of the GivenName, the first letter of the middle name if one exists, and the
         * first letter of the Surname.
         */
        var initials: String?
        /**
         * The locality (such as a city or town) in which the certificate subject is
         * located.
         */
        var locality: String?
        /**
         * Legal name of the organization with which the certificate subject is affiliated.
         */
        var organization: String?
        /**
         * A subdivision or unit of the organization (such as sales or finance) with which the
         * certificate subject is affiliated.
         */
        var organizationalUnit: String?
        /**
         * Typically a shortened version of a longer GivenName.
         * For example, Jonathan is often shortened to John. Elizabeth is often shortened to Beth,
         * Liz, or Eliza.
         */
        var pseudonym: String?
        /**
         * The certificate serial number.
         */
        var serialNumber: String?
        /**
         * State in which the subject of the certificate is located.
         */
        var state: String?
        /**
         * Family name. In the US and the UK, for example, the surname of an individual is
         * ordered last. In Asian cultures the surname is typically ordered first.
         */
        var surname: String?
        /**
         * A title such as Mr. or Ms., which is pre-pended to the name to refer formally to the
         * certificate subject.
         */
        var title: String?

        fun build(): Asn1Subject
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var commonName: String? = null
        override var country: String? = null
        override var distinguishedNameQualifier: String? = null
        override var generationQualifier: String? = null
        override var givenName: String? = null
        override var initials: String? = null
        override var locality: String? = null
        override var organization: String? = null
        override var organizationalUnit: String? = null
        override var pseudonym: String? = null
        override var serialNumber: String? = null
        override var state: String? = null
        override var surname: String? = null
        override var title: String? = null

        constructor(x: Asn1Subject) : this() {
            this.commonName = x.commonName
            this.country = x.country
            this.distinguishedNameQualifier = x.distinguishedNameQualifier
            this.generationQualifier = x.generationQualifier
            this.givenName = x.givenName
            this.initials = x.initials
            this.locality = x.locality
            this.organization = x.organization
            this.organizationalUnit = x.organizationalUnit
            this.pseudonym = x.pseudonym
            this.serialNumber = x.serialNumber
            this.state = x.state
            this.surname = x.surname
            this.title = x.title
        }

        override fun build(): Asn1Subject = Asn1Subject(this)
        override fun commonName(commonName: String): FluentBuilder = apply { this.commonName = commonName }
        override fun country(country: String): FluentBuilder = apply { this.country = country }
        override fun distinguishedNameQualifier(distinguishedNameQualifier: String): FluentBuilder = apply { this.distinguishedNameQualifier = distinguishedNameQualifier }
        override fun generationQualifier(generationQualifier: String): FluentBuilder = apply { this.generationQualifier = generationQualifier }
        override fun givenName(givenName: String): FluentBuilder = apply { this.givenName = givenName }
        override fun initials(initials: String): FluentBuilder = apply { this.initials = initials }
        override fun locality(locality: String): FluentBuilder = apply { this.locality = locality }
        override fun organization(organization: String): FluentBuilder = apply { this.organization = organization }
        override fun organizationalUnit(organizationalUnit: String): FluentBuilder = apply { this.organizationalUnit = organizationalUnit }
        override fun pseudonym(pseudonym: String): FluentBuilder = apply { this.pseudonym = pseudonym }
        override fun serialNumber(serialNumber: String): FluentBuilder = apply { this.serialNumber = serialNumber }
        override fun state(state: String): FluentBuilder = apply { this.state = state }
        override fun surname(surname: String): FluentBuilder = apply { this.surname = surname }
        override fun title(title: String): FluentBuilder = apply { this.title = title }
    }
}
