// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



/**
 * Contains X.509 certificate information to be placed in an issued certificate. An
 * APIPassthrough or APICSRPassthrough template variant must
 * be selected, or else this parameter is ignored.
 * If conflicting or duplicate certificate information is supplied from other sources,
 * ACM Private CA applies <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html#template-order-of-operations">order of
 * operation rules to determine what information is used.
 */
class ApiPassthrough private constructor(builder: BuilderImpl) {
    /**
     * Specifies X.509 extension information for a certificate.
     */
    val extensions: Extensions? = builder.extensions
    /**
     * Contains information about the certificate subject. The Subject field in
     * the certificate identifies the entity that owns or controls the public key in the
     * certificate. The entity can be a user, computer, device, or service. The Subject
     * must contain an X.500 distinguished name (DN). A DN is a sequence of relative
     * distinguished names (RDNs). The RDNs are separated by commas in the certificate.
     */
    val subject: Asn1Subject? = builder.subject

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ApiPassthrough = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ApiPassthrough(")
        append("extensions=$extensions,")
        append("subject=$subject)")
    }

    override fun hashCode(): kotlin.Int {
        var result = extensions?.hashCode() ?: 0
        result = 31 * result + (subject?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ApiPassthrough

        if (extensions != other.extensions) return false
        if (subject != other.subject) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ApiPassthrough = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ApiPassthrough
        /**
         * Specifies X.509 extension information for a certificate.
         */
        fun extensions(extensions: Extensions): FluentBuilder
        /**
         * Contains information about the certificate subject. The Subject field in
         * the certificate identifies the entity that owns or controls the public key in the
         * certificate. The entity can be a user, computer, device, or service. The Subject
         * must contain an X.500 distinguished name (DN). A DN is a sequence of relative
         * distinguished names (RDNs). The RDNs are separated by commas in the certificate.
         */
        fun subject(subject: Asn1Subject): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specifies X.509 extension information for a certificate.
         */
        var extensions: Extensions?
        /**
         * Contains information about the certificate subject. The Subject field in
         * the certificate identifies the entity that owns or controls the public key in the
         * certificate. The entity can be a user, computer, device, or service. The Subject
         * must contain an X.500 distinguished name (DN). A DN is a sequence of relative
         * distinguished names (RDNs). The RDNs are separated by commas in the certificate.
         */
        var subject: Asn1Subject?

        fun build(): ApiPassthrough
        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.Extensions] inside the given [block]
         */
        fun extensions(block: Extensions.DslBuilder.() -> kotlin.Unit) {
            this.extensions = Extensions.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.Asn1Subject] inside the given [block]
         */
        fun subject(block: Asn1Subject.DslBuilder.() -> kotlin.Unit) {
            this.subject = Asn1Subject.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var extensions: Extensions? = null
        override var subject: Asn1Subject? = null

        constructor(x: ApiPassthrough) : this() {
            this.extensions = x.extensions
            this.subject = x.subject
        }

        override fun build(): ApiPassthrough = ApiPassthrough(this)
        override fun extensions(extensions: Extensions): FluentBuilder = apply { this.extensions = extensions }
        override fun subject(subject: Asn1Subject): FluentBuilder = apply { this.subject = subject }
    }
}
