// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.EndpointResolver
import aws.sdk.kotlin.services.acmpca.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.acmpca.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * This is the ACM Private CA API Reference. It provides descriptions,
 * syntax, and usage examples for each of the actions and data types involved in creating
 * and managing private certificate authorities (CA) for your organization.
 * The documentation for each action shows the Query API request parameters and the XML
 * response. Alternatively, you can use one of the AWS SDKs to access an API that's
 * tailored to the programming language or platform that you're using. For more
 * information, see <a href="https://aws.amazon.com/tools/#SDKs">AWS
 * SDKs.
 * Each ACM Private CA API operation has a quota that determines the number of times the operation
 * can be called per second. ACM Private CA throttles API requests at different rates depending
 * on the operation. Throttling means that ACM Private CA rejects an otherwise valid request
 * because the request exceeds the operation's quota for the number of requests per second.
 * When a request is throttled, ACM Private CA returns a <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/CommonErrors.html">ThrottlingException error. ACM Private CA does not guarantee a minimum request
 * rate for APIs.
 * To see an up-to-date list of your ACM Private CA quotas, or to request a quota increase,
 * log into your AWS account and visit the <a href="https://console.aws.amazon.com/servicequotas/">Service Quotas
 * console.
 */
interface AcmPcaClient : SdkClient {

    override val serviceName: String
        get() = "ACM PCA"
    /**
     * AcmPcaClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.DslBuilder.() -> Unit = {}): AcmPcaClient {
            val config = Config.BuilderImpl().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
            }.apply(block).build()
            return DefaultAcmPcaClient(config)
        }

        operator fun invoke(config: Config): AcmPcaClient = DefaultAcmPcaClient(config)

        /**
         * Construct a [AcmPcaClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): AcmPcaClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return AcmPcaClient(sharedConfig)
        }
    }

    class Config private constructor(builder: BuilderImpl): AwsClientConfig, HttpClientConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: EndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            @JvmStatic
            fun fluentBuilder(): FluentBuilder = BuilderImpl()

            operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Config = BuilderImpl().apply(block).build()
        }

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: EndpointResolver?

            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: EndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
        }
    }

    /**
     * Creates a root or subordinate private certificate authority (CA). You must specify the
     * CA configuration, an optional configuration for Online Certificate Status Protocol (OCSP)
     * and/or a certificate revocation list (CRL), the CA type, and
     * an optional idempotency token to avoid accidental creation of multiple CAs. The CA
     * configuration specifies the name of the algorithm and key size to be used to create the
     * CA private key, the type of signing algorithm that the CA uses, and X.500 subject
     * information. The OCSP configuration can optionally specify a custom URL for the OCSP responder.
     * The CRL configuration specifies the CRL expiration period in days (the
     * validity period of the CRL), the Amazon S3 bucket that will contain the CRL, and a CNAME
     * alias for the S3 bucket that is included in certificates issued by the CA. If
     * successful, this action returns the Amazon Resource Name (ARN) of the CA.
     * ACM Private CA assets that are stored in Amazon S3 can be protected with encryption.
     * For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCreateCa.html#crl-encryption">Encrypting Your
     * CRLs.
     * Both PCA and the IAM principal must have permission to write to
     * the S3 bucket that you specify. If the IAM principal making the call
     * does not have permission to write to the bucket, then an exception is
     * thrown. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaAuthAccess.html">Configure
     * Access to ACM Private CA.
     */
    suspend fun createCertificateAuthority(input: CreateCertificateAuthorityRequest): CreateCertificateAuthorityResponse

    /**
     * Creates a root or subordinate private certificate authority (CA). You must specify the
     * CA configuration, an optional configuration for Online Certificate Status Protocol (OCSP)
     * and/or a certificate revocation list (CRL), the CA type, and
     * an optional idempotency token to avoid accidental creation of multiple CAs. The CA
     * configuration specifies the name of the algorithm and key size to be used to create the
     * CA private key, the type of signing algorithm that the CA uses, and X.500 subject
     * information. The OCSP configuration can optionally specify a custom URL for the OCSP responder.
     * The CRL configuration specifies the CRL expiration period in days (the
     * validity period of the CRL), the Amazon S3 bucket that will contain the CRL, and a CNAME
     * alias for the S3 bucket that is included in certificates issued by the CA. If
     * successful, this action returns the Amazon Resource Name (ARN) of the CA.
     * ACM Private CA assets that are stored in Amazon S3 can be protected with encryption.
     * For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCreateCa.html#crl-encryption">Encrypting Your
     * CRLs.
     * Both PCA and the IAM principal must have permission to write to
     * the S3 bucket that you specify. If the IAM principal making the call
     * does not have permission to write to the bucket, then an exception is
     * thrown. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaAuthAccess.html">Configure
     * Access to ACM Private CA.
     */
    suspend fun createCertificateAuthority(block: CreateCertificateAuthorityRequest.DslBuilder.() -> Unit) = createCertificateAuthority(CreateCertificateAuthorityRequest.builder().apply(block).build())

    /**
     * Creates an audit report that lists every time that your CA private key is used. The
     * report is saved in the Amazon S3 bucket that you specify on input.
     * The <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_IssueCertificate.html">IssueCertificate and <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_RevokeCertificate.html">RevokeCertificate actions use
     * the private key.
     * Both PCA and the IAM principal must have permission to write to
     * the S3 bucket that you specify. If the IAM principal making the call
     * does not have permission to write to the bucket, then an exception is
     * thrown. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaAuthAccess.html">Configure
     * Access to ACM Private CA.
     * ACM Private CA assets that are stored in Amazon S3 can be protected with encryption.
     * For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaAuditReport.html#audit-report-encryption">Encrypting Your Audit
     * Reports.
     */
    suspend fun createCertificateAuthorityAuditReport(input: CreateCertificateAuthorityAuditReportRequest): CreateCertificateAuthorityAuditReportResponse

    /**
     * Creates an audit report that lists every time that your CA private key is used. The
     * report is saved in the Amazon S3 bucket that you specify on input.
     * The <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_IssueCertificate.html">IssueCertificate and <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_RevokeCertificate.html">RevokeCertificate actions use
     * the private key.
     * Both PCA and the IAM principal must have permission to write to
     * the S3 bucket that you specify. If the IAM principal making the call
     * does not have permission to write to the bucket, then an exception is
     * thrown. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaAuthAccess.html">Configure
     * Access to ACM Private CA.
     * ACM Private CA assets that are stored in Amazon S3 can be protected with encryption.
     * For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaAuditReport.html#audit-report-encryption">Encrypting Your Audit
     * Reports.
     */
    suspend fun createCertificateAuthorityAuditReport(block: CreateCertificateAuthorityAuditReportRequest.DslBuilder.() -> Unit) = createCertificateAuthorityAuditReport(CreateCertificateAuthorityAuditReportRequest.builder().apply(block).build())

    /**
     * Grants one or more permissions on a private CA to the AWS Certificate Manager (ACM) service
     * principal (acm.amazonaws.com). These permissions allow ACM to issue and
     * renew ACM certificates that reside in the same AWS account as the CA.
     * You can list current permissions with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListPermissions.html">ListPermissions action and
     * revoke them with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePermission.html">DeletePermission action.
     * <p class="title">
     * About Permissions
     * If the private CA and the certificates it issues reside in the same
     * account, you can use CreatePermission to grant permissions for ACM to
     * carry out automatic certificate renewals.
     * For automatic certificate renewal to succeed, the ACM service principal
     * needs permissions to create, retrieve, and list certificates.
     * If the private CA and the ACM certificates reside in different accounts,
     * then permissions cannot be used to enable automatic renewals. Instead,
     * the ACM certificate owner must set up a resource-based policy to enable
     * cross-account issuance and renewals. For more information, see
     * <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html">Using a Resource
     * Based Policy with ACM Private CA.
     */
    suspend fun createPermission(input: CreatePermissionRequest): CreatePermissionResponse

    /**
     * Grants one or more permissions on a private CA to the AWS Certificate Manager (ACM) service
     * principal (acm.amazonaws.com). These permissions allow ACM to issue and
     * renew ACM certificates that reside in the same AWS account as the CA.
     * You can list current permissions with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListPermissions.html">ListPermissions action and
     * revoke them with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePermission.html">DeletePermission action.
     * <p class="title">
     * About Permissions
     * If the private CA and the certificates it issues reside in the same
     * account, you can use CreatePermission to grant permissions for ACM to
     * carry out automatic certificate renewals.
     * For automatic certificate renewal to succeed, the ACM service principal
     * needs permissions to create, retrieve, and list certificates.
     * If the private CA and the ACM certificates reside in different accounts,
     * then permissions cannot be used to enable automatic renewals. Instead,
     * the ACM certificate owner must set up a resource-based policy to enable
     * cross-account issuance and renewals. For more information, see
     * <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html">Using a Resource
     * Based Policy with ACM Private CA.
     */
    suspend fun createPermission(block: CreatePermissionRequest.DslBuilder.() -> Unit) = createPermission(CreatePermissionRequest.builder().apply(block).build())

    /**
     * Deletes a private certificate authority (CA). You must provide the Amazon Resource
     * Name (ARN) of the private CA that you want to delete. You can find the ARN by calling
     * the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities action.
     * Deleting a CA will invalidate other CAs and certificates below it in your CA
     * hierarchy.
     * Before you can delete a CA that you have created and activated, you must disable it.
     * To do this, call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html">UpdateCertificateAuthority action and set the CertificateAuthorityStatus parameter to DISABLED.
     * Additionally, you can delete a CA if you are waiting for it to be created (that is,
     * the status of the CA is CREATING). You can also delete it if the CA has
     * been created but you haven't yet imported the signed certificate into ACM Private CA (that is,
     * the status of the CA is PENDING_CERTIFICATE).
     * When you successfully call <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeleteCertificateAuthority.html">DeleteCertificateAuthority, the CA's status changes to
     * DELETED. However, the CA won't be permanently deleted until the restoration
     * period has passed. By default, if you do not set the
     * PermanentDeletionTimeInDays parameter, the CA remains restorable for 30
     * days. You can set the parameter from 7 to 30 days. The <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DescribeCertificateAuthority.html">DescribeCertificateAuthority action returns the time remaining in the
     * restoration window of a private CA in the DELETED state. To restore an
     * eligible CA, call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_RestoreCertificateAuthority.html">RestoreCertificateAuthority action.
     */
    suspend fun deleteCertificateAuthority(input: DeleteCertificateAuthorityRequest): DeleteCertificateAuthorityResponse

    /**
     * Deletes a private certificate authority (CA). You must provide the Amazon Resource
     * Name (ARN) of the private CA that you want to delete. You can find the ARN by calling
     * the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities action.
     * Deleting a CA will invalidate other CAs and certificates below it in your CA
     * hierarchy.
     * Before you can delete a CA that you have created and activated, you must disable it.
     * To do this, call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html">UpdateCertificateAuthority action and set the CertificateAuthorityStatus parameter to DISABLED.
     * Additionally, you can delete a CA if you are waiting for it to be created (that is,
     * the status of the CA is CREATING). You can also delete it if the CA has
     * been created but you haven't yet imported the signed certificate into ACM Private CA (that is,
     * the status of the CA is PENDING_CERTIFICATE).
     * When you successfully call <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeleteCertificateAuthority.html">DeleteCertificateAuthority, the CA's status changes to
     * DELETED. However, the CA won't be permanently deleted until the restoration
     * period has passed. By default, if you do not set the
     * PermanentDeletionTimeInDays parameter, the CA remains restorable for 30
     * days. You can set the parameter from 7 to 30 days. The <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DescribeCertificateAuthority.html">DescribeCertificateAuthority action returns the time remaining in the
     * restoration window of a private CA in the DELETED state. To restore an
     * eligible CA, call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_RestoreCertificateAuthority.html">RestoreCertificateAuthority action.
     */
    suspend fun deleteCertificateAuthority(block: DeleteCertificateAuthorityRequest.DslBuilder.() -> Unit) = deleteCertificateAuthority(DeleteCertificateAuthorityRequest.builder().apply(block).build())

    /**
     * Revokes permissions on a private CA granted to the AWS Certificate Manager (ACM) service principal
     * (acm.amazonaws.com).
     * These permissions allow ACM to issue and renew ACM certificates that reside in the
     * same AWS account as the CA. If you revoke these permissions, ACM will no longer
     * renew the affected certificates automatically.
     * Permissions can be granted with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreatePermission.html">CreatePermission action and
     * listed with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListPermissions.html">ListPermissions action.
     * <p class="title">
     * About Permissions
     * If the private CA and the certificates it issues reside in the same
     * account, you can use CreatePermission to grant permissions for ACM to
     * carry out automatic certificate renewals.
     * For automatic certificate renewal to succeed, the ACM service principal
     * needs permissions to create, retrieve, and list certificates.
     * If the private CA and the ACM certificates reside in different accounts,
     * then permissions cannot be used to enable automatic renewals. Instead,
     * the ACM certificate owner must set up a resource-based policy to enable
     * cross-account issuance and renewals. For more information, see
     * <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html">Using a Resource
     * Based Policy with ACM Private CA.
     */
    suspend fun deletePermission(input: DeletePermissionRequest): DeletePermissionResponse

    /**
     * Revokes permissions on a private CA granted to the AWS Certificate Manager (ACM) service principal
     * (acm.amazonaws.com).
     * These permissions allow ACM to issue and renew ACM certificates that reside in the
     * same AWS account as the CA. If you revoke these permissions, ACM will no longer
     * renew the affected certificates automatically.
     * Permissions can be granted with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreatePermission.html">CreatePermission action and
     * listed with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListPermissions.html">ListPermissions action.
     * <p class="title">
     * About Permissions
     * If the private CA and the certificates it issues reside in the same
     * account, you can use CreatePermission to grant permissions for ACM to
     * carry out automatic certificate renewals.
     * For automatic certificate renewal to succeed, the ACM service principal
     * needs permissions to create, retrieve, and list certificates.
     * If the private CA and the ACM certificates reside in different accounts,
     * then permissions cannot be used to enable automatic renewals. Instead,
     * the ACM certificate owner must set up a resource-based policy to enable
     * cross-account issuance and renewals. For more information, see
     * <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html">Using a Resource
     * Based Policy with ACM Private CA.
     */
    suspend fun deletePermission(block: DeletePermissionRequest.DslBuilder.() -> Unit) = deletePermission(DeletePermissionRequest.builder().apply(block).build())

    /**
     * Deletes the resource-based policy attached to a private CA. Deletion will remove any
     * access that the policy has granted. If there is no policy attached to the private CA,
     * this action will return successful.
     * If you delete a policy that was applied through AWS Resource Access Manager (RAM), the
     * CA will be removed from all shares in which it was included.
     * The AWS Certificate Manager Service Linked Role that the policy supports is not affected when you
     * delete the policy.
     * The current policy can be shown with <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetPolicy.html">GetPolicy and updated with <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_PutPolicy.html">PutPolicy.
     * <p class="title">
     * About Policies
     * A policy grants access on a private CA to an AWS customer account, to AWS Organizations, or to
     * an AWS Organizations unit. Policies are under the control of a CA administrator. For more information,
     * see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html">Using a Resource Based Policy with ACM Private CA.
     * A policy permits a user of AWS Certificate Manager (ACM) to issue ACM certificates
     * signed by a CA in another account.
     * For ACM to manage automatic renewal of these certificates,
     * the ACM user must configure a Service Linked Role (SLR). The SLR allows
     * the ACM service to assume the identity of the user, subject to confirmation against the
     * ACM Private CA policy. For more information, see
     * <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-slr.html">Using a
     * Service Linked Role with ACM.
     * Updates made in AWS Resource Manager (RAM) are reflected in policies. For more information,
     * see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-ram.html">Attach a Policy for Cross-Account
     * Access.
     */
    suspend fun deletePolicy(input: DeletePolicyRequest): DeletePolicyResponse

    /**
     * Deletes the resource-based policy attached to a private CA. Deletion will remove any
     * access that the policy has granted. If there is no policy attached to the private CA,
     * this action will return successful.
     * If you delete a policy that was applied through AWS Resource Access Manager (RAM), the
     * CA will be removed from all shares in which it was included.
     * The AWS Certificate Manager Service Linked Role that the policy supports is not affected when you
     * delete the policy.
     * The current policy can be shown with <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetPolicy.html">GetPolicy and updated with <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_PutPolicy.html">PutPolicy.
     * <p class="title">
     * About Policies
     * A policy grants access on a private CA to an AWS customer account, to AWS Organizations, or to
     * an AWS Organizations unit. Policies are under the control of a CA administrator. For more information,
     * see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html">Using a Resource Based Policy with ACM Private CA.
     * A policy permits a user of AWS Certificate Manager (ACM) to issue ACM certificates
     * signed by a CA in another account.
     * For ACM to manage automatic renewal of these certificates,
     * the ACM user must configure a Service Linked Role (SLR). The SLR allows
     * the ACM service to assume the identity of the user, subject to confirmation against the
     * ACM Private CA policy. For more information, see
     * <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-slr.html">Using a
     * Service Linked Role with ACM.
     * Updates made in AWS Resource Manager (RAM) are reflected in policies. For more information,
     * see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-ram.html">Attach a Policy for Cross-Account
     * Access.
     */
    suspend fun deletePolicy(block: DeletePolicyRequest.DslBuilder.() -> Unit) = deletePolicy(DeletePolicyRequest.builder().apply(block).build())

    /**
     * Lists information about your private certificate authority (CA) or one that has been
     * shared with you. You specify the private CA on input by its ARN (Amazon Resource Name).
     * The output contains the status of your CA. This can be any of the following:
     * CREATING - ACM Private CA is creating your private certificate
     * authority.
     * PENDING_CERTIFICATE - The certificate is pending. You must use
     * your ACM Private CA-hosted or on-premises root or subordinate CA to sign your private CA
     * CSR and then import it into PCA.
     * ACTIVE - Your private CA is active.
     * DISABLED - Your private CA has been disabled.
     * EXPIRED - Your private CA certificate has expired.
     * FAILED - Your private CA has failed. Your CA can fail because of
     * problems such a network outage or back-end AWS failure or other errors. A
     * failed CA can never return to the pending state. You must create a new CA.
     * DELETED - Your private CA is within the restoration period, after
     * which it is permanently deleted. The length of time remaining in the CA's
     * restoration period is also included in this action's output.
     */
    suspend fun describeCertificateAuthority(input: DescribeCertificateAuthorityRequest): DescribeCertificateAuthorityResponse

    /**
     * Lists information about your private certificate authority (CA) or one that has been
     * shared with you. You specify the private CA on input by its ARN (Amazon Resource Name).
     * The output contains the status of your CA. This can be any of the following:
     * CREATING - ACM Private CA is creating your private certificate
     * authority.
     * PENDING_CERTIFICATE - The certificate is pending. You must use
     * your ACM Private CA-hosted or on-premises root or subordinate CA to sign your private CA
     * CSR and then import it into PCA.
     * ACTIVE - Your private CA is active.
     * DISABLED - Your private CA has been disabled.
     * EXPIRED - Your private CA certificate has expired.
     * FAILED - Your private CA has failed. Your CA can fail because of
     * problems such a network outage or back-end AWS failure or other errors. A
     * failed CA can never return to the pending state. You must create a new CA.
     * DELETED - Your private CA is within the restoration period, after
     * which it is permanently deleted. The length of time remaining in the CA's
     * restoration period is also included in this action's output.
     */
    suspend fun describeCertificateAuthority(block: DescribeCertificateAuthorityRequest.DslBuilder.() -> Unit) = describeCertificateAuthority(DescribeCertificateAuthorityRequest.builder().apply(block).build())

    /**
     * Lists information about a specific audit report created by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html">CreateCertificateAuthorityAuditReport action. Audit information is created
     * every time the certificate authority (CA) private key is used. The private key is used
     * when you call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_IssueCertificate.html">IssueCertificate action or the
     * <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_RevokeCertificate.html">RevokeCertificate action.
     */
    suspend fun describeCertificateAuthorityAuditReport(input: DescribeCertificateAuthorityAuditReportRequest): DescribeCertificateAuthorityAuditReportResponse

    /**
     * Lists information about a specific audit report created by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html">CreateCertificateAuthorityAuditReport action. Audit information is created
     * every time the certificate authority (CA) private key is used. The private key is used
     * when you call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_IssueCertificate.html">IssueCertificate action or the
     * <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_RevokeCertificate.html">RevokeCertificate action.
     */
    suspend fun describeCertificateAuthorityAuditReport(block: DescribeCertificateAuthorityAuditReportRequest.DslBuilder.() -> Unit) = describeCertificateAuthorityAuditReport(DescribeCertificateAuthorityAuditReportRequest.builder().apply(block).build())

    /**
     * Retrieves a certificate from your private CA or one that has been shared with you. The
     * ARN of the certificate is returned when you call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_IssueCertificate.html">IssueCertificate action. You
     * must specify both the ARN of your private CA and the ARN of the issued certificate when
     * calling the GetCertificate action. You can retrieve the
     * certificate if it is in the ISSUED state. You can call
     * the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html">CreateCertificateAuthorityAuditReport action to create a report that
     * contains information about all of the certificates issued and revoked by your private
     * CA.
     */
    suspend fun getCertificate(input: GetCertificateRequest): GetCertificateResponse

    /**
     * Retrieves a certificate from your private CA or one that has been shared with you. The
     * ARN of the certificate is returned when you call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_IssueCertificate.html">IssueCertificate action. You
     * must specify both the ARN of your private CA and the ARN of the issued certificate when
     * calling the GetCertificate action. You can retrieve the
     * certificate if it is in the ISSUED state. You can call
     * the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html">CreateCertificateAuthorityAuditReport action to create a report that
     * contains information about all of the certificates issued and revoked by your private
     * CA.
     */
    suspend fun getCertificate(block: GetCertificateRequest.DslBuilder.() -> Unit) = getCertificate(GetCertificateRequest.builder().apply(block).build())

    /**
     * Retrieves the certificate and certificate chain for your private certificate authority
     * (CA) or one that has been shared with you. Both the certificate and the chain are base64
     * PEM-encoded. The chain does not include the CA certificate. Each certificate in the
     * chain signs the one before it.
     */
    suspend fun getCertificateAuthorityCertificate(input: GetCertificateAuthorityCertificateRequest): GetCertificateAuthorityCertificateResponse

    /**
     * Retrieves the certificate and certificate chain for your private certificate authority
     * (CA) or one that has been shared with you. Both the certificate and the chain are base64
     * PEM-encoded. The chain does not include the CA certificate. Each certificate in the
     * chain signs the one before it.
     */
    suspend fun getCertificateAuthorityCertificate(block: GetCertificateAuthorityCertificateRequest.DslBuilder.() -> Unit) = getCertificateAuthorityCertificate(GetCertificateAuthorityCertificateRequest.builder().apply(block).build())

    /**
     * Retrieves the certificate signing request (CSR) for your private certificate authority
     * (CA). The CSR is created when you call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority action. Sign the CSR with your ACM Private CA-hosted or
     * on-premises root or subordinate CA. Then import the signed certificate back into ACM Private CA
     * by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ImportCertificateAuthorityCertificate.html">ImportCertificateAuthorityCertificate action. The CSR is returned as a
     * base64 PEM-encoded string.
     */
    suspend fun getCertificateAuthorityCsr(input: GetCertificateAuthorityCsrRequest): GetCertificateAuthorityCsrResponse

    /**
     * Retrieves the certificate signing request (CSR) for your private certificate authority
     * (CA). The CSR is created when you call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority action. Sign the CSR with your ACM Private CA-hosted or
     * on-premises root or subordinate CA. Then import the signed certificate back into ACM Private CA
     * by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ImportCertificateAuthorityCertificate.html">ImportCertificateAuthorityCertificate action. The CSR is returned as a
     * base64 PEM-encoded string.
     */
    suspend fun getCertificateAuthorityCsr(block: GetCertificateAuthorityCsrRequest.DslBuilder.() -> Unit) = getCertificateAuthorityCsr(GetCertificateAuthorityCsrRequest.builder().apply(block).build())

    /**
     * Retrieves the resource-based policy attached to a private CA. If either the private CA
     * resource or the policy cannot be found, this action returns a
     * ResourceNotFoundException.
     * The policy can be attached or updated with <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_PutPolicy.html">PutPolicy and removed with <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePolicy.html">DeletePolicy.
     * <p class="title">
     * About Policies
     * A policy grants access on a private CA to an AWS customer account, to AWS Organizations, or to
     * an AWS Organizations unit. Policies are under the control of a CA administrator. For more information,
     * see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html">Using a Resource Based Policy with ACM Private CA.
     * A policy permits a user of AWS Certificate Manager (ACM) to issue ACM certificates
     * signed by a CA in another account.
     * For ACM to manage automatic renewal of these certificates,
     * the ACM user must configure a Service Linked Role (SLR). The SLR allows
     * the ACM service to assume the identity of the user, subject to confirmation against the
     * ACM Private CA policy. For more information, see
     * <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-slr.html">Using a
     * Service Linked Role with ACM.
     * Updates made in AWS Resource Manager (RAM) are reflected in policies. For more information,
     * see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-ram.html">Attach a Policy for Cross-Account
     * Access.
     */
    suspend fun getPolicy(input: GetPolicyRequest): GetPolicyResponse

    /**
     * Retrieves the resource-based policy attached to a private CA. If either the private CA
     * resource or the policy cannot be found, this action returns a
     * ResourceNotFoundException.
     * The policy can be attached or updated with <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_PutPolicy.html">PutPolicy and removed with <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePolicy.html">DeletePolicy.
     * <p class="title">
     * About Policies
     * A policy grants access on a private CA to an AWS customer account, to AWS Organizations, or to
     * an AWS Organizations unit. Policies are under the control of a CA administrator. For more information,
     * see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html">Using a Resource Based Policy with ACM Private CA.
     * A policy permits a user of AWS Certificate Manager (ACM) to issue ACM certificates
     * signed by a CA in another account.
     * For ACM to manage automatic renewal of these certificates,
     * the ACM user must configure a Service Linked Role (SLR). The SLR allows
     * the ACM service to assume the identity of the user, subject to confirmation against the
     * ACM Private CA policy. For more information, see
     * <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-slr.html">Using a
     * Service Linked Role with ACM.
     * Updates made in AWS Resource Manager (RAM) are reflected in policies. For more information,
     * see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-ram.html">Attach a Policy for Cross-Account
     * Access.
     */
    suspend fun getPolicy(block: GetPolicyRequest.DslBuilder.() -> Unit) = getPolicy(GetPolicyRequest.builder().apply(block).build())

    /**
     * Imports a signed private CA certificate into ACM Private CA. This action is used when you are
     * using a chain of trust whose root is located outside ACM Private CA. Before you can call this
     * action, the following preparations must in place:
     * <ol>
     * In ACM Private CA, call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority action to create the private CA that you
     * plan to back with the imported certificate.
     * Call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificateAuthorityCsr.html">GetCertificateAuthorityCsr action to generate a certificate signing
     * request (CSR).
     * Sign the CSR using a root or intermediate CA hosted by either an on-premises
     * PKI hierarchy or by a commercial CA.
     * Create a certificate chain and copy the signed certificate and the certificate
     * chain to your working directory.
     * </ol>
     * ACM Private CA supports three scenarios for installing a CA certificate:
     * Installing a certificate for a root CA hosted by ACM Private CA.
     * Installing a subordinate CA certificate whose parent authority is hosted by
     * ACM Private CA.
     * Installing a subordinate CA certificate whose parent authority is externally
     * hosted.
     * The following additional requirements apply when you import a CA certificate.
     * Only a self-signed certificate can be imported as a root CA.
     * A self-signed certificate cannot be imported as a subordinate CA.
     * Your certificate chain must not include the private CA certificate that you
     * are importing.
     * Your root CA must be the last certificate in your chain. The subordinate
     * certificate, if any, that your root CA signed must be next to last. The
     * subordinate certificate signed by the preceding subordinate CA must come next,
     * and so on until your chain is built.
     * The chain must be PEM-encoded.
     * The maximum allowed size of a certificate is 32 KB.
     * The maximum allowed size of a certificate chain is 2 MB.
     * Enforcement of Critical Constraints
     * ACM Private CA allows the following extensions to be marked critical in the imported CA
     * certificate or chain.
     * Basic constraints (must be marked critical)
     * Subject alternative names
     * Key usage
     * Extended key usage
     * Authority key identifier
     * Subject key identifier
     * Issuer alternative name
     * Subject directory attributes
     * Subject information access
     * Certificate policies
     * Policy mappings
     * Inhibit anyPolicy
     * ACM Private CA rejects the following extensions when they are marked critical in an imported CA
     * certificate or chain.
     * Name constraints
     * Policy constraints
     * CRL distribution points
     * Authority information access
     * Freshest CRL
     * Any other extension
     */
    suspend fun importCertificateAuthorityCertificate(input: ImportCertificateAuthorityCertificateRequest): ImportCertificateAuthorityCertificateResponse

    /**
     * Imports a signed private CA certificate into ACM Private CA. This action is used when you are
     * using a chain of trust whose root is located outside ACM Private CA. Before you can call this
     * action, the following preparations must in place:
     * <ol>
     * In ACM Private CA, call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority action to create the private CA that you
     * plan to back with the imported certificate.
     * Call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificateAuthorityCsr.html">GetCertificateAuthorityCsr action to generate a certificate signing
     * request (CSR).
     * Sign the CSR using a root or intermediate CA hosted by either an on-premises
     * PKI hierarchy or by a commercial CA.
     * Create a certificate chain and copy the signed certificate and the certificate
     * chain to your working directory.
     * </ol>
     * ACM Private CA supports three scenarios for installing a CA certificate:
     * Installing a certificate for a root CA hosted by ACM Private CA.
     * Installing a subordinate CA certificate whose parent authority is hosted by
     * ACM Private CA.
     * Installing a subordinate CA certificate whose parent authority is externally
     * hosted.
     * The following additional requirements apply when you import a CA certificate.
     * Only a self-signed certificate can be imported as a root CA.
     * A self-signed certificate cannot be imported as a subordinate CA.
     * Your certificate chain must not include the private CA certificate that you
     * are importing.
     * Your root CA must be the last certificate in your chain. The subordinate
     * certificate, if any, that your root CA signed must be next to last. The
     * subordinate certificate signed by the preceding subordinate CA must come next,
     * and so on until your chain is built.
     * The chain must be PEM-encoded.
     * The maximum allowed size of a certificate is 32 KB.
     * The maximum allowed size of a certificate chain is 2 MB.
     * Enforcement of Critical Constraints
     * ACM Private CA allows the following extensions to be marked critical in the imported CA
     * certificate or chain.
     * Basic constraints (must be marked critical)
     * Subject alternative names
     * Key usage
     * Extended key usage
     * Authority key identifier
     * Subject key identifier
     * Issuer alternative name
     * Subject directory attributes
     * Subject information access
     * Certificate policies
     * Policy mappings
     * Inhibit anyPolicy
     * ACM Private CA rejects the following extensions when they are marked critical in an imported CA
     * certificate or chain.
     * Name constraints
     * Policy constraints
     * CRL distribution points
     * Authority information access
     * Freshest CRL
     * Any other extension
     */
    suspend fun importCertificateAuthorityCertificate(block: ImportCertificateAuthorityCertificateRequest.DslBuilder.() -> Unit) = importCertificateAuthorityCertificate(ImportCertificateAuthorityCertificateRequest.builder().apply(block).build())

    /**
     * Uses your private certificate authority (CA), or one that has been shared with you, to
     * issue a client certificate. This action returns the Amazon Resource Name (ARN) of the
     * certificate. You can retrieve the certificate by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificate.html">GetCertificate action and
     * specifying the ARN.
     * You cannot use the ACM ListCertificateAuthorities action to retrieve the ARNs of the
     * certificates that you issue by using ACM Private CA.
     */
    suspend fun issueCertificate(input: IssueCertificateRequest): IssueCertificateResponse

    /**
     * Uses your private certificate authority (CA), or one that has been shared with you, to
     * issue a client certificate. This action returns the Amazon Resource Name (ARN) of the
     * certificate. You can retrieve the certificate by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificate.html">GetCertificate action and
     * specifying the ARN.
     * You cannot use the ACM ListCertificateAuthorities action to retrieve the ARNs of the
     * certificates that you issue by using ACM Private CA.
     */
    suspend fun issueCertificate(block: IssueCertificateRequest.DslBuilder.() -> Unit) = issueCertificate(IssueCertificateRequest.builder().apply(block).build())

    /**
     * Lists the private certificate authorities that you created by using the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority action.
     */
    suspend fun listCertificateAuthorities(input: ListCertificateAuthoritiesRequest): ListCertificateAuthoritiesResponse

    /**
     * Lists the private certificate authorities that you created by using the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority action.
     */
    suspend fun listCertificateAuthorities(block: ListCertificateAuthoritiesRequest.DslBuilder.() -> Unit) = listCertificateAuthorities(ListCertificateAuthoritiesRequest.builder().apply(block).build())

    /**
     * List all permissions on a private CA, if any, granted to the AWS Certificate Manager (ACM) service
     * principal (acm.amazonaws.com).
     * These permissions allow ACM to issue and renew ACM certificates that reside in the
     * same AWS account as the CA.
     * Permissions can be granted with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreatePermission.html">CreatePermission action and
     * revoked with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePermission.html">DeletePermission action.
     * <p class="title">
     * About Permissions
     * If the private CA and the certificates it issues reside in the same
     * account, you can use CreatePermission to grant permissions for ACM to
     * carry out automatic certificate renewals.
     * For automatic certificate renewal to succeed, the ACM service principal
     * needs permissions to create, retrieve, and list certificates.
     * If the private CA and the ACM certificates reside in different accounts,
     * then permissions cannot be used to enable automatic renewals. Instead,
     * the ACM certificate owner must set up a resource-based policy to enable
     * cross-account issuance and renewals. For more information, see
     * <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html">Using a Resource
     * Based Policy with ACM Private CA.
     */
    suspend fun listPermissions(input: ListPermissionsRequest): ListPermissionsResponse

    /**
     * List all permissions on a private CA, if any, granted to the AWS Certificate Manager (ACM) service
     * principal (acm.amazonaws.com).
     * These permissions allow ACM to issue and renew ACM certificates that reside in the
     * same AWS account as the CA.
     * Permissions can be granted with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreatePermission.html">CreatePermission action and
     * revoked with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePermission.html">DeletePermission action.
     * <p class="title">
     * About Permissions
     * If the private CA and the certificates it issues reside in the same
     * account, you can use CreatePermission to grant permissions for ACM to
     * carry out automatic certificate renewals.
     * For automatic certificate renewal to succeed, the ACM service principal
     * needs permissions to create, retrieve, and list certificates.
     * If the private CA and the ACM certificates reside in different accounts,
     * then permissions cannot be used to enable automatic renewals. Instead,
     * the ACM certificate owner must set up a resource-based policy to enable
     * cross-account issuance and renewals. For more information, see
     * <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html">Using a Resource
     * Based Policy with ACM Private CA.
     */
    suspend fun listPermissions(block: ListPermissionsRequest.DslBuilder.() -> Unit) = listPermissions(ListPermissionsRequest.builder().apply(block).build())

    /**
     * Lists the tags, if any, that are associated with your private CA or one that has been
     * shared with you. Tags are labels that you can use to identify and organize your CAs.
     * Each tag consists of a key and an optional value. Call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_TagCertificateAuthority.html">TagCertificateAuthority
     * action to add one or more tags to your CA. Call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UntagCertificateAuthority.html">UntagCertificateAuthority action to remove tags.
     */
    suspend fun listTags(input: ListTagsRequest): ListTagsResponse

    /**
     * Lists the tags, if any, that are associated with your private CA or one that has been
     * shared with you. Tags are labels that you can use to identify and organize your CAs.
     * Each tag consists of a key and an optional value. Call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_TagCertificateAuthority.html">TagCertificateAuthority
     * action to add one or more tags to your CA. Call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UntagCertificateAuthority.html">UntagCertificateAuthority action to remove tags.
     */
    suspend fun listTags(block: ListTagsRequest.DslBuilder.() -> Unit) = listTags(ListTagsRequest.builder().apply(block).build())

    /**
     * Attaches a resource-based policy to a private CA.
     * A policy can also be applied by sharing a private CA through AWS Resource Access
     * Manager (RAM). For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-ram.html">Attach a Policy for Cross-Account
     * Access.
     * The policy can be displayed with <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetPolicy.html">GetPolicy and removed with <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePolicy.html">DeletePolicy.
     * <p class="title">
     * About Policies
     * A policy grants access on a private CA to an AWS customer account, to AWS Organizations, or to
     * an AWS Organizations unit. Policies are under the control of a CA administrator. For more information,
     * see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html">Using a Resource Based Policy with ACM Private CA.
     * A policy permits a user of AWS Certificate Manager (ACM) to issue ACM certificates
     * signed by a CA in another account.
     * For ACM to manage automatic renewal of these certificates,
     * the ACM user must configure a Service Linked Role (SLR). The SLR allows
     * the ACM service to assume the identity of the user, subject to confirmation against the
     * ACM Private CA policy. For more information, see
     * <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-slr.html">Using a
     * Service Linked Role with ACM.
     * Updates made in AWS Resource Manager (RAM) are reflected in policies. For more information,
     * see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-ram.html">Attach a Policy for Cross-Account
     * Access.
     */
    suspend fun putPolicy(input: PutPolicyRequest): PutPolicyResponse

    /**
     * Attaches a resource-based policy to a private CA.
     * A policy can also be applied by sharing a private CA through AWS Resource Access
     * Manager (RAM). For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-ram.html">Attach a Policy for Cross-Account
     * Access.
     * The policy can be displayed with <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetPolicy.html">GetPolicy and removed with <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePolicy.html">DeletePolicy.
     * <p class="title">
     * About Policies
     * A policy grants access on a private CA to an AWS customer account, to AWS Organizations, or to
     * an AWS Organizations unit. Policies are under the control of a CA administrator. For more information,
     * see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html">Using a Resource Based Policy with ACM Private CA.
     * A policy permits a user of AWS Certificate Manager (ACM) to issue ACM certificates
     * signed by a CA in another account.
     * For ACM to manage automatic renewal of these certificates,
     * the ACM user must configure a Service Linked Role (SLR). The SLR allows
     * the ACM service to assume the identity of the user, subject to confirmation against the
     * ACM Private CA policy. For more information, see
     * <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-slr.html">Using a
     * Service Linked Role with ACM.
     * Updates made in AWS Resource Manager (RAM) are reflected in policies. For more information,
     * see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-ram.html">Attach a Policy for Cross-Account
     * Access.
     */
    suspend fun putPolicy(block: PutPolicyRequest.DslBuilder.() -> Unit) = putPolicy(PutPolicyRequest.builder().apply(block).build())

    /**
     * Restores a certificate authority (CA) that is in the DELETED state. You
     * can restore a CA during the period that you defined in the PermanentDeletionTimeInDays parameter of the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeleteCertificateAuthority.html">DeleteCertificateAuthority action. Currently, you can specify 7 to 30 days.
     * If you did not specify a PermanentDeletionTimeInDays
     * value, by default you can restore the CA at any time in a 30 day period. You can check
     * the time remaining in the restoration period of a private CA in the DELETED
     * state by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DescribeCertificateAuthority.html">DescribeCertificateAuthority or <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities actions. The status of a restored CA is set to
     * its pre-deletion status when the RestoreCertificateAuthority action returns. To change its status to
     * ACTIVE, call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html">UpdateCertificateAuthority action. If the private CA was in the
     * PENDING_CERTIFICATE state at deletion, you must use the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ImportCertificateAuthorityCertificate.html">ImportCertificateAuthorityCertificate action to import a certificate
     * authority into the private CA before it can be activated. You cannot restore a CA after
     * the restoration period has ended.
     */
    suspend fun restoreCertificateAuthority(input: RestoreCertificateAuthorityRequest): RestoreCertificateAuthorityResponse

    /**
     * Restores a certificate authority (CA) that is in the DELETED state. You
     * can restore a CA during the period that you defined in the PermanentDeletionTimeInDays parameter of the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeleteCertificateAuthority.html">DeleteCertificateAuthority action. Currently, you can specify 7 to 30 days.
     * If you did not specify a PermanentDeletionTimeInDays
     * value, by default you can restore the CA at any time in a 30 day period. You can check
     * the time remaining in the restoration period of a private CA in the DELETED
     * state by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DescribeCertificateAuthority.html">DescribeCertificateAuthority or <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities actions. The status of a restored CA is set to
     * its pre-deletion status when the RestoreCertificateAuthority action returns. To change its status to
     * ACTIVE, call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html">UpdateCertificateAuthority action. If the private CA was in the
     * PENDING_CERTIFICATE state at deletion, you must use the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ImportCertificateAuthorityCertificate.html">ImportCertificateAuthorityCertificate action to import a certificate
     * authority into the private CA before it can be activated. You cannot restore a CA after
     * the restoration period has ended.
     */
    suspend fun restoreCertificateAuthority(block: RestoreCertificateAuthorityRequest.DslBuilder.() -> Unit) = restoreCertificateAuthority(RestoreCertificateAuthorityRequest.builder().apply(block).build())

    /**
     * Revokes a certificate that was issued inside ACM Private CA. If you enable a certificate
     * revocation list (CRL) when you create or update your private CA, information about the
     * revoked certificates will be included in the CRL. ACM Private CA writes the CRL to an S3 bucket
     * that you specify. A CRL is typically updated approximately 30 minutes after a
     * certificate is revoked. If for any reason the CRL update fails, ACM Private CA attempts makes
     * further attempts every 15 minutes. With Amazon CloudWatch, you can create alarms for the
     * metrics CRLGenerated and MisconfiguredCRLBucket. For more
     * information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCloudWatch.html">Supported CloudWatch Metrics.
     * Both PCA and the IAM principal must have permission to write to
     * the S3 bucket that you specify. If the IAM principal making the call
     * does not have permission to write to the bucket, then an exception is
     * thrown. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaAuthAccess.html">Configure
     * Access to ACM Private CA.
     * ACM Private CA also writes
     * revocation information to the audit report. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html">CreateCertificateAuthorityAuditReport.
     * You cannot revoke a root CA self-signed certificate.
     */
    suspend fun revokeCertificate(input: RevokeCertificateRequest): RevokeCertificateResponse

    /**
     * Revokes a certificate that was issued inside ACM Private CA. If you enable a certificate
     * revocation list (CRL) when you create or update your private CA, information about the
     * revoked certificates will be included in the CRL. ACM Private CA writes the CRL to an S3 bucket
     * that you specify. A CRL is typically updated approximately 30 minutes after a
     * certificate is revoked. If for any reason the CRL update fails, ACM Private CA attempts makes
     * further attempts every 15 minutes. With Amazon CloudWatch, you can create alarms for the
     * metrics CRLGenerated and MisconfiguredCRLBucket. For more
     * information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCloudWatch.html">Supported CloudWatch Metrics.
     * Both PCA and the IAM principal must have permission to write to
     * the S3 bucket that you specify. If the IAM principal making the call
     * does not have permission to write to the bucket, then an exception is
     * thrown. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaAuthAccess.html">Configure
     * Access to ACM Private CA.
     * ACM Private CA also writes
     * revocation information to the audit report. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html">CreateCertificateAuthorityAuditReport.
     * You cannot revoke a root CA self-signed certificate.
     */
    suspend fun revokeCertificate(block: RevokeCertificateRequest.DslBuilder.() -> Unit) = revokeCertificate(RevokeCertificateRequest.builder().apply(block).build())

    /**
     * Adds one or more tags to your private CA. Tags are labels that you can use to identify
     * and organize your AWS resources. Each tag consists of a key and an optional value. You
     * specify the private CA on input by its Amazon Resource Name (ARN). You specify the tag
     * by using a key-value pair. You can apply a tag to just one private CA if you want to
     * identify a specific characteristic of that CA, or you can apply the same tag to multiple
     * private CAs if you want to filter for a common relationship among those CAs. To remove
     * one or more tags, use the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UntagCertificateAuthority.html">UntagCertificateAuthority action. Call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListTags.html">ListTags action to see what tags are
     * associated with your CA.
     */
    suspend fun tagCertificateAuthority(input: TagCertificateAuthorityRequest): TagCertificateAuthorityResponse

    /**
     * Adds one or more tags to your private CA. Tags are labels that you can use to identify
     * and organize your AWS resources. Each tag consists of a key and an optional value. You
     * specify the private CA on input by its Amazon Resource Name (ARN). You specify the tag
     * by using a key-value pair. You can apply a tag to just one private CA if you want to
     * identify a specific characteristic of that CA, or you can apply the same tag to multiple
     * private CAs if you want to filter for a common relationship among those CAs. To remove
     * one or more tags, use the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UntagCertificateAuthority.html">UntagCertificateAuthority action. Call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListTags.html">ListTags action to see what tags are
     * associated with your CA.
     */
    suspend fun tagCertificateAuthority(block: TagCertificateAuthorityRequest.DslBuilder.() -> Unit) = tagCertificateAuthority(TagCertificateAuthorityRequest.builder().apply(block).build())

    /**
     * Remove one or more tags from your private CA. A tag consists of a key-value pair. If
     * you do not specify the value portion of the tag when calling this action, the tag will
     * be removed regardless of value. If you specify a value, the tag is removed only if it is
     * associated with the specified value. To add tags to a private CA, use the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_TagCertificateAuthority.html">TagCertificateAuthority. Call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListTags.html">ListTags action to see what tags are
     * associated with your CA.
     */
    suspend fun untagCertificateAuthority(input: UntagCertificateAuthorityRequest): UntagCertificateAuthorityResponse

    /**
     * Remove one or more tags from your private CA. A tag consists of a key-value pair. If
     * you do not specify the value portion of the tag when calling this action, the tag will
     * be removed regardless of value. If you specify a value, the tag is removed only if it is
     * associated with the specified value. To add tags to a private CA, use the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_TagCertificateAuthority.html">TagCertificateAuthority. Call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListTags.html">ListTags action to see what tags are
     * associated with your CA.
     */
    suspend fun untagCertificateAuthority(block: UntagCertificateAuthorityRequest.DslBuilder.() -> Unit) = untagCertificateAuthority(UntagCertificateAuthorityRequest.builder().apply(block).build())

    /**
     * Updates the status or configuration of a private certificate authority (CA). Your
     * private CA must be in the ACTIVE or DISABLED state before you
     * can update it. You can disable a private CA that is in the ACTIVE state or
     * make a CA that is in the DISABLED state active again.
     * Both PCA and the IAM principal must have permission to write to
     * the S3 bucket that you specify. If the IAM principal making the call
     * does not have permission to write to the bucket, then an exception is
     * thrown. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaAuthAccess.html">Configure
     * Access to ACM Private CA.
     */
    suspend fun updateCertificateAuthority(input: UpdateCertificateAuthorityRequest): UpdateCertificateAuthorityResponse

    /**
     * Updates the status or configuration of a private certificate authority (CA). Your
     * private CA must be in the ACTIVE or DISABLED state before you
     * can update it. You can disable a private CA that is in the ACTIVE state or
     * make a CA that is in the DISABLED state active again.
     * Both PCA and the IAM principal must have permission to write to
     * the S3 bucket that you specify. If the IAM principal making the call
     * does not have permission to write to the bucket, then an exception is
     * thrown. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaAuthAccess.html">Configure
     * Access to ACM Private CA.
     */
    suspend fun updateCertificateAuthority(block: UpdateCertificateAuthorityRequest.DslBuilder.() -> Unit) = updateCertificateAuthority(UpdateCertificateAuthorityRequest.builder().apply(block).build())
}
