// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.acmpca.model.AcmPcaException
import aws.sdk.kotlin.services.acmpca.model.AuditReportStatus
import aws.sdk.kotlin.services.acmpca.model.DescribeCertificateAuthorityAuditReportResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeCertificateAuthorityAuditReportOperationDeserializer: HttpDeserialize<DescribeCertificateAuthorityAuditReportResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeCertificateAuthorityAuditReportResponse {
        if (!response.status.isSuccess()) {
            throwDescribeCertificateAuthorityAuditReportError(context, response)
        }
        val builder = DescribeCertificateAuthorityAuditReportResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeCertificateAuthorityAuditReportOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeDescribeCertificateAuthorityAuditReportOperationBody(builder: DescribeCertificateAuthorityAuditReportResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUDITREPORTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AuditReportStatus"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedAt"))
    val S3BUCKETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("S3BucketName"))
    val S3KEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("S3Key"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUDITREPORTSTATUS_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(S3BUCKETNAME_DESCRIPTOR)
        field(S3KEY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUDITREPORTSTATUS_DESCRIPTOR.index -> builder.auditReportStatus = deserializeString().let { AuditReportStatus.fromValue(it) }
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                S3BUCKETNAME_DESCRIPTOR.index -> builder.s3BucketName = deserializeString()
                S3KEY_DESCRIPTOR.index -> builder.s3Key = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeCertificateAuthorityAuditReportError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InvalidArgsException" -> InvalidArgsExceptionDeserializer()
        "InvalidArnException" -> InvalidArnExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        else -> throw AcmPcaException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, response)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
