// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.acmpca.model.AcmPcaException
import aws.sdk.kotlin.services.acmpca.model.DeletePolicyResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class DeletePolicyOperationDeserializer: HttpDeserialize<DeletePolicyResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeletePolicyResponse {
        if (!response.status.isSuccess()) {
            throwDeletePolicyError(context, response)
        }
        val builder = DeletePolicyResponse.builder()

        return builder.build()
    }
}

private suspend fun throwDeletePolicyError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "ConcurrentModificationException" -> ConcurrentModificationExceptionDeserializer()
        "InvalidArnException" -> InvalidArnExceptionDeserializer()
        "InvalidStateException" -> InvalidStateExceptionDeserializer()
        "LockoutPreventedException" -> LockoutPreventedExceptionDeserializer()
        "RequestFailedException" -> RequestFailedExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        else -> throw AcmPcaException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, response)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
