// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.acmpca.model.AcmPcaException
import aws.sdk.kotlin.services.acmpca.model.CreatePermissionResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class CreatePermissionOperationDeserializer: HttpDeserialize<CreatePermissionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreatePermissionResponse {
        if (!response.status.isSuccess()) {
            throwCreatePermissionError(context, response)
        }
        val builder = CreatePermissionResponse.builder()

        return builder.build()
    }
}

private suspend fun throwCreatePermissionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InvalidArnException" -> InvalidArnExceptionDeserializer()
        "InvalidStateException" -> InvalidStateExceptionDeserializer()
        "LimitExceededException" -> LimitExceededExceptionDeserializer()
        "PermissionAlreadyExistsException" -> PermissionAlreadyExistsExceptionDeserializer()
        "RequestFailedException" -> RequestFailedExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        else -> throw AcmPcaException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, response)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
