// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



class RevokeCertificateRequest private constructor(builder: BuilderImpl) {
    /**
     * Amazon Resource Name (ARN) of the private CA that issued the certificate to be
     * revoked. This must be of the form:
     * arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
     */
    val certificateAuthorityArn: String? = builder.certificateAuthorityArn
    /**
     * Serial number of the certificate to be revoked. This must be in hexadecimal format.
     * You can retrieve the serial number by calling <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificate.html">GetCertificate with the Amazon
     * Resource Name (ARN) of the certificate you want and the ARN of your private CA. The
     * GetCertificate action retrieves the certificate in
     * the PEM format. You can use the following OpenSSL command to list the certificate in
     * text format and copy the hexadecimal serial number.
     * openssl x509 -in file_path -text -noout
     * You can also copy the serial number from the console or use the <a href="https://docs.aws.amazon.com/acm/latest/APIReference/API_DescribeCertificate.html">DescribeCertificate action in the AWS Certificate Manager API
     * Reference.
     */
    val certificateSerial: String? = builder.certificateSerial
    /**
     * Specifies why you revoked the certificate.
     */
    val revocationReason: RevocationReason? = builder.revocationReason

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RevokeCertificateRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RevokeCertificateRequest(")
        append("certificateAuthorityArn=$certificateAuthorityArn,")
        append("certificateSerial=$certificateSerial,")
        append("revocationReason=$revocationReason)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateAuthorityArn?.hashCode() ?: 0
        result = 31 * result + (certificateSerial?.hashCode() ?: 0)
        result = 31 * result + (revocationReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RevokeCertificateRequest

        if (certificateAuthorityArn != other.certificateAuthorityArn) return false
        if (certificateSerial != other.certificateSerial) return false
        if (revocationReason != other.revocationReason) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RevokeCertificateRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RevokeCertificateRequest
        /**
         * Amazon Resource Name (ARN) of the private CA that issued the certificate to be
         * revoked. This must be of the form:
         * arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
         */
        fun certificateAuthorityArn(certificateAuthorityArn: String): FluentBuilder
        /**
         * Serial number of the certificate to be revoked. This must be in hexadecimal format.
         * You can retrieve the serial number by calling <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificate.html">GetCertificate with the Amazon
         * Resource Name (ARN) of the certificate you want and the ARN of your private CA. The
         * GetCertificate action retrieves the certificate in
         * the PEM format. You can use the following OpenSSL command to list the certificate in
         * text format and copy the hexadecimal serial number.
         * openssl x509 -in file_path -text -noout
         * You can also copy the serial number from the console or use the <a href="https://docs.aws.amazon.com/acm/latest/APIReference/API_DescribeCertificate.html">DescribeCertificate action in the AWS Certificate Manager API
         * Reference.
         */
        fun certificateSerial(certificateSerial: String): FluentBuilder
        /**
         * Specifies why you revoked the certificate.
         */
        fun revocationReason(revocationReason: RevocationReason): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Amazon Resource Name (ARN) of the private CA that issued the certificate to be
         * revoked. This must be of the form:
         * arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
         */
        var certificateAuthorityArn: String?
        /**
         * Serial number of the certificate to be revoked. This must be in hexadecimal format.
         * You can retrieve the serial number by calling <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificate.html">GetCertificate with the Amazon
         * Resource Name (ARN) of the certificate you want and the ARN of your private CA. The
         * GetCertificate action retrieves the certificate in
         * the PEM format. You can use the following OpenSSL command to list the certificate in
         * text format and copy the hexadecimal serial number.
         * openssl x509 -in file_path -text -noout
         * You can also copy the serial number from the console or use the <a href="https://docs.aws.amazon.com/acm/latest/APIReference/API_DescribeCertificate.html">DescribeCertificate action in the AWS Certificate Manager API
         * Reference.
         */
        var certificateSerial: String?
        /**
         * Specifies why you revoked the certificate.
         */
        var revocationReason: RevocationReason?

        fun build(): RevokeCertificateRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var certificateAuthorityArn: String? = null
        override var certificateSerial: String? = null
        override var revocationReason: RevocationReason? = null

        constructor(x: RevokeCertificateRequest) : this() {
            this.certificateAuthorityArn = x.certificateAuthorityArn
            this.certificateSerial = x.certificateSerial
            this.revocationReason = x.revocationReason
        }

        override fun build(): RevokeCertificateRequest = RevokeCertificateRequest(this)
        override fun certificateAuthorityArn(certificateAuthorityArn: String): FluentBuilder = apply { this.certificateAuthorityArn = certificateAuthorityArn }
        override fun certificateSerial(certificateSerial: String): FluentBuilder = apply { this.certificateSerial = certificateSerial }
        override fun revocationReason(revocationReason: RevocationReason): FluentBuilder = apply { this.revocationReason = revocationReason }
    }
}
