// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



/**
 * Certificate revocation information used by the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority and <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html">UpdateCertificateAuthority actions. Your private certificate authority (CA)
 * can configure Online Certificate Status Protocol (OCSP) support and/or maintain a
 * certificate revocation list (CRL). OCSP returns validation information about
 * certificates as requested by clients, and a CRL contains an updated list of certificates
 * revoked by your CA. For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_RevokeCertificate.html">RevokeCertificate and <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/revocation-setup.html">Setting up a
 * certificate revocation method in the AWS Certificate Manager Private Certificate Authority (PCA) User
 * Guide.
 */
class RevocationConfiguration private constructor(builder: BuilderImpl) {
    /**
     * Configuration of the certificate revocation list (CRL), if any, maintained by your private
     * CA. A CRL is typically updated approximately 30 minutes after a certificate
     * is revoked. If for any reason a CRL update fails, ACM Private CA makes further attempts
     * every 15 minutes.
     */
    val crlConfiguration: CrlConfiguration? = builder.crlConfiguration
    /**
     * Configuration of Online Certificate Status Protocol (OCSP) support, if any, maintained by
     * your private CA. When you revoke a certificate, OCSP responses may take up to 60 minutes
     * to reflect the new status.
     */
    val ocspConfiguration: OcspConfiguration? = builder.ocspConfiguration

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RevocationConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RevocationConfiguration(")
        append("crlConfiguration=$crlConfiguration,")
        append("ocspConfiguration=$ocspConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = crlConfiguration?.hashCode() ?: 0
        result = 31 * result + (ocspConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RevocationConfiguration

        if (crlConfiguration != other.crlConfiguration) return false
        if (ocspConfiguration != other.ocspConfiguration) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RevocationConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RevocationConfiguration
        /**
         * Configuration of the certificate revocation list (CRL), if any, maintained by your private
         * CA. A CRL is typically updated approximately 30 minutes after a certificate
         * is revoked. If for any reason a CRL update fails, ACM Private CA makes further attempts
         * every 15 minutes.
         */
        fun crlConfiguration(crlConfiguration: CrlConfiguration): FluentBuilder
        /**
         * Configuration of Online Certificate Status Protocol (OCSP) support, if any, maintained by
         * your private CA. When you revoke a certificate, OCSP responses may take up to 60 minutes
         * to reflect the new status.
         */
        fun ocspConfiguration(ocspConfiguration: OcspConfiguration): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Configuration of the certificate revocation list (CRL), if any, maintained by your private
         * CA. A CRL is typically updated approximately 30 minutes after a certificate
         * is revoked. If for any reason a CRL update fails, ACM Private CA makes further attempts
         * every 15 minutes.
         */
        var crlConfiguration: CrlConfiguration?
        /**
         * Configuration of Online Certificate Status Protocol (OCSP) support, if any, maintained by
         * your private CA. When you revoke a certificate, OCSP responses may take up to 60 minutes
         * to reflect the new status.
         */
        var ocspConfiguration: OcspConfiguration?

        fun build(): RevocationConfiguration
        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.CrlConfiguration] inside the given [block]
         */
        fun crlConfiguration(block: CrlConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.crlConfiguration = CrlConfiguration.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.OcspConfiguration] inside the given [block]
         */
        fun ocspConfiguration(block: OcspConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.ocspConfiguration = OcspConfiguration.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var crlConfiguration: CrlConfiguration? = null
        override var ocspConfiguration: OcspConfiguration? = null

        constructor(x: RevocationConfiguration) : this() {
            this.crlConfiguration = x.crlConfiguration
            this.ocspConfiguration = x.ocspConfiguration
        }

        override fun build(): RevocationConfiguration = RevocationConfiguration(this)
        override fun crlConfiguration(crlConfiguration: CrlConfiguration): FluentBuilder = apply { this.crlConfiguration = crlConfiguration }
        override fun ocspConfiguration(ocspConfiguration: OcspConfiguration): FluentBuilder = apply { this.ocspConfiguration = ocspConfiguration }
    }
}
