// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Permissions designate which private CA actions can be performed by an AWS service or
 * entity. In order for ACM to automatically renew private certificates, you must give
 * the ACM service principal all available permissions (IssueCertificate,
 * GetCertificate, and ListPermissions). Permissions can be
 * assigned with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreatePermission.html">CreatePermission action,
 * removed with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePermission.html">DeletePermission action, and
 * listed with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListPermissions.html">ListPermissions action.
 */
class Permission private constructor(builder: BuilderImpl) {
    /**
     * The private CA actions that can be performed by the designated AWS service.
     */
    val actions: List<ActionType>? = builder.actions
    /**
     * The Amazon Resource Number (ARN) of the private CA from which the permission was
     * issued.
     */
    val certificateAuthorityArn: String? = builder.certificateAuthorityArn
    /**
     * The time at which the permission was created.
     */
    val createdAt: Instant? = builder.createdAt
    /**
     * The name of the policy that is associated with the permission.
     */
    val policy: String? = builder.policy
    /**
     * The AWS service or entity that holds the permission. At this time, the only valid
     * principal is acm.amazonaws.com.
     */
    val principal: String? = builder.principal
    /**
     * The ID of the account that assigned the permission.
     */
    val sourceAccount: String? = builder.sourceAccount

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Permission = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Permission(")
        append("actions=$actions,")
        append("certificateAuthorityArn=$certificateAuthorityArn,")
        append("createdAt=$createdAt,")
        append("policy=$policy,")
        append("principal=$principal,")
        append("sourceAccount=$sourceAccount)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (certificateAuthorityArn?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (policy?.hashCode() ?: 0)
        result = 31 * result + (principal?.hashCode() ?: 0)
        result = 31 * result + (sourceAccount?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Permission

        if (actions != other.actions) return false
        if (certificateAuthorityArn != other.certificateAuthorityArn) return false
        if (createdAt != other.createdAt) return false
        if (policy != other.policy) return false
        if (principal != other.principal) return false
        if (sourceAccount != other.sourceAccount) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Permission = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Permission
        /**
         * The private CA actions that can be performed by the designated AWS service.
         */
        fun actions(actions: List<ActionType>): FluentBuilder
        /**
         * The Amazon Resource Number (ARN) of the private CA from which the permission was
         * issued.
         */
        fun certificateAuthorityArn(certificateAuthorityArn: String): FluentBuilder
        /**
         * The time at which the permission was created.
         */
        fun createdAt(createdAt: Instant): FluentBuilder
        /**
         * The name of the policy that is associated with the permission.
         */
        fun policy(policy: String): FluentBuilder
        /**
         * The AWS service or entity that holds the permission. At this time, the only valid
         * principal is acm.amazonaws.com.
         */
        fun principal(principal: String): FluentBuilder
        /**
         * The ID of the account that assigned the permission.
         */
        fun sourceAccount(sourceAccount: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The private CA actions that can be performed by the designated AWS service.
         */
        var actions: List<ActionType>?
        /**
         * The Amazon Resource Number (ARN) of the private CA from which the permission was
         * issued.
         */
        var certificateAuthorityArn: String?
        /**
         * The time at which the permission was created.
         */
        var createdAt: Instant?
        /**
         * The name of the policy that is associated with the permission.
         */
        var policy: String?
        /**
         * The AWS service or entity that holds the permission. At this time, the only valid
         * principal is acm.amazonaws.com.
         */
        var principal: String?
        /**
         * The ID of the account that assigned the permission.
         */
        var sourceAccount: String?

        fun build(): Permission
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var actions: List<ActionType>? = null
        override var certificateAuthorityArn: String? = null
        override var createdAt: Instant? = null
        override var policy: String? = null
        override var principal: String? = null
        override var sourceAccount: String? = null

        constructor(x: Permission) : this() {
            this.actions = x.actions
            this.certificateAuthorityArn = x.certificateAuthorityArn
            this.createdAt = x.createdAt
            this.policy = x.policy
            this.principal = x.principal
            this.sourceAccount = x.sourceAccount
        }

        override fun build(): Permission = Permission(this)
        override fun actions(actions: List<ActionType>): FluentBuilder = apply { this.actions = actions }
        override fun certificateAuthorityArn(certificateAuthorityArn: String): FluentBuilder = apply { this.certificateAuthorityArn = certificateAuthorityArn }
        override fun createdAt(createdAt: Instant): FluentBuilder = apply { this.createdAt = createdAt }
        override fun policy(policy: String): FluentBuilder = apply { this.policy = policy }
        override fun principal(principal: String): FluentBuilder = apply { this.principal = principal }
        override fun sourceAccount(sourceAccount: String): FluentBuilder = apply { this.sourceAccount = sourceAccount }
    }
}
