// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



/**
 * Contains information to enable and configure Online Certificate Status Protocol (OCSP) for
 * validating certificate revocation status.
 * When you revoke a certificate, OCSP responses may take up to 60 minutes
 * to reflect the new status.
 */
class OcspConfiguration private constructor(builder: BuilderImpl) {
    /**
     * Flag enabling use of the Online Certificate Status Protocol (OCSP) for validating
     * certificate revocation status.
     */
    val enabled: Boolean = builder.enabled
    /**
     * By default, ACM Private CA injects an AWS domain into certificates being validated by the
     * Online Certificate Status Protocol (OCSP). A customer can alternatively use this object
     * to define a CNAME specifying a customized OCSP domain.
     * Note: The value of the CNAME must not include a protocol prefix such as "http://" or
     * "https://".
     * For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/ocsp-customize.html">Customizing Online Certificate
     * Status Protocol (OCSP)  in the AWS Certificate Manager Private Certificate Authority (PCA) User
     * Guide.
     */
    val ocspCustomCname: String? = builder.ocspCustomCname

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): OcspConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("OcspConfiguration(")
        append("enabled=$enabled,")
        append("ocspCustomCname=$ocspCustomCname)")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled.hashCode()
        result = 31 * result + (ocspCustomCname?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as OcspConfiguration

        if (enabled != other.enabled) return false
        if (ocspCustomCname != other.ocspCustomCname) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): OcspConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): OcspConfiguration
        /**
         * Flag enabling use of the Online Certificate Status Protocol (OCSP) for validating
         * certificate revocation status.
         */
        fun enabled(enabled: Boolean): FluentBuilder
        /**
         * By default, ACM Private CA injects an AWS domain into certificates being validated by the
         * Online Certificate Status Protocol (OCSP). A customer can alternatively use this object
         * to define a CNAME specifying a customized OCSP domain.
         * Note: The value of the CNAME must not include a protocol prefix such as "http://" or
         * "https://".
         * For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/ocsp-customize.html">Customizing Online Certificate
         * Status Protocol (OCSP)  in the AWS Certificate Manager Private Certificate Authority (PCA) User
         * Guide.
         */
        fun ocspCustomCname(ocspCustomCname: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Flag enabling use of the Online Certificate Status Protocol (OCSP) for validating
         * certificate revocation status.
         */
        var enabled: Boolean
        /**
         * By default, ACM Private CA injects an AWS domain into certificates being validated by the
         * Online Certificate Status Protocol (OCSP). A customer can alternatively use this object
         * to define a CNAME specifying a customized OCSP domain.
         * Note: The value of the CNAME must not include a protocol prefix such as "http://" or
         * "https://".
         * For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/ocsp-customize.html">Customizing Online Certificate
         * Status Protocol (OCSP)  in the AWS Certificate Manager Private Certificate Authority (PCA) User
         * Guide.
         */
        var ocspCustomCname: String?

        fun build(): OcspConfiguration
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var enabled: Boolean = false
        override var ocspCustomCname: String? = null

        constructor(x: OcspConfiguration) : this() {
            this.enabled = x.enabled
            this.ocspCustomCname = x.ocspCustomCname
        }

        override fun build(): OcspConfiguration = OcspConfiguration(this)
        override fun enabled(enabled: Boolean): FluentBuilder = apply { this.enabled = enabled }
        override fun ocspCustomCname(ocspCustomCname: String): FluentBuilder = apply { this.ocspCustomCname = ocspCustomCname }
    }
}
