// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



class ListPermissionsRequest private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Number (ARN) of the private CA to inspect. You can find the ARN by
     * calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities action. This must be of the form:
     * arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
     * You can get a private CA's ARN by running the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities action.
     */
    val certificateAuthorityArn: String? = builder.certificateAuthorityArn
    /**
     * When paginating results, use this parameter to specify the maximum number of items to
     * return in the response. If additional items exist beyond the number you specify, the
     * NextToken element is sent in the response. Use this
     * NextToken value in a subsequent request to retrieve
     * additional items.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * When paginating results, use this parameter in a subsequent request after you receive
     * a response with truncated results. Set it to the value of NextToken from the response you just received.
     */
    val nextToken: String? = builder.nextToken

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListPermissionsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListPermissionsRequest(")
        append("certificateAuthorityArn=$certificateAuthorityArn,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateAuthorityArn?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListPermissionsRequest

        if (certificateAuthorityArn != other.certificateAuthorityArn) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListPermissionsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListPermissionsRequest
        /**
         * The Amazon Resource Number (ARN) of the private CA to inspect. You can find the ARN by
         * calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities action. This must be of the form:
         * arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
         * You can get a private CA's ARN by running the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities action.
         */
        fun certificateAuthorityArn(certificateAuthorityArn: String): FluentBuilder
        /**
         * When paginating results, use this parameter to specify the maximum number of items to
         * return in the response. If additional items exist beyond the number you specify, the
         * NextToken element is sent in the response. Use this
         * NextToken value in a subsequent request to retrieve
         * additional items.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * When paginating results, use this parameter in a subsequent request after you receive
         * a response with truncated results. Set it to the value of NextToken from the response you just received.
         */
        fun nextToken(nextToken: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Number (ARN) of the private CA to inspect. You can find the ARN by
         * calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities action. This must be of the form:
         * arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
         * You can get a private CA's ARN by running the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities action.
         */
        var certificateAuthorityArn: String?
        /**
         * When paginating results, use this parameter to specify the maximum number of items to
         * return in the response. If additional items exist beyond the number you specify, the
         * NextToken element is sent in the response. Use this
         * NextToken value in a subsequent request to retrieve
         * additional items.
         */
        var maxResults: Int?
        /**
         * When paginating results, use this parameter in a subsequent request after you receive
         * a response with truncated results. Set it to the value of NextToken from the response you just received.
         */
        var nextToken: String?

        fun build(): ListPermissionsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var certificateAuthorityArn: String? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null

        constructor(x: ListPermissionsRequest) : this() {
            this.certificateAuthorityArn = x.certificateAuthorityArn
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        override fun build(): ListPermissionsRequest = ListPermissionsRequest(this)
        override fun certificateAuthorityArn(certificateAuthorityArn: String): FluentBuilder = apply { this.certificateAuthorityArn = certificateAuthorityArn }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
    }
}
