// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



class ImportCertificateAuthorityCertificateRequest private constructor(builder: BuilderImpl) {
    /**
     * The PEM-encoded certificate for a private CA. This may be a self-signed certificate in
     * the case of a root CA, or it may be signed by another CA that you control.
     */
    val certificate: ByteArray? = builder.certificate
    /**
     * The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority. This must be of the form:
     * arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
     */
    val certificateAuthorityArn: String? = builder.certificateAuthorityArn
    /**
     * A PEM-encoded file that contains all of your certificates, other than the certificate
     * you're importing, chaining up to your root CA. Your ACM Private CA-hosted or on-premises root
     * certificate is the last in the chain, and each certificate in the chain signs the one
     * preceding.
     * This parameter must be supplied when you import a subordinate CA. When you import a
     * root CA, there is no chain.
     */
    val certificateChain: ByteArray? = builder.certificateChain

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ImportCertificateAuthorityCertificateRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ImportCertificateAuthorityCertificateRequest(")
        append("certificate=$certificate,")
        append("certificateAuthorityArn=$certificateAuthorityArn,")
        append("certificateChain=$certificateChain)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificate?.contentHashCode() ?: 0
        result = 31 * result + (certificateAuthorityArn?.hashCode() ?: 0)
        result = 31 * result + (certificateChain?.contentHashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ImportCertificateAuthorityCertificateRequest

        if (certificate != null) {
            if (other.certificate == null) return false
            if (!certificate.contentEquals(other.certificate)) return false
        } else if (other.certificate != null) return false
        if (certificateAuthorityArn != other.certificateAuthorityArn) return false
        if (certificateChain != null) {
            if (other.certificateChain == null) return false
            if (!certificateChain.contentEquals(other.certificateChain)) return false
        } else if (other.certificateChain != null) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ImportCertificateAuthorityCertificateRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ImportCertificateAuthorityCertificateRequest
        /**
         * The PEM-encoded certificate for a private CA. This may be a self-signed certificate in
         * the case of a root CA, or it may be signed by another CA that you control.
         */
        fun certificate(certificate: ByteArray): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority. This must be of the form:
         * arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
         */
        fun certificateAuthorityArn(certificateAuthorityArn: String): FluentBuilder
        /**
         * A PEM-encoded file that contains all of your certificates, other than the certificate
         * you're importing, chaining up to your root CA. Your ACM Private CA-hosted or on-premises root
         * certificate is the last in the chain, and each certificate in the chain signs the one
         * preceding.
         * This parameter must be supplied when you import a subordinate CA. When you import a
         * root CA, there is no chain.
         */
        fun certificateChain(certificateChain: ByteArray): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The PEM-encoded certificate for a private CA. This may be a self-signed certificate in
         * the case of a root CA, or it may be signed by another CA that you control.
         */
        var certificate: ByteArray?
        /**
         * The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority. This must be of the form:
         * arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
         */
        var certificateAuthorityArn: String?
        /**
         * A PEM-encoded file that contains all of your certificates, other than the certificate
         * you're importing, chaining up to your root CA. Your ACM Private CA-hosted or on-premises root
         * certificate is the last in the chain, and each certificate in the chain signs the one
         * preceding.
         * This parameter must be supplied when you import a subordinate CA. When you import a
         * root CA, there is no chain.
         */
        var certificateChain: ByteArray?

        fun build(): ImportCertificateAuthorityCertificateRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var certificate: ByteArray? = null
        override var certificateAuthorityArn: String? = null
        override var certificateChain: ByteArray? = null

        constructor(x: ImportCertificateAuthorityCertificateRequest) : this() {
            this.certificate = x.certificate
            this.certificateAuthorityArn = x.certificateAuthorityArn
            this.certificateChain = x.certificateChain
        }

        override fun build(): ImportCertificateAuthorityCertificateRequest = ImportCertificateAuthorityCertificateRequest(this)
        override fun certificate(certificate: ByteArray): FluentBuilder = apply { this.certificate = certificate }
        override fun certificateAuthorityArn(certificateAuthorityArn: String): FluentBuilder = apply { this.certificateAuthorityArn = certificateAuthorityArn }
        override fun certificateChain(certificateChain: ByteArray): FluentBuilder = apply { this.certificateChain = certificateChain }
    }
}
