// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



/**
 * Contains X.509 extension information for a certificate.
 */
class Extensions private constructor(builder: BuilderImpl) {
    /**
     * Contains a sequence of one or more policy information terms, each of which consists of
     * an object identifier (OID) and optional qualifiers. For more information, see NIST's
     * definition of <a href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object
     * Identifier (OID).
     * In an end-entity certificate, these terms indicate the policy under which the
     * certificate was issued and the purposes for which it may be used. In a CA certificate,
     * these terms limit the set of policies for certification paths that include this
     * certificate.
     */
    val certificatePolicies: List<PolicyInformation>? = builder.certificatePolicies
    /**
     * Specifies additional purposes for which the certified public key may be used other
     * than basic purposes indicated in the KeyUsage extension.
     */
    val extendedKeyUsage: List<ExtendedKeyUsage>? = builder.extendedKeyUsage
    /**
     * Defines one or more purposes for which the key contained in the certificate can be
     * used. Default value for each option is false.
     */
    val keyUsage: KeyUsage? = builder.keyUsage
    /**
     * The subject alternative name extension allows identities to be bound to the subject of
     * the certificate. These identities may be included in addition to or in place of the
     * identity in the subject field of the certificate.
     */
    val subjectAlternativeNames: List<GeneralName>? = builder.subjectAlternativeNames

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Extensions = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Extensions(")
        append("certificatePolicies=$certificatePolicies,")
        append("extendedKeyUsage=$extendedKeyUsage,")
        append("keyUsage=$keyUsage,")
        append("subjectAlternativeNames=$subjectAlternativeNames)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificatePolicies?.hashCode() ?: 0
        result = 31 * result + (extendedKeyUsage?.hashCode() ?: 0)
        result = 31 * result + (keyUsage?.hashCode() ?: 0)
        result = 31 * result + (subjectAlternativeNames?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Extensions

        if (certificatePolicies != other.certificatePolicies) return false
        if (extendedKeyUsage != other.extendedKeyUsage) return false
        if (keyUsage != other.keyUsage) return false
        if (subjectAlternativeNames != other.subjectAlternativeNames) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Extensions = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Extensions
        /**
         * Contains a sequence of one or more policy information terms, each of which consists of
         * an object identifier (OID) and optional qualifiers. For more information, see NIST's
         * definition of <a href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object
         * Identifier (OID).
         * In an end-entity certificate, these terms indicate the policy under which the
         * certificate was issued and the purposes for which it may be used. In a CA certificate,
         * these terms limit the set of policies for certification paths that include this
         * certificate.
         */
        fun certificatePolicies(certificatePolicies: List<PolicyInformation>): FluentBuilder
        /**
         * Specifies additional purposes for which the certified public key may be used other
         * than basic purposes indicated in the KeyUsage extension.
         */
        fun extendedKeyUsage(extendedKeyUsage: List<ExtendedKeyUsage>): FluentBuilder
        /**
         * Defines one or more purposes for which the key contained in the certificate can be
         * used. Default value for each option is false.
         */
        fun keyUsage(keyUsage: KeyUsage): FluentBuilder
        /**
         * The subject alternative name extension allows identities to be bound to the subject of
         * the certificate. These identities may be included in addition to or in place of the
         * identity in the subject field of the certificate.
         */
        fun subjectAlternativeNames(subjectAlternativeNames: List<GeneralName>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Contains a sequence of one or more policy information terms, each of which consists of
         * an object identifier (OID) and optional qualifiers. For more information, see NIST's
         * definition of <a href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object
         * Identifier (OID).
         * In an end-entity certificate, these terms indicate the policy under which the
         * certificate was issued and the purposes for which it may be used. In a CA certificate,
         * these terms limit the set of policies for certification paths that include this
         * certificate.
         */
        var certificatePolicies: List<PolicyInformation>?
        /**
         * Specifies additional purposes for which the certified public key may be used other
         * than basic purposes indicated in the KeyUsage extension.
         */
        var extendedKeyUsage: List<ExtendedKeyUsage>?
        /**
         * Defines one or more purposes for which the key contained in the certificate can be
         * used. Default value for each option is false.
         */
        var keyUsage: KeyUsage?
        /**
         * The subject alternative name extension allows identities to be bound to the subject of
         * the certificate. These identities may be included in addition to or in place of the
         * identity in the subject field of the certificate.
         */
        var subjectAlternativeNames: List<GeneralName>?

        fun build(): Extensions
        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.KeyUsage] inside the given [block]
         */
        fun keyUsage(block: KeyUsage.DslBuilder.() -> kotlin.Unit) {
            this.keyUsage = KeyUsage.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var certificatePolicies: List<PolicyInformation>? = null
        override var extendedKeyUsage: List<ExtendedKeyUsage>? = null
        override var keyUsage: KeyUsage? = null
        override var subjectAlternativeNames: List<GeneralName>? = null

        constructor(x: Extensions) : this() {
            this.certificatePolicies = x.certificatePolicies
            this.extendedKeyUsage = x.extendedKeyUsage
            this.keyUsage = x.keyUsage
            this.subjectAlternativeNames = x.subjectAlternativeNames
        }

        override fun build(): Extensions = Extensions(this)
        override fun certificatePolicies(certificatePolicies: List<PolicyInformation>): FluentBuilder = apply { this.certificatePolicies = certificatePolicies }
        override fun extendedKeyUsage(extendedKeyUsage: List<ExtendedKeyUsage>): FluentBuilder = apply { this.extendedKeyUsage = extendedKeyUsage }
        override fun keyUsage(keyUsage: KeyUsage): FluentBuilder = apply { this.keyUsage = keyUsage }
        override fun subjectAlternativeNames(subjectAlternativeNames: List<GeneralName>): FluentBuilder = apply { this.subjectAlternativeNames = subjectAlternativeNames }
    }
}
