// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



/**
 * Describes the certificate extensions to be added to the certificate signing request
 * (CSR).
 */
class CsrExtensions private constructor(builder: BuilderImpl) {
    /**
     * Indicates the purpose of the certificate and of the key contained in the
     * certificate.
     */
    val keyUsage: KeyUsage? = builder.keyUsage
    /**
     * For CA certificates, provides a path to additional information pertaining to the CA,
     * such as revocation and policy. For more information, see <a href="https://tools.ietf.org/html/rfc5280#section-4.2.2.2">Subject Information
     * Access in RFC 5280.
     */
    val subjectInformationAccess: List<AccessDescription>? = builder.subjectInformationAccess

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CsrExtensions = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CsrExtensions(")
        append("keyUsage=$keyUsage,")
        append("subjectInformationAccess=$subjectInformationAccess)")
    }

    override fun hashCode(): kotlin.Int {
        var result = keyUsage?.hashCode() ?: 0
        result = 31 * result + (subjectInformationAccess?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CsrExtensions

        if (keyUsage != other.keyUsage) return false
        if (subjectInformationAccess != other.subjectInformationAccess) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CsrExtensions = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CsrExtensions
        /**
         * Indicates the purpose of the certificate and of the key contained in the
         * certificate.
         */
        fun keyUsage(keyUsage: KeyUsage): FluentBuilder
        /**
         * For CA certificates, provides a path to additional information pertaining to the CA,
         * such as revocation and policy. For more information, see <a href="https://tools.ietf.org/html/rfc5280#section-4.2.2.2">Subject Information
         * Access in RFC 5280.
         */
        fun subjectInformationAccess(subjectInformationAccess: List<AccessDescription>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Indicates the purpose of the certificate and of the key contained in the
         * certificate.
         */
        var keyUsage: KeyUsage?
        /**
         * For CA certificates, provides a path to additional information pertaining to the CA,
         * such as revocation and policy. For more information, see <a href="https://tools.ietf.org/html/rfc5280#section-4.2.2.2">Subject Information
         * Access in RFC 5280.
         */
        var subjectInformationAccess: List<AccessDescription>?

        fun build(): CsrExtensions
        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.KeyUsage] inside the given [block]
         */
        fun keyUsage(block: KeyUsage.DslBuilder.() -> kotlin.Unit) {
            this.keyUsage = KeyUsage.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var keyUsage: KeyUsage? = null
        override var subjectInformationAccess: List<AccessDescription>? = null

        constructor(x: CsrExtensions) : this() {
            this.keyUsage = x.keyUsage
            this.subjectInformationAccess = x.subjectInformationAccess
        }

        override fun build(): CsrExtensions = CsrExtensions(this)
        override fun keyUsage(keyUsage: KeyUsage): FluentBuilder = apply { this.keyUsage = keyUsage }
        override fun subjectInformationAccess(subjectInformationAccess: List<AccessDescription>): FluentBuilder = apply { this.subjectInformationAccess = subjectInformationAccess }
    }
}
