// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



/**
 * Contains configuration information for your private certificate authority (CA). This
 * includes information about the class of public key algorithm and the key pair that your
 * private CA creates when it issues a certificate. It also includes the signature
 * algorithm that it uses when issuing certificates, and its X.500 distinguished name. You
 * must specify this information when you call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority action.
 */
class CertificateAuthorityConfiguration private constructor(builder: BuilderImpl) {
    /**
     * Specifies information to be added to the extension section of the certificate signing
     * request (CSR).
     */
    val csrExtensions: CsrExtensions? = builder.csrExtensions
    /**
     * Type of the public key algorithm and size, in bits, of the key pair that your CA
     * creates when it issues a certificate. When you create a subordinate CA, you must use a
     * key algorithm supported by the parent CA.
     */
    val keyAlgorithm: KeyAlgorithm? = builder.keyAlgorithm
    /**
     * Name of the algorithm your private CA uses to sign certificate requests.
     * This parameter should not be confused with the SigningAlgorithm parameter
     * used to sign certificates when they are issued.
     */
    val signingAlgorithm: SigningAlgorithm? = builder.signingAlgorithm
    /**
     * Structure that contains X.500 distinguished name information for your private
     * CA.
     */
    val subject: Asn1Subject? = builder.subject

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CertificateAuthorityConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CertificateAuthorityConfiguration(")
        append("csrExtensions=$csrExtensions,")
        append("keyAlgorithm=$keyAlgorithm,")
        append("signingAlgorithm=$signingAlgorithm,")
        append("subject=$subject)")
    }

    override fun hashCode(): kotlin.Int {
        var result = csrExtensions?.hashCode() ?: 0
        result = 31 * result + (keyAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (signingAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (subject?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CertificateAuthorityConfiguration

        if (csrExtensions != other.csrExtensions) return false
        if (keyAlgorithm != other.keyAlgorithm) return false
        if (signingAlgorithm != other.signingAlgorithm) return false
        if (subject != other.subject) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CertificateAuthorityConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CertificateAuthorityConfiguration
        /**
         * Specifies information to be added to the extension section of the certificate signing
         * request (CSR).
         */
        fun csrExtensions(csrExtensions: CsrExtensions): FluentBuilder
        /**
         * Type of the public key algorithm and size, in bits, of the key pair that your CA
         * creates when it issues a certificate. When you create a subordinate CA, you must use a
         * key algorithm supported by the parent CA.
         */
        fun keyAlgorithm(keyAlgorithm: KeyAlgorithm): FluentBuilder
        /**
         * Name of the algorithm your private CA uses to sign certificate requests.
         * This parameter should not be confused with the SigningAlgorithm parameter
         * used to sign certificates when they are issued.
         */
        fun signingAlgorithm(signingAlgorithm: SigningAlgorithm): FluentBuilder
        /**
         * Structure that contains X.500 distinguished name information for your private
         * CA.
         */
        fun subject(subject: Asn1Subject): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specifies information to be added to the extension section of the certificate signing
         * request (CSR).
         */
        var csrExtensions: CsrExtensions?
        /**
         * Type of the public key algorithm and size, in bits, of the key pair that your CA
         * creates when it issues a certificate. When you create a subordinate CA, you must use a
         * key algorithm supported by the parent CA.
         */
        var keyAlgorithm: KeyAlgorithm?
        /**
         * Name of the algorithm your private CA uses to sign certificate requests.
         * This parameter should not be confused with the SigningAlgorithm parameter
         * used to sign certificates when they are issued.
         */
        var signingAlgorithm: SigningAlgorithm?
        /**
         * Structure that contains X.500 distinguished name information for your private
         * CA.
         */
        var subject: Asn1Subject?

        fun build(): CertificateAuthorityConfiguration
        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.CsrExtensions] inside the given [block]
         */
        fun csrExtensions(block: CsrExtensions.DslBuilder.() -> kotlin.Unit) {
            this.csrExtensions = CsrExtensions.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.Asn1Subject] inside the given [block]
         */
        fun subject(block: Asn1Subject.DslBuilder.() -> kotlin.Unit) {
            this.subject = Asn1Subject.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var csrExtensions: CsrExtensions? = null
        override var keyAlgorithm: KeyAlgorithm? = null
        override var signingAlgorithm: SigningAlgorithm? = null
        override var subject: Asn1Subject? = null

        constructor(x: CertificateAuthorityConfiguration) : this() {
            this.csrExtensions = x.csrExtensions
            this.keyAlgorithm = x.keyAlgorithm
            this.signingAlgorithm = x.signingAlgorithm
            this.subject = x.subject
        }

        override fun build(): CertificateAuthorityConfiguration = CertificateAuthorityConfiguration(this)
        override fun csrExtensions(csrExtensions: CsrExtensions): FluentBuilder = apply { this.csrExtensions = csrExtensions }
        override fun keyAlgorithm(keyAlgorithm: KeyAlgorithm): FluentBuilder = apply { this.keyAlgorithm = keyAlgorithm }
        override fun signingAlgorithm(signingAlgorithm: SigningAlgorithm): FluentBuilder = apply { this.signingAlgorithm = signingAlgorithm }
        override fun subject(subject: Asn1Subject): FluentBuilder = apply { this.subject = subject }
    }
}
