// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about your private certificate authority (CA). Your private CA
 * can issue and revoke X.509 digital certificates. Digital certificates verify that the
 * entity named in the certificate Subject field owns or
 * controls the public key contained in the Subject Public Key
 * Info field. Call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority action to create your private CA. You must then
 * call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificateAuthorityCertificate.html">GetCertificateAuthorityCertificate action to retrieve a private CA
 * certificate signing request (CSR). Sign the CSR with your ACM Private CA-hosted or on-premises
 * root or subordinate CA certificate. Call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ImportCertificateAuthorityCertificate.html">ImportCertificateAuthorityCertificate action to import the signed
 * certificate into AWS Certificate Manager (ACM).
 */
class CertificateAuthority private constructor(builder: BuilderImpl) {
    /**
     * Amazon Resource Name (ARN) for your private certificate authority (CA). The format is
     * 12345678-1234-1234-1234-123456789012
     * .
     */
    val arn: String? = builder.arn
    /**
     * Your private CA configuration.
     */
    val certificateAuthorityConfiguration: CertificateAuthorityConfiguration? = builder.certificateAuthorityConfiguration
    /**
     * Date and time at which your private CA was created.
     */
    val createdAt: Instant? = builder.createdAt
    /**
     * Reason the request to create your private CA failed.
     */
    val failureReason: FailureReason? = builder.failureReason
    /**
     * Defines a cryptographic key management compliance standard used for handling CA keys.
     * Default: FIPS_140_2_LEVEL_3_OR_HIGHER
     * Note: AWS Region ap-northeast-3 supports only FIPS_140_2_LEVEL_2_OR_HIGHER. You must
     * explicitly specify this parameter and value when creating a CA in that Region.
     * Specifying a different value (or no value) results in an
     * InvalidArgsException with the message "A certificate authority cannot
     * be created in this region with the specified security standard."
     */
    val keyStorageSecurityStandard: KeyStorageSecurityStandard? = builder.keyStorageSecurityStandard
    /**
     * Date and time at which your private CA was last updated.
     */
    val lastStateChangeAt: Instant? = builder.lastStateChangeAt
    /**
     * Date and time after which your private CA certificate is not valid.
     */
    val notAfter: Instant? = builder.notAfter
    /**
     * Date and time before which your private CA certificate is not valid.
     */
    val notBefore: Instant? = builder.notBefore
    /**
     * The AWS account ID that owns the certificate authority.
     */
    val ownerAccount: String? = builder.ownerAccount
    /**
     * The period during which a deleted CA can be restored. For more information, see the
     * PermanentDeletionTimeInDays parameter of the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeleteCertificateAuthorityRequest.html">DeleteCertificateAuthorityRequest action.
     */
    val restorableUntil: Instant? = builder.restorableUntil
    /**
     * Information about the Online Certificate Status Protocol (OCSP) configuration or
     * certificate revocation list (CRL) created and maintained by your private CA.
     */
    val revocationConfiguration: RevocationConfiguration? = builder.revocationConfiguration
    /**
     * Serial number of your private CA.
     */
    val serial: String? = builder.serial
    /**
     * Status of your private CA.
     */
    val status: CertificateAuthorityStatus? = builder.status
    /**
     * Type of your private CA.
     */
    val type: CertificateAuthorityType? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CertificateAuthority = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CertificateAuthority(")
        append("arn=$arn,")
        append("certificateAuthorityConfiguration=$certificateAuthorityConfiguration,")
        append("createdAt=$createdAt,")
        append("failureReason=$failureReason,")
        append("keyStorageSecurityStandard=$keyStorageSecurityStandard,")
        append("lastStateChangeAt=$lastStateChangeAt,")
        append("notAfter=$notAfter,")
        append("notBefore=$notBefore,")
        append("ownerAccount=$ownerAccount,")
        append("restorableUntil=$restorableUntil,")
        append("revocationConfiguration=$revocationConfiguration,")
        append("serial=$serial,")
        append("status=$status,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (certificateAuthorityConfiguration?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (keyStorageSecurityStandard?.hashCode() ?: 0)
        result = 31 * result + (lastStateChangeAt?.hashCode() ?: 0)
        result = 31 * result + (notAfter?.hashCode() ?: 0)
        result = 31 * result + (notBefore?.hashCode() ?: 0)
        result = 31 * result + (ownerAccount?.hashCode() ?: 0)
        result = 31 * result + (restorableUntil?.hashCode() ?: 0)
        result = 31 * result + (revocationConfiguration?.hashCode() ?: 0)
        result = 31 * result + (serial?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CertificateAuthority

        if (arn != other.arn) return false
        if (certificateAuthorityConfiguration != other.certificateAuthorityConfiguration) return false
        if (createdAt != other.createdAt) return false
        if (failureReason != other.failureReason) return false
        if (keyStorageSecurityStandard != other.keyStorageSecurityStandard) return false
        if (lastStateChangeAt != other.lastStateChangeAt) return false
        if (notAfter != other.notAfter) return false
        if (notBefore != other.notBefore) return false
        if (ownerAccount != other.ownerAccount) return false
        if (restorableUntil != other.restorableUntil) return false
        if (revocationConfiguration != other.revocationConfiguration) return false
        if (serial != other.serial) return false
        if (status != other.status) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CertificateAuthority = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CertificateAuthority
        /**
         * Amazon Resource Name (ARN) for your private certificate authority (CA). The format is
         * 12345678-1234-1234-1234-123456789012
         * .
         */
        fun arn(arn: String): FluentBuilder
        /**
         * Your private CA configuration.
         */
        fun certificateAuthorityConfiguration(certificateAuthorityConfiguration: CertificateAuthorityConfiguration): FluentBuilder
        /**
         * Date and time at which your private CA was created.
         */
        fun createdAt(createdAt: Instant): FluentBuilder
        /**
         * Reason the request to create your private CA failed.
         */
        fun failureReason(failureReason: FailureReason): FluentBuilder
        /**
         * Defines a cryptographic key management compliance standard used for handling CA keys.
         * Default: FIPS_140_2_LEVEL_3_OR_HIGHER
         * Note: AWS Region ap-northeast-3 supports only FIPS_140_2_LEVEL_2_OR_HIGHER. You must
         * explicitly specify this parameter and value when creating a CA in that Region.
         * Specifying a different value (or no value) results in an
         * InvalidArgsException with the message "A certificate authority cannot
         * be created in this region with the specified security standard."
         */
        fun keyStorageSecurityStandard(keyStorageSecurityStandard: KeyStorageSecurityStandard): FluentBuilder
        /**
         * Date and time at which your private CA was last updated.
         */
        fun lastStateChangeAt(lastStateChangeAt: Instant): FluentBuilder
        /**
         * Date and time after which your private CA certificate is not valid.
         */
        fun notAfter(notAfter: Instant): FluentBuilder
        /**
         * Date and time before which your private CA certificate is not valid.
         */
        fun notBefore(notBefore: Instant): FluentBuilder
        /**
         * The AWS account ID that owns the certificate authority.
         */
        fun ownerAccount(ownerAccount: String): FluentBuilder
        /**
         * The period during which a deleted CA can be restored. For more information, see the
         * PermanentDeletionTimeInDays parameter of the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeleteCertificateAuthorityRequest.html">DeleteCertificateAuthorityRequest action.
         */
        fun restorableUntil(restorableUntil: Instant): FluentBuilder
        /**
         * Information about the Online Certificate Status Protocol (OCSP) configuration or
         * certificate revocation list (CRL) created and maintained by your private CA.
         */
        fun revocationConfiguration(revocationConfiguration: RevocationConfiguration): FluentBuilder
        /**
         * Serial number of your private CA.
         */
        fun serial(serial: String): FluentBuilder
        /**
         * Status of your private CA.
         */
        fun status(status: CertificateAuthorityStatus): FluentBuilder
        /**
         * Type of your private CA.
         */
        fun type(type: CertificateAuthorityType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Amazon Resource Name (ARN) for your private certificate authority (CA). The format is
         * 12345678-1234-1234-1234-123456789012
         * .
         */
        var arn: String?
        /**
         * Your private CA configuration.
         */
        var certificateAuthorityConfiguration: CertificateAuthorityConfiguration?
        /**
         * Date and time at which your private CA was created.
         */
        var createdAt: Instant?
        /**
         * Reason the request to create your private CA failed.
         */
        var failureReason: FailureReason?
        /**
         * Defines a cryptographic key management compliance standard used for handling CA keys.
         * Default: FIPS_140_2_LEVEL_3_OR_HIGHER
         * Note: AWS Region ap-northeast-3 supports only FIPS_140_2_LEVEL_2_OR_HIGHER. You must
         * explicitly specify this parameter and value when creating a CA in that Region.
         * Specifying a different value (or no value) results in an
         * InvalidArgsException with the message "A certificate authority cannot
         * be created in this region with the specified security standard."
         */
        var keyStorageSecurityStandard: KeyStorageSecurityStandard?
        /**
         * Date and time at which your private CA was last updated.
         */
        var lastStateChangeAt: Instant?
        /**
         * Date and time after which your private CA certificate is not valid.
         */
        var notAfter: Instant?
        /**
         * Date and time before which your private CA certificate is not valid.
         */
        var notBefore: Instant?
        /**
         * The AWS account ID that owns the certificate authority.
         */
        var ownerAccount: String?
        /**
         * The period during which a deleted CA can be restored. For more information, see the
         * PermanentDeletionTimeInDays parameter of the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeleteCertificateAuthorityRequest.html">DeleteCertificateAuthorityRequest action.
         */
        var restorableUntil: Instant?
        /**
         * Information about the Online Certificate Status Protocol (OCSP) configuration or
         * certificate revocation list (CRL) created and maintained by your private CA.
         */
        var revocationConfiguration: RevocationConfiguration?
        /**
         * Serial number of your private CA.
         */
        var serial: String?
        /**
         * Status of your private CA.
         */
        var status: CertificateAuthorityStatus?
        /**
         * Type of your private CA.
         */
        var type: CertificateAuthorityType?

        fun build(): CertificateAuthority
        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.CertificateAuthorityConfiguration] inside the given [block]
         */
        fun certificateAuthorityConfiguration(block: CertificateAuthorityConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.certificateAuthorityConfiguration = CertificateAuthorityConfiguration.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.RevocationConfiguration] inside the given [block]
         */
        fun revocationConfiguration(block: RevocationConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.revocationConfiguration = RevocationConfiguration.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var certificateAuthorityConfiguration: CertificateAuthorityConfiguration? = null
        override var createdAt: Instant? = null
        override var failureReason: FailureReason? = null
        override var keyStorageSecurityStandard: KeyStorageSecurityStandard? = null
        override var lastStateChangeAt: Instant? = null
        override var notAfter: Instant? = null
        override var notBefore: Instant? = null
        override var ownerAccount: String? = null
        override var restorableUntil: Instant? = null
        override var revocationConfiguration: RevocationConfiguration? = null
        override var serial: String? = null
        override var status: CertificateAuthorityStatus? = null
        override var type: CertificateAuthorityType? = null

        constructor(x: CertificateAuthority) : this() {
            this.arn = x.arn
            this.certificateAuthorityConfiguration = x.certificateAuthorityConfiguration
            this.createdAt = x.createdAt
            this.failureReason = x.failureReason
            this.keyStorageSecurityStandard = x.keyStorageSecurityStandard
            this.lastStateChangeAt = x.lastStateChangeAt
            this.notAfter = x.notAfter
            this.notBefore = x.notBefore
            this.ownerAccount = x.ownerAccount
            this.restorableUntil = x.restorableUntil
            this.revocationConfiguration = x.revocationConfiguration
            this.serial = x.serial
            this.status = x.status
            this.type = x.type
        }

        override fun build(): CertificateAuthority = CertificateAuthority(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun certificateAuthorityConfiguration(certificateAuthorityConfiguration: CertificateAuthorityConfiguration): FluentBuilder = apply { this.certificateAuthorityConfiguration = certificateAuthorityConfiguration }
        override fun createdAt(createdAt: Instant): FluentBuilder = apply { this.createdAt = createdAt }
        override fun failureReason(failureReason: FailureReason): FluentBuilder = apply { this.failureReason = failureReason }
        override fun keyStorageSecurityStandard(keyStorageSecurityStandard: KeyStorageSecurityStandard): FluentBuilder = apply { this.keyStorageSecurityStandard = keyStorageSecurityStandard }
        override fun lastStateChangeAt(lastStateChangeAt: Instant): FluentBuilder = apply { this.lastStateChangeAt = lastStateChangeAt }
        override fun notAfter(notAfter: Instant): FluentBuilder = apply { this.notAfter = notAfter }
        override fun notBefore(notBefore: Instant): FluentBuilder = apply { this.notBefore = notBefore }
        override fun ownerAccount(ownerAccount: String): FluentBuilder = apply { this.ownerAccount = ownerAccount }
        override fun restorableUntil(restorableUntil: Instant): FluentBuilder = apply { this.restorableUntil = restorableUntil }
        override fun revocationConfiguration(revocationConfiguration: RevocationConfiguration): FluentBuilder = apply { this.revocationConfiguration = revocationConfiguration }
        override fun serial(serial: String): FluentBuilder = apply { this.serial = serial }
        override fun status(status: CertificateAuthorityStatus): FluentBuilder = apply { this.status = status }
        override fun type(type: CertificateAuthorityType): FluentBuilder = apply { this.type = type }
    }
}
