// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.acmpca.model.AcmPcaException
import aws.sdk.kotlin.services.acmpca.model.CreateCertificateAuthorityAuditReportResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateCertificateAuthorityAuditReportOperationDeserializer: HttpDeserialize<CreateCertificateAuthorityAuditReportResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateCertificateAuthorityAuditReportResponse {
        if (!response.status.isSuccess()) {
            throwCreateCertificateAuthorityAuditReportError(context, response)
        }
        val builder = CreateCertificateAuthorityAuditReportResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateCertificateAuthorityAuditReportOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateCertificateAuthorityAuditReportError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw AcmPcaException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidArgsException" -> InvalidArgsExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidArnException" -> InvalidArnExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidStateException" -> InvalidStateExceptionDeserializer().deserialize(context, wrappedResponse)
        "RequestFailedException" -> RequestFailedExceptionDeserializer().deserialize(context, wrappedResponse)
        "RequestInProgressException" -> RequestInProgressExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> AcmPcaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateCertificateAuthorityAuditReportOperationBody(builder: CreateCertificateAuthorityAuditReportResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUDITREPORTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AuditReportId"))
    val S3KEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("S3Key"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUDITREPORTID_DESCRIPTOR)
        field(S3KEY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUDITREPORTID_DESCRIPTOR.index -> builder.auditReportId = deserializeString()
                S3KEY_DESCRIPTOR.index -> builder.s3Key = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
