// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



public class RevokeCertificateRequest private constructor(builder: Builder) {
    /**
     * Amazon Resource Name (ARN) of the private CA that issued the certificate to be revoked. This must be of the form:
     *
     * `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `
     */
    public val certificateAuthorityArn: kotlin.String? = builder.certificateAuthorityArn
    /**
     * Serial number of the certificate to be revoked. This must be in hexadecimal format. You can retrieve the serial number by calling [GetCertificate](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificate.html) with the Amazon Resource Name (ARN) of the certificate you want and the ARN of your private CA. The **GetCertificate** action retrieves the certificate in the PEM format. You can use the following OpenSSL command to list the certificate in text format and copy the hexadecimal serial number.
     *
     * `openssl x509 -in <i>file_path</i> -text -noout`
     *
     * You can also copy the serial number from the console or use the [DescribeCertificate](https://docs.aws.amazon.com/acm/latest/APIReference/API_DescribeCertificate.html) action in the *Certificate Manager API Reference*.
     */
    public val certificateSerial: kotlin.String? = builder.certificateSerial
    /**
     * Specifies why you revoked the certificate.
     */
    public val revocationReason: aws.sdk.kotlin.services.acmpca.model.RevocationReason? = builder.revocationReason

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acmpca.model.RevokeCertificateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RevokeCertificateRequest(")
        append("certificateAuthorityArn=$certificateAuthorityArn,")
        append("certificateSerial=$certificateSerial,")
        append("revocationReason=$revocationReason)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateAuthorityArn?.hashCode() ?: 0
        result = 31 * result + (certificateSerial?.hashCode() ?: 0)
        result = 31 * result + (revocationReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RevokeCertificateRequest

        if (certificateAuthorityArn != other.certificateAuthorityArn) return false
        if (certificateSerial != other.certificateSerial) return false
        if (revocationReason != other.revocationReason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acmpca.model.RevokeCertificateRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Amazon Resource Name (ARN) of the private CA that issued the certificate to be revoked. This must be of the form:
         *
         * `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `
         */
        public var certificateAuthorityArn: kotlin.String? = null
        /**
         * Serial number of the certificate to be revoked. This must be in hexadecimal format. You can retrieve the serial number by calling [GetCertificate](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificate.html) with the Amazon Resource Name (ARN) of the certificate you want and the ARN of your private CA. The **GetCertificate** action retrieves the certificate in the PEM format. You can use the following OpenSSL command to list the certificate in text format and copy the hexadecimal serial number.
         *
         * `openssl x509 -in <i>file_path</i> -text -noout`
         *
         * You can also copy the serial number from the console or use the [DescribeCertificate](https://docs.aws.amazon.com/acm/latest/APIReference/API_DescribeCertificate.html) action in the *Certificate Manager API Reference*.
         */
        public var certificateSerial: kotlin.String? = null
        /**
         * Specifies why you revoked the certificate.
         */
        public var revocationReason: aws.sdk.kotlin.services.acmpca.model.RevocationReason? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acmpca.model.RevokeCertificateRequest) : this() {
            this.certificateAuthorityArn = x.certificateAuthorityArn
            this.certificateSerial = x.certificateSerial
            this.revocationReason = x.revocationReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acmpca.model.RevokeCertificateRequest = RevokeCertificateRequest(this)
    }
}
