// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



/**
 * Certificate revocation information used by the [CreateCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html) and [UpdateCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html) actions. Your private certificate authority (CA) can configure Online Certificate Status Protocol (OCSP) support and/or maintain a certificate revocation list (CRL). OCSP returns validation information about certificates as requested by clients, and a CRL contains an updated list of certificates revoked by your CA. For more information, see [RevokeCertificate](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_RevokeCertificate.html) and [Setting up a certificate revocation method](https://docs.aws.amazon.com/acm-pca/latest/userguide/revocation-setup.html) in the *Private Certificate Authority (PCA) User Guide*.
 */
public class RevocationConfiguration private constructor(builder: Builder) {
    /**
     * Configuration of the certificate revocation list (CRL), if any, maintained by your private CA. A CRL is typically updated approximately 30 minutes after a certificate is revoked. If for any reason a CRL update fails, ACM Private CA makes further attempts every 15 minutes.
     */
    public val crlConfiguration: aws.sdk.kotlin.services.acmpca.model.CrlConfiguration? = builder.crlConfiguration
    /**
     * Configuration of Online Certificate Status Protocol (OCSP) support, if any, maintained by your private CA. When you revoke a certificate, OCSP responses may take up to 60 minutes to reflect the new status.
     */
    public val ocspConfiguration: aws.sdk.kotlin.services.acmpca.model.OcspConfiguration? = builder.ocspConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acmpca.model.RevocationConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RevocationConfiguration(")
        append("crlConfiguration=$crlConfiguration,")
        append("ocspConfiguration=$ocspConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = crlConfiguration?.hashCode() ?: 0
        result = 31 * result + (ocspConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RevocationConfiguration

        if (crlConfiguration != other.crlConfiguration) return false
        if (ocspConfiguration != other.ocspConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acmpca.model.RevocationConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Configuration of the certificate revocation list (CRL), if any, maintained by your private CA. A CRL is typically updated approximately 30 minutes after a certificate is revoked. If for any reason a CRL update fails, ACM Private CA makes further attempts every 15 minutes.
         */
        public var crlConfiguration: aws.sdk.kotlin.services.acmpca.model.CrlConfiguration? = null
        /**
         * Configuration of Online Certificate Status Protocol (OCSP) support, if any, maintained by your private CA. When you revoke a certificate, OCSP responses may take up to 60 minutes to reflect the new status.
         */
        public var ocspConfiguration: aws.sdk.kotlin.services.acmpca.model.OcspConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acmpca.model.RevocationConfiguration) : this() {
            this.crlConfiguration = x.crlConfiguration
            this.ocspConfiguration = x.ocspConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acmpca.model.RevocationConfiguration = RevocationConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.CrlConfiguration] inside the given [block]
         */
        public fun crlConfiguration(block: aws.sdk.kotlin.services.acmpca.model.CrlConfiguration.Builder.() -> kotlin.Unit) {
            this.crlConfiguration = aws.sdk.kotlin.services.acmpca.model.CrlConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.OcspConfiguration] inside the given [block]
         */
        public fun ocspConfiguration(block: aws.sdk.kotlin.services.acmpca.model.OcspConfiguration.Builder.() -> kotlin.Unit) {
            this.ocspConfiguration = aws.sdk.kotlin.services.acmpca.model.OcspConfiguration.invoke(block)
        }
    }
}
