// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



/**
 * Contains information to enable and configure Online Certificate Status Protocol (OCSP) for validating certificate revocation status.
 *
 * When you revoke a certificate, OCSP responses may take up to 60 minutes to reflect the new status.
 */
public class OcspConfiguration private constructor(builder: Builder) {
    /**
     * Flag enabling use of the Online Certificate Status Protocol (OCSP) for validating certificate revocation status.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * By default, ACM Private CA injects an Amazon Web Services domain into certificates being validated by the Online Certificate Status Protocol (OCSP). A customer can alternatively use this object to define a CNAME specifying a customized OCSP domain.
     *
     * Note: The value of the CNAME must not include a protocol prefix such as "http://" or "https://".
     *
     * For more information, see [Customizing Online Certificate Status Protocol (OCSP) ](https://docs.aws.amazon.com/acm-pca/latest/userguide/ocsp-customize.html) in the *Private Certificate Authority (PCA) User Guide*.
     */
    public val ocspCustomCname: kotlin.String? = builder.ocspCustomCname

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acmpca.model.OcspConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OcspConfiguration(")
        append("enabled=$enabled,")
        append("ocspCustomCname=$ocspCustomCname)")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled?.hashCode() ?: 0
        result = 31 * result + (ocspCustomCname?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OcspConfiguration

        if (enabled != other.enabled) return false
        if (ocspCustomCname != other.ocspCustomCname) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acmpca.model.OcspConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Flag enabling use of the Online Certificate Status Protocol (OCSP) for validating certificate revocation status.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * By default, ACM Private CA injects an Amazon Web Services domain into certificates being validated by the Online Certificate Status Protocol (OCSP). A customer can alternatively use this object to define a CNAME specifying a customized OCSP domain.
         *
         * Note: The value of the CNAME must not include a protocol prefix such as "http://" or "https://".
         *
         * For more information, see [Customizing Online Certificate Status Protocol (OCSP) ](https://docs.aws.amazon.com/acm-pca/latest/userguide/ocsp-customize.html) in the *Private Certificate Authority (PCA) User Guide*.
         */
        public var ocspCustomCname: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acmpca.model.OcspConfiguration) : this() {
            this.enabled = x.enabled
            this.ocspCustomCname = x.ocspCustomCname
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acmpca.model.OcspConfiguration = OcspConfiguration(this)
    }
}
