// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



/**
 * Contains X.509 extension information for a certificate.
 */
public class Extensions private constructor(builder: Builder) {
    /**
     * Contains a sequence of one or more policy information terms, each of which consists of an object identifier (OID) and optional qualifiers. For more information, see NIST's definition of [Object Identifier (OID)](https://csrc.nist.gov/glossary/term/Object_Identifier).
     *
     * In an end-entity certificate, these terms indicate the policy under which the certificate was issued and the purposes for which it may be used. In a CA certificate, these terms limit the set of policies for certification paths that include this certificate.
     */
    public val certificatePolicies: List<PolicyInformation>? = builder.certificatePolicies
    /**
     * Contains a sequence of one or more X.509 extensions, each of which consists of an object identifier (OID), a base64-encoded value, and the critical flag. For more information, see the [Global OID reference database.](https://oidref.com/2.5.29)
     */
    public val customExtensions: List<CustomExtension>? = builder.customExtensions
    /**
     * Specifies additional purposes for which the certified public key may be used other than basic purposes indicated in the `KeyUsage` extension.
     */
    public val extendedKeyUsage: List<ExtendedKeyUsage>? = builder.extendedKeyUsage
    /**
     * Defines one or more purposes for which the key contained in the certificate can be used. Default value for each option is false.
     */
    public val keyUsage: aws.sdk.kotlin.services.acmpca.model.KeyUsage? = builder.keyUsage
    /**
     * The subject alternative name extension allows identities to be bound to the subject of the certificate. These identities may be included in addition to or in place of the identity in the subject field of the certificate.
     */
    public val subjectAlternativeNames: List<GeneralName>? = builder.subjectAlternativeNames

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acmpca.model.Extensions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Extensions(")
        append("certificatePolicies=$certificatePolicies,")
        append("customExtensions=$customExtensions,")
        append("extendedKeyUsage=$extendedKeyUsage,")
        append("keyUsage=$keyUsage,")
        append("subjectAlternativeNames=$subjectAlternativeNames)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificatePolicies?.hashCode() ?: 0
        result = 31 * result + (customExtensions?.hashCode() ?: 0)
        result = 31 * result + (extendedKeyUsage?.hashCode() ?: 0)
        result = 31 * result + (keyUsage?.hashCode() ?: 0)
        result = 31 * result + (subjectAlternativeNames?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Extensions

        if (certificatePolicies != other.certificatePolicies) return false
        if (customExtensions != other.customExtensions) return false
        if (extendedKeyUsage != other.extendedKeyUsage) return false
        if (keyUsage != other.keyUsage) return false
        if (subjectAlternativeNames != other.subjectAlternativeNames) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acmpca.model.Extensions = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Contains a sequence of one or more policy information terms, each of which consists of an object identifier (OID) and optional qualifiers. For more information, see NIST's definition of [Object Identifier (OID)](https://csrc.nist.gov/glossary/term/Object_Identifier).
         *
         * In an end-entity certificate, these terms indicate the policy under which the certificate was issued and the purposes for which it may be used. In a CA certificate, these terms limit the set of policies for certification paths that include this certificate.
         */
        public var certificatePolicies: List<PolicyInformation>? = null
        /**
         * Contains a sequence of one or more X.509 extensions, each of which consists of an object identifier (OID), a base64-encoded value, and the critical flag. For more information, see the [Global OID reference database.](https://oidref.com/2.5.29)
         */
        public var customExtensions: List<CustomExtension>? = null
        /**
         * Specifies additional purposes for which the certified public key may be used other than basic purposes indicated in the `KeyUsage` extension.
         */
        public var extendedKeyUsage: List<ExtendedKeyUsage>? = null
        /**
         * Defines one or more purposes for which the key contained in the certificate can be used. Default value for each option is false.
         */
        public var keyUsage: aws.sdk.kotlin.services.acmpca.model.KeyUsage? = null
        /**
         * The subject alternative name extension allows identities to be bound to the subject of the certificate. These identities may be included in addition to or in place of the identity in the subject field of the certificate.
         */
        public var subjectAlternativeNames: List<GeneralName>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acmpca.model.Extensions) : this() {
            this.certificatePolicies = x.certificatePolicies
            this.customExtensions = x.customExtensions
            this.extendedKeyUsage = x.extendedKeyUsage
            this.keyUsage = x.keyUsage
            this.subjectAlternativeNames = x.subjectAlternativeNames
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acmpca.model.Extensions = Extensions(this)

        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.KeyUsage] inside the given [block]
         */
        public fun keyUsage(block: aws.sdk.kotlin.services.acmpca.model.KeyUsage.Builder.() -> kotlin.Unit) {
            this.keyUsage = aws.sdk.kotlin.services.acmpca.model.KeyUsage.invoke(block)
        }
    }
}
