// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



/**
 * Describes the certificate extensions to be added to the certificate signing request (CSR).
 */
public class CsrExtensions private constructor(builder: Builder) {
    /**
     * Indicates the purpose of the certificate and of the key contained in the certificate.
     */
    public val keyUsage: aws.sdk.kotlin.services.acmpca.model.KeyUsage? = builder.keyUsage
    /**
     * For CA certificates, provides a path to additional information pertaining to the CA, such as revocation and policy. For more information, see [Subject Information Access](https://datatracker.ietf.org/doc/html/rfc5280#section-4.2.2.2) in RFC 5280.
     */
    public val subjectInformationAccess: List<AccessDescription>? = builder.subjectInformationAccess

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acmpca.model.CsrExtensions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CsrExtensions(")
        append("keyUsage=$keyUsage,")
        append("subjectInformationAccess=$subjectInformationAccess)")
    }

    override fun hashCode(): kotlin.Int {
        var result = keyUsage?.hashCode() ?: 0
        result = 31 * result + (subjectInformationAccess?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CsrExtensions

        if (keyUsage != other.keyUsage) return false
        if (subjectInformationAccess != other.subjectInformationAccess) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acmpca.model.CsrExtensions = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates the purpose of the certificate and of the key contained in the certificate.
         */
        public var keyUsage: aws.sdk.kotlin.services.acmpca.model.KeyUsage? = null
        /**
         * For CA certificates, provides a path to additional information pertaining to the CA, such as revocation and policy. For more information, see [Subject Information Access](https://datatracker.ietf.org/doc/html/rfc5280#section-4.2.2.2) in RFC 5280.
         */
        public var subjectInformationAccess: List<AccessDescription>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acmpca.model.CsrExtensions) : this() {
            this.keyUsage = x.keyUsage
            this.subjectInformationAccess = x.subjectInformationAccess
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acmpca.model.CsrExtensions = CsrExtensions(this)

        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.KeyUsage] inside the given [block]
         */
        public fun keyUsage(block: aws.sdk.kotlin.services.acmpca.model.KeyUsage.Builder.() -> kotlin.Unit) {
            this.keyUsage = aws.sdk.kotlin.services.acmpca.model.KeyUsage.invoke(block)
        }
    }
}
