// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



/**
 * Contains configuration information for a certificate revocation list (CRL). Your private certificate authority (CA) creates base CRLs. Delta CRLs are not supported. You can enable CRLs for your new or an existing private CA by setting the **Enabled** parameter to `true`. Your private CA writes CRLs to an S3 bucket that you specify in the **S3BucketName** parameter. You can hide the name of your bucket by specifying a value for the **CustomCname** parameter. Your private CA copies the CNAME or the S3 bucket name to the **CRL Distribution Points** extension of each certificate it issues. Your S3 bucket policy must give write permission to ACM Private CA.
 *
 * ACM Private CA assets that are stored in Amazon S3 can be protected with encryption. For more information, see [Encrypting Your CRLs](https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCreateCa.html#crl-encryption).
 *
 * Your private CA uses the value in the **ExpirationInDays** parameter to calculate the **nextUpdate** field in the CRL. The CRL is refreshed prior to a certificate's expiration date or when a certificate is revoked. When a certificate is revoked, it appears in the CRL until the certificate expires, and then in one additional CRL after expiration, and it always appears in the audit report.
 *
 * A CRL is typically updated approximately 30 minutes after a certificate is revoked. If for any reason a CRL update fails, ACM Private CA makes further attempts every 15 minutes.
 *
 * CRLs contain the following fields:
 * + **Version**: The current version number defined in RFC 5280 is V2. The integer value is 0x1.
 * + **Signature Algorithm**: The name of the algorithm used to sign the CRL.
 * + **Issuer**: The X.500 distinguished name of your private CA that issued the CRL.
 * + **Last Update**: The issue date and time of this CRL.
 * + **Next Update**: The day and time by which the next CRL will be issued.
 * + **Revoked Certificates**: List of revoked certificates. Each list item contains the following information.
 *    + **Serial Number**: The serial number, in hexadecimal format, of the revoked certificate.
 *    + **Revocation Date**: Date and time the certificate was revoked.
 *    + **CRL Entry Extensions**: Optional extensions for the CRL entry.
 *       + **X509v3 CRL Reason Code**: Reason the certificate was revoked.
 * + **CRL Extensions**: Optional extensions for the CRL.
 *    + **X509v3 Authority Key Identifier**: Identifies the public key associated with the private key used to sign the certificate.
 *    + **X509v3 CRL Number:**: Decimal sequence number for the CRL.
 * + **Signature Algorithm**: Algorithm used by your private CA to sign the CRL.
 * + **Signature Value**: Signature computed over the CRL.
 *
 * Certificate revocation lists created by ACM Private CA are DER-encoded. You can use the following OpenSSL command to list a CRL.
 *
 * `openssl crl -inform DER -text -in <i>crl_path</i> -noout`
 *
 * For more information, see [Planning a certificate revocation list (CRL)](https://docs.aws.amazon.com/acm-pca/latest/userguide/crl-planning.html) in the *Private Certificate Authority (PCA) User Guide*
 */
public class CrlConfiguration private constructor(builder: Builder) {
    /**
     * Name inserted into the certificate **CRL Distribution Points** extension that enables the use of an alias for the CRL distribution point. Use this value if you don't want the name of your S3 bucket to be public.
     */
    public val customCname: kotlin.String? = builder.customCname
    /**
     * Boolean value that specifies whether certificate revocation lists (CRLs) are enabled. You can use this value to enable certificate revocation for a new CA when you call the [CreateCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html) action or for an existing CA when you call the [UpdateCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html) action.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * Validity period of the CRL in days.
     */
    public val expirationInDays: kotlin.Int? = builder.expirationInDays
    /**
     * Name of the S3 bucket that contains the CRL. If you do not provide a value for the **CustomCname** argument, the name of your S3 bucket is placed into the **CRL Distribution Points** extension of the issued certificate. You can change the name of your bucket by calling the [UpdateCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html) operation. You must specify a [bucket policy](https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCreateCa.html#s3-policies) that allows ACM Private CA to write the CRL to your bucket.
     */
    public val s3BucketName: kotlin.String? = builder.s3BucketName
    /**
     * Determines whether the CRL will be publicly readable or privately held in the CRL Amazon S3 bucket. If you choose PUBLIC_READ, the CRL will be accessible over the public internet. If you choose BUCKET_OWNER_FULL_CONTROL, only the owner of the CRL S3 bucket can access the CRL, and your PKI clients may need an alternative method of access.
     *
     * If no value is specified, the default is `PUBLIC_READ`.
     *
     * *Note:* This default can cause CA creation to fail in some circumstances. If you have have enabled the Block Public Access (BPA) feature in your S3 account, then you must specify the value of this parameter as `BUCKET_OWNER_FULL_CONTROL`, and not doing so results in an error. If you have disabled BPA in S3, then you can specify either `BUCKET_OWNER_FULL_CONTROL` or `PUBLIC_READ` as the value.
     *
     * For more information, see [Blocking public access to the S3 bucket](https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCreateCa.html#s3-bpa).
     */
    public val s3ObjectAcl: aws.sdk.kotlin.services.acmpca.model.S3ObjectAcl? = builder.s3ObjectAcl

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acmpca.model.CrlConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CrlConfiguration(")
        append("customCname=$customCname,")
        append("enabled=$enabled,")
        append("expirationInDays=$expirationInDays,")
        append("s3BucketName=$s3BucketName,")
        append("s3ObjectAcl=$s3ObjectAcl)")
    }

    override fun hashCode(): kotlin.Int {
        var result = customCname?.hashCode() ?: 0
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (expirationInDays ?: 0)
        result = 31 * result + (s3BucketName?.hashCode() ?: 0)
        result = 31 * result + (s3ObjectAcl?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CrlConfiguration

        if (customCname != other.customCname) return false
        if (enabled != other.enabled) return false
        if (expirationInDays != other.expirationInDays) return false
        if (s3BucketName != other.s3BucketName) return false
        if (s3ObjectAcl != other.s3ObjectAcl) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acmpca.model.CrlConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Name inserted into the certificate **CRL Distribution Points** extension that enables the use of an alias for the CRL distribution point. Use this value if you don't want the name of your S3 bucket to be public.
         */
        public var customCname: kotlin.String? = null
        /**
         * Boolean value that specifies whether certificate revocation lists (CRLs) are enabled. You can use this value to enable certificate revocation for a new CA when you call the [CreateCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html) action or for an existing CA when you call the [UpdateCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html) action.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * Validity period of the CRL in days.
         */
        public var expirationInDays: kotlin.Int? = null
        /**
         * Name of the S3 bucket that contains the CRL. If you do not provide a value for the **CustomCname** argument, the name of your S3 bucket is placed into the **CRL Distribution Points** extension of the issued certificate. You can change the name of your bucket by calling the [UpdateCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html) operation. You must specify a [bucket policy](https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCreateCa.html#s3-policies) that allows ACM Private CA to write the CRL to your bucket.
         */
        public var s3BucketName: kotlin.String? = null
        /**
         * Determines whether the CRL will be publicly readable or privately held in the CRL Amazon S3 bucket. If you choose PUBLIC_READ, the CRL will be accessible over the public internet. If you choose BUCKET_OWNER_FULL_CONTROL, only the owner of the CRL S3 bucket can access the CRL, and your PKI clients may need an alternative method of access.
         *
         * If no value is specified, the default is `PUBLIC_READ`.
         *
         * *Note:* This default can cause CA creation to fail in some circumstances. If you have have enabled the Block Public Access (BPA) feature in your S3 account, then you must specify the value of this parameter as `BUCKET_OWNER_FULL_CONTROL`, and not doing so results in an error. If you have disabled BPA in S3, then you can specify either `BUCKET_OWNER_FULL_CONTROL` or `PUBLIC_READ` as the value.
         *
         * For more information, see [Blocking public access to the S3 bucket](https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCreateCa.html#s3-bpa).
         */
        public var s3ObjectAcl: aws.sdk.kotlin.services.acmpca.model.S3ObjectAcl? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acmpca.model.CrlConfiguration) : this() {
            this.customCname = x.customCname
            this.enabled = x.enabled
            this.expirationInDays = x.expirationInDays
            this.s3BucketName = x.s3BucketName
            this.s3ObjectAcl = x.s3ObjectAcl
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acmpca.model.CrlConfiguration = CrlConfiguration(this)
    }
}
