// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



public class CreatePermissionRequest private constructor(builder: Builder) {
    /**
     * The actions that the specified Amazon Web Services service principal can use. These include `IssueCertificate`, `GetCertificate`, and `ListPermissions`.
     */
    public val actions: List<ActionType>? = builder.actions
    /**
     * The Amazon Resource Name (ARN) of the CA that grants the permissions. You can find the ARN by calling the [ListCertificateAuthorities](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html) action. This must have the following form:
     *
     * `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `.
     */
    public val certificateAuthorityArn: kotlin.String? = builder.certificateAuthorityArn
    /**
     * The Amazon Web Services service or identity that receives the permission. At this time, the only valid principal is `acm.amazonaws.com`.
     */
    public val principal: kotlin.String? = builder.principal
    /**
     * The ID of the calling account.
     */
    public val sourceAccount: kotlin.String? = builder.sourceAccount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acmpca.model.CreatePermissionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreatePermissionRequest(")
        append("actions=$actions,")
        append("certificateAuthorityArn=$certificateAuthorityArn,")
        append("principal=$principal,")
        append("sourceAccount=$sourceAccount)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (certificateAuthorityArn?.hashCode() ?: 0)
        result = 31 * result + (principal?.hashCode() ?: 0)
        result = 31 * result + (sourceAccount?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreatePermissionRequest

        if (actions != other.actions) return false
        if (certificateAuthorityArn != other.certificateAuthorityArn) return false
        if (principal != other.principal) return false
        if (sourceAccount != other.sourceAccount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acmpca.model.CreatePermissionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The actions that the specified Amazon Web Services service principal can use. These include `IssueCertificate`, `GetCertificate`, and `ListPermissions`.
         */
        public var actions: List<ActionType>? = null
        /**
         * The Amazon Resource Name (ARN) of the CA that grants the permissions. You can find the ARN by calling the [ListCertificateAuthorities](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html) action. This must have the following form:
         *
         * `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `.
         */
        public var certificateAuthorityArn: kotlin.String? = null
        /**
         * The Amazon Web Services service or identity that receives the permission. At this time, the only valid principal is `acm.amazonaws.com`.
         */
        public var principal: kotlin.String? = null
        /**
         * The ID of the calling account.
         */
        public var sourceAccount: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acmpca.model.CreatePermissionRequest) : this() {
            this.actions = x.actions
            this.certificateAuthorityArn = x.certificateAuthorityArn
            this.principal = x.principal
            this.sourceAccount = x.sourceAccount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acmpca.model.CreatePermissionRequest = CreatePermissionRequest(this)
    }
}
