// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



/**
 * Contains X.509 certificate information to be placed in an issued certificate. An `APIPassthrough` or `APICSRPassthrough` template variant must be selected, or else this parameter is ignored.
 *
 * If conflicting or duplicate certificate information is supplied from other sources, ACM Private CA applies [order of operation rules](https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html#template-order-of-operations) to determine what information is used.
 */
public class ApiPassthrough private constructor(builder: Builder) {
    /**
     * Specifies X.509 extension information for a certificate.
     */
    public val extensions: aws.sdk.kotlin.services.acmpca.model.Extensions? = builder.extensions
    /**
     * Contains information about the certificate subject. The `Subject` field in the certificate identifies the entity that owns or controls the public key in the certificate. The entity can be a user, computer, device, or service. The `Subject `must contain an X.500 distinguished name (DN). A DN is a sequence of relative distinguished names (RDNs). The RDNs are separated by commas in the certificate.
     */
    public val subject: aws.sdk.kotlin.services.acmpca.model.Asn1Subject? = builder.subject

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acmpca.model.ApiPassthrough = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApiPassthrough(")
        append("extensions=$extensions,")
        append("subject=$subject)")
    }

    override fun hashCode(): kotlin.Int {
        var result = extensions?.hashCode() ?: 0
        result = 31 * result + (subject?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ApiPassthrough

        if (extensions != other.extensions) return false
        if (subject != other.subject) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acmpca.model.ApiPassthrough = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies X.509 extension information for a certificate.
         */
        public var extensions: aws.sdk.kotlin.services.acmpca.model.Extensions? = null
        /**
         * Contains information about the certificate subject. The `Subject` field in the certificate identifies the entity that owns or controls the public key in the certificate. The entity can be a user, computer, device, or service. The `Subject `must contain an X.500 distinguished name (DN). A DN is a sequence of relative distinguished names (RDNs). The RDNs are separated by commas in the certificate.
         */
        public var subject: aws.sdk.kotlin.services.acmpca.model.Asn1Subject? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acmpca.model.ApiPassthrough) : this() {
            this.extensions = x.extensions
            this.subject = x.subject
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acmpca.model.ApiPassthrough = ApiPassthrough(this)

        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.Extensions] inside the given [block]
         */
        public fun extensions(block: aws.sdk.kotlin.services.acmpca.model.Extensions.Builder.() -> kotlin.Unit) {
            this.extensions = aws.sdk.kotlin.services.acmpca.model.Extensions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.Asn1Subject] inside the given [block]
         */
        public fun subject(block: aws.sdk.kotlin.services.acmpca.model.Asn1Subject.Builder.() -> kotlin.Unit) {
            this.subject = aws.sdk.kotlin.services.acmpca.model.Asn1Subject.invoke(block)
        }
    }
}
