// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.acmpca.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.acmpca.model.*
import aws.sdk.kotlin.services.acmpca.model.CreateCertificateAuthorityAuditReportRequest
import aws.sdk.kotlin.services.acmpca.model.CreateCertificateAuthorityAuditReportResponse
import aws.sdk.kotlin.services.acmpca.model.CreateCertificateAuthorityRequest
import aws.sdk.kotlin.services.acmpca.model.CreateCertificateAuthorityResponse
import aws.sdk.kotlin.services.acmpca.model.CreatePermissionRequest
import aws.sdk.kotlin.services.acmpca.model.CreatePermissionResponse
import aws.sdk.kotlin.services.acmpca.model.DeleteCertificateAuthorityRequest
import aws.sdk.kotlin.services.acmpca.model.DeleteCertificateAuthorityResponse
import aws.sdk.kotlin.services.acmpca.model.DeletePermissionRequest
import aws.sdk.kotlin.services.acmpca.model.DeletePermissionResponse
import aws.sdk.kotlin.services.acmpca.model.DeletePolicyRequest
import aws.sdk.kotlin.services.acmpca.model.DeletePolicyResponse
import aws.sdk.kotlin.services.acmpca.model.DescribeCertificateAuthorityAuditReportRequest
import aws.sdk.kotlin.services.acmpca.model.DescribeCertificateAuthorityAuditReportResponse
import aws.sdk.kotlin.services.acmpca.model.DescribeCertificateAuthorityRequest
import aws.sdk.kotlin.services.acmpca.model.DescribeCertificateAuthorityResponse
import aws.sdk.kotlin.services.acmpca.model.GetCertificateAuthorityCertificateRequest
import aws.sdk.kotlin.services.acmpca.model.GetCertificateAuthorityCertificateResponse
import aws.sdk.kotlin.services.acmpca.model.GetCertificateAuthorityCsrRequest
import aws.sdk.kotlin.services.acmpca.model.GetCertificateAuthorityCsrResponse
import aws.sdk.kotlin.services.acmpca.model.GetCertificateRequest
import aws.sdk.kotlin.services.acmpca.model.GetCertificateResponse
import aws.sdk.kotlin.services.acmpca.model.GetPolicyRequest
import aws.sdk.kotlin.services.acmpca.model.GetPolicyResponse
import aws.sdk.kotlin.services.acmpca.model.ImportCertificateAuthorityCertificateRequest
import aws.sdk.kotlin.services.acmpca.model.ImportCertificateAuthorityCertificateResponse
import aws.sdk.kotlin.services.acmpca.model.IssueCertificateRequest
import aws.sdk.kotlin.services.acmpca.model.IssueCertificateResponse
import aws.sdk.kotlin.services.acmpca.model.ListCertificateAuthoritiesRequest
import aws.sdk.kotlin.services.acmpca.model.ListCertificateAuthoritiesResponse
import aws.sdk.kotlin.services.acmpca.model.ListPermissionsRequest
import aws.sdk.kotlin.services.acmpca.model.ListPermissionsResponse
import aws.sdk.kotlin.services.acmpca.model.ListTagsRequest
import aws.sdk.kotlin.services.acmpca.model.ListTagsResponse
import aws.sdk.kotlin.services.acmpca.model.PutPolicyRequest
import aws.sdk.kotlin.services.acmpca.model.PutPolicyResponse
import aws.sdk.kotlin.services.acmpca.model.RestoreCertificateAuthorityRequest
import aws.sdk.kotlin.services.acmpca.model.RestoreCertificateAuthorityResponse
import aws.sdk.kotlin.services.acmpca.model.RevokeCertificateRequest
import aws.sdk.kotlin.services.acmpca.model.RevokeCertificateResponse
import aws.sdk.kotlin.services.acmpca.model.TagCertificateAuthorityRequest
import aws.sdk.kotlin.services.acmpca.model.TagCertificateAuthorityResponse
import aws.sdk.kotlin.services.acmpca.model.UntagCertificateAuthorityRequest
import aws.sdk.kotlin.services.acmpca.model.UntagCertificateAuthorityResponse
import aws.sdk.kotlin.services.acmpca.model.UpdateCertificateAuthorityRequest
import aws.sdk.kotlin.services.acmpca.model.UpdateCertificateAuthorityResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * This is the *Private Certificate Authority (PCA) API Reference*. It provides descriptions, syntax, and usage examples for each of the actions and data types involved in creating and managing a private certificate authority (CA) for your organization.
 *
 * The documentation for each action shows the API request parameters and the JSON response. Alternatively, you can use one of the Amazon Web Services SDKs to access an API that is tailored to the programming language or platform that you prefer. For more information, see [Amazon Web Services SDKs](https://aws.amazon.com/tools/#SDKs).
 *
 * Each ACM Private CA API operation has a quota that determines the number of times the operation can be called per second. ACM Private CA throttles API requests at different rates depending on the operation. Throttling means that ACM Private CA rejects an otherwise valid request because the request exceeds the operation's quota for the number of requests per second. When a request is throttled, ACM Private CA returns a [ThrottlingException](https://docs.aws.amazon.com/acm-pca/latest/APIReference/CommonErrors.html) error. ACM Private CA does not guarantee a minimum request rate for APIs.
 *
 * To see an up-to-date list of your ACM Private CA quotas, or to request a quota increase, log into your Amazon Web Services account and visit the [Service Quotas](https://console.aws.amazon.com/servicequotas/) console.
 */
public interface AcmPcaClient : SdkClient {

    override val serviceName: String
        get() = "ACM PCA"
    /**
     * AcmPcaClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): AcmPcaClient {
            val config = Config.Builder().apply(block).build()
            return DefaultAcmPcaClient(config)
        }

        public operator fun invoke(config: Config): AcmPcaClient = DefaultAcmPcaClient(config)

        /**
         * Construct a [AcmPcaClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): AcmPcaClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultAcmPcaClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a root or subordinate private certificate authority (CA). You must specify the CA configuration, an optional configuration for Online Certificate Status Protocol (OCSP) and/or a certificate revocation list (CRL), the CA type, and an optional idempotency token to avoid accidental creation of multiple CAs. The CA configuration specifies the name of the algorithm and key size to be used to create the CA private key, the type of signing algorithm that the CA uses, and X.500 subject information. The OCSP configuration can optionally specify a custom URL for the OCSP responder. The CRL configuration specifies the CRL expiration period in days (the validity period of the CRL), the Amazon S3 bucket that will contain the CRL, and a CNAME alias for the S3 bucket that is included in certificates issued by the CA. If successful, this action returns the Amazon Resource Name (ARN) of the CA.
     *
     * ACM Private CA assets that are stored in Amazon S3 can be protected with encryption. For more information, see [Encrypting Your CRLs](https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCreateCa.html#crl-encryption).
     *
     * Both PCA and the IAM principal must have permission to write to the S3 bucket that you specify. If the IAM principal making the call does not have permission to write to the bucket, then an exception is thrown. For more information, see [Access policies for CRLs in Amazon S3](https://docs.aws.amazon.com/acm-pca/latest/userguide/crl-planning.html#s3-policies).
     */
    public suspend fun createCertificateAuthority(input: CreateCertificateAuthorityRequest): CreateCertificateAuthorityResponse

    /**
     * Creates an audit report that lists every time that your CA private key is used. The report is saved in the Amazon S3 bucket that you specify on input. The [IssueCertificate](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_IssueCertificate.html) and [RevokeCertificate](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_RevokeCertificate.html) actions use the private key.
     *
     * Both PCA and the IAM principal must have permission to write to the S3 bucket that you specify. If the IAM principal making the call does not have permission to write to the bucket, then an exception is thrown. For more information, see [Access policies for CRLs in Amazon S3](https://docs.aws.amazon.com/acm-pca/latest/userguide/crl-planning.html#s3-policies).
     *
     * ACM Private CA assets that are stored in Amazon S3 can be protected with encryption. For more information, see [Encrypting Your Audit Reports](https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaAuditReport.html#audit-report-encryption).
     *
     * You can generate a maximum of one report every 30 minutes.
     */
    public suspend fun createCertificateAuthorityAuditReport(input: CreateCertificateAuthorityAuditReportRequest): CreateCertificateAuthorityAuditReportResponse

    /**
     * Grants one or more permissions on a private CA to the Certificate Manager (ACM) service principal (`acm.amazonaws.com`). These permissions allow ACM to issue and renew ACM certificates that reside in the same Amazon Web Services account as the CA.
     *
     * You can list current permissions with the [ListPermissions](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListPermissions.html) action and revoke them with the [DeletePermission](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePermission.html) action.
     *
     * **About Permissions**
     * + If the private CA and the certificates it issues reside in the same account, you can use `CreatePermission` to grant permissions for ACM to carry out automatic certificate renewals.
     * + For automatic certificate renewal to succeed, the ACM service principal needs permissions to create, retrieve, and list certificates.
     * + If the private CA and the ACM certificates reside in different accounts, then permissions cannot be used to enable automatic renewals. Instead, the ACM certificate owner must set up a resource-based policy to enable cross-account issuance and renewals. For more information, see [Using a Resource Based Policy with ACM Private CA](https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html).
     */
    public suspend fun createPermission(input: CreatePermissionRequest): CreatePermissionResponse

    /**
     * Deletes a private certificate authority (CA). You must provide the Amazon Resource Name (ARN) of the private CA that you want to delete. You can find the ARN by calling the [ListCertificateAuthorities](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html) action.
     *
     * Deleting a CA will invalidate other CAs and certificates below it in your CA hierarchy.
     *
     * Before you can delete a CA that you have created and activated, you must disable it. To do this, call the [UpdateCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html) action and set the **CertificateAuthorityStatus** parameter to `DISABLED`.
     *
     * Additionally, you can delete a CA if you are waiting for it to be created (that is, the status of the CA is `CREATING`). You can also delete it if the CA has been created but you haven't yet imported the signed certificate into ACM Private CA (that is, the status of the CA is `PENDING_CERTIFICATE`).
     *
     * When you successfully call [DeleteCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeleteCertificateAuthority.html), the CA's status changes to `DELETED`. However, the CA won't be permanently deleted until the restoration period has passed. By default, if you do not set the `PermanentDeletionTimeInDays` parameter, the CA remains restorable for 30 days. You can set the parameter from 7 to 30 days. The [DescribeCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DescribeCertificateAuthority.html) action returns the time remaining in the restoration window of a private CA in the `DELETED` state. To restore an eligible CA, call the [RestoreCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_RestoreCertificateAuthority.html) action.
     */
    public suspend fun deleteCertificateAuthority(input: DeleteCertificateAuthorityRequest): DeleteCertificateAuthorityResponse

    /**
     * Revokes permissions on a private CA granted to the Certificate Manager (ACM) service principal (acm.amazonaws.com).
     *
     * These permissions allow ACM to issue and renew ACM certificates that reside in the same Amazon Web Services account as the CA. If you revoke these permissions, ACM will no longer renew the affected certificates automatically.
     *
     * Permissions can be granted with the [CreatePermission](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreatePermission.html) action and listed with the [ListPermissions](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListPermissions.html) action.
     *
     * **About Permissions**
     * + If the private CA and the certificates it issues reside in the same account, you can use `CreatePermission` to grant permissions for ACM to carry out automatic certificate renewals.
     * + For automatic certificate renewal to succeed, the ACM service principal needs permissions to create, retrieve, and list certificates.
     * + If the private CA and the ACM certificates reside in different accounts, then permissions cannot be used to enable automatic renewals. Instead, the ACM certificate owner must set up a resource-based policy to enable cross-account issuance and renewals. For more information, see [Using a Resource Based Policy with ACM Private CA](https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html).
     */
    public suspend fun deletePermission(input: DeletePermissionRequest): DeletePermissionResponse

    /**
     * Deletes the resource-based policy attached to a private CA. Deletion will remove any access that the policy has granted. If there is no policy attached to the private CA, this action will return successful.
     *
     * If you delete a policy that was applied through Amazon Web Services Resource Access Manager (RAM), the CA will be removed from all shares in which it was included.
     *
     * The Certificate Manager Service Linked Role that the policy supports is not affected when you delete the policy.
     *
     * The current policy can be shown with [GetPolicy](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetPolicy.html) and updated with [PutPolicy](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_PutPolicy.html).
     *
     * **About Policies**
     * + A policy grants access on a private CA to an Amazon Web Services customer account, to Amazon Web Services Organizations, or to an Amazon Web Services Organizations unit. Policies are under the control of a CA administrator. For more information, see [Using a Resource Based Policy with ACM Private CA](https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html).
     * + A policy permits a user of Certificate Manager (ACM) to issue ACM certificates signed by a CA in another account.
     * + For ACM to manage automatic renewal of these certificates, the ACM user must configure a Service Linked Role (SLR). The SLR allows the ACM service to assume the identity of the user, subject to confirmation against the ACM Private CA policy. For more information, see [Using a Service Linked Role with ACM](https://docs.aws.amazon.com/acm/latest/userguide/acm-slr.html).
     * + Updates made in Amazon Web Services Resource Manager (RAM) are reflected in policies. For more information, see [Attach a Policy for Cross-Account Access](https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-ram.html).
     */
    public suspend fun deletePolicy(input: DeletePolicyRequest): DeletePolicyResponse

    /**
     * Lists information about your private certificate authority (CA) or one that has been shared with you. You specify the private CA on input by its ARN (Amazon Resource Name). The output contains the status of your CA. This can be any of the following:
     * + `CREATING` - ACM Private CA is creating your private certificate authority.
     * + `PENDING_CERTIFICATE` - The certificate is pending. You must use your ACM Private CA-hosted or on-premises root or subordinate CA to sign your private CA CSR and then import it into PCA.
     * + `ACTIVE` - Your private CA is active.
     * + `DISABLED` - Your private CA has been disabled.
     * + `EXPIRED` - Your private CA certificate has expired.
     * + `FAILED` - Your private CA has failed. Your CA can fail because of problems such a network outage or back-end Amazon Web Services failure or other errors. A failed CA can never return to the pending state. You must create a new CA.
     * + `DELETED` - Your private CA is within the restoration period, after which it is permanently deleted. The length of time remaining in the CA's restoration period is also included in this action's output.
     */
    public suspend fun describeCertificateAuthority(input: DescribeCertificateAuthorityRequest): DescribeCertificateAuthorityResponse

    /**
     * Lists information about a specific audit report created by calling the [CreateCertificateAuthorityAuditReport](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html) action. Audit information is created every time the certificate authority (CA) private key is used. The private key is used when you call the [IssueCertificate](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_IssueCertificate.html) action or the [RevokeCertificate](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_RevokeCertificate.html) action.
     */
    public suspend fun describeCertificateAuthorityAuditReport(input: DescribeCertificateAuthorityAuditReportRequest): DescribeCertificateAuthorityAuditReportResponse

    /**
     * Retrieves a certificate from your private CA or one that has been shared with you. The ARN of the certificate is returned when you call the [IssueCertificate](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_IssueCertificate.html) action. You must specify both the ARN of your private CA and the ARN of the issued certificate when calling the **GetCertificate** action. You can retrieve the certificate if it is in the **ISSUED** state. You can call the [CreateCertificateAuthorityAuditReport](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html) action to create a report that contains information about all of the certificates issued and revoked by your private CA.
     */
    public suspend fun getCertificate(input: GetCertificateRequest): GetCertificateResponse

    /**
     * Retrieves the certificate and certificate chain for your private certificate authority (CA) or one that has been shared with you. Both the certificate and the chain are base64 PEM-encoded. The chain does not include the CA certificate. Each certificate in the chain signs the one before it.
     */
    public suspend fun getCertificateAuthorityCertificate(input: GetCertificateAuthorityCertificateRequest): GetCertificateAuthorityCertificateResponse

    /**
     * Retrieves the certificate signing request (CSR) for your private certificate authority (CA). The CSR is created when you call the [CreateCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html) action. Sign the CSR with your ACM Private CA-hosted or on-premises root or subordinate CA. Then import the signed certificate back into ACM Private CA by calling the [ImportCertificateAuthorityCertificate](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ImportCertificateAuthorityCertificate.html) action. The CSR is returned as a base64 PEM-encoded string.
     */
    public suspend fun getCertificateAuthorityCsr(input: GetCertificateAuthorityCsrRequest): GetCertificateAuthorityCsrResponse

    /**
     * Retrieves the resource-based policy attached to a private CA. If either the private CA resource or the policy cannot be found, this action returns a `ResourceNotFoundException`.
     *
     * The policy can be attached or updated with [PutPolicy](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_PutPolicy.html) and removed with [DeletePolicy](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePolicy.html).
     *
     * **About Policies**
     * + A policy grants access on a private CA to an Amazon Web Services customer account, to Amazon Web Services Organizations, or to an Amazon Web Services Organizations unit. Policies are under the control of a CA administrator. For more information, see [Using a Resource Based Policy with ACM Private CA](https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html).
     * + A policy permits a user of Certificate Manager (ACM) to issue ACM certificates signed by a CA in another account.
     * + For ACM to manage automatic renewal of these certificates, the ACM user must configure a Service Linked Role (SLR). The SLR allows the ACM service to assume the identity of the user, subject to confirmation against the ACM Private CA policy. For more information, see [Using a Service Linked Role with ACM](https://docs.aws.amazon.com/acm/latest/userguide/acm-slr.html).
     * + Updates made in Amazon Web Services Resource Manager (RAM) are reflected in policies. For more information, see [Attach a Policy for Cross-Account Access](https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-ram.html).
     */
    public suspend fun getPolicy(input: GetPolicyRequest): GetPolicyResponse

    /**
     * Imports a signed private CA certificate into ACM Private CA. This action is used when you are using a chain of trust whose root is located outside ACM Private CA. Before you can call this action, the following preparations must in place:
     * + In ACM Private CA, call the [CreateCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html) action to create the private CA that you plan to back with the imported certificate.
     * + Call the [GetCertificateAuthorityCsr](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificateAuthorityCsr.html) action to generate a certificate signing request (CSR).
     * + Sign the CSR using a root or intermediate CA hosted by either an on-premises PKI hierarchy or by a commercial CA.
     * + Create a certificate chain and copy the signed certificate and the certificate chain to your working directory.
     *
     * ACM Private CA supports three scenarios for installing a CA certificate:
     * + Installing a certificate for a root CA hosted by ACM Private CA.
     * + Installing a subordinate CA certificate whose parent authority is hosted by ACM Private CA.
     * + Installing a subordinate CA certificate whose parent authority is externally hosted.
     *
     * The following additional requirements apply when you import a CA certificate.
     * + Only a self-signed certificate can be imported as a root CA.
     * + A self-signed certificate cannot be imported as a subordinate CA.
     * + Your certificate chain must not include the private CA certificate that you are importing.
     * + Your root CA must be the last certificate in your chain. The subordinate certificate, if any, that your root CA signed must be next to last. The subordinate certificate signed by the preceding subordinate CA must come next, and so on until your chain is built.
     * + The chain must be PEM-encoded.
     * + The maximum allowed size of a certificate is 32 KB.
     * + The maximum allowed size of a certificate chain is 2 MB.
     *
     * *Enforcement of Critical Constraints*
     *
     * ACM Private CA allows the following extensions to be marked critical in the imported CA certificate or chain.
     * + Basic constraints (*must* be marked critical)
     * + Subject alternative names
     * + Key usage
     * + Extended key usage
     * + Authority key identifier
     * + Subject key identifier
     * + Issuer alternative name
     * + Subject directory attributes
     * + Subject information access
     * + Certificate policies
     * + Policy mappings
     * + Inhibit anyPolicy
     *
     * ACM Private CA rejects the following extensions when they are marked critical in an imported CA certificate or chain.
     * + Name constraints
     * + Policy constraints
     * + CRL distribution points
     * + Authority information access
     * + Freshest CRL
     * + Any other extension
     */
    public suspend fun importCertificateAuthorityCertificate(input: ImportCertificateAuthorityCertificateRequest): ImportCertificateAuthorityCertificateResponse

    /**
     * Uses your private certificate authority (CA), or one that has been shared with you, to issue a client certificate. This action returns the Amazon Resource Name (ARN) of the certificate. You can retrieve the certificate by calling the [GetCertificate](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificate.html) action and specifying the ARN.
     *
     * You cannot use the ACM **ListCertificateAuthorities** action to retrieve the ARNs of the certificates that you issue by using ACM Private CA.
     */
    public suspend fun issueCertificate(input: IssueCertificateRequest): IssueCertificateResponse

    /**
     * Lists the private certificate authorities that you created by using the [CreateCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html) action.
     */
    public suspend fun listCertificateAuthorities(input: ListCertificateAuthoritiesRequest = ListCertificateAuthoritiesRequest {}): ListCertificateAuthoritiesResponse

    /**
     * List all permissions on a private CA, if any, granted to the Certificate Manager (ACM) service principal (acm.amazonaws.com).
     *
     * These permissions allow ACM to issue and renew ACM certificates that reside in the same Amazon Web Services account as the CA.
     *
     * Permissions can be granted with the [CreatePermission](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreatePermission.html) action and revoked with the [DeletePermission](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePermission.html) action.
     *
     * **About Permissions**
     * + If the private CA and the certificates it issues reside in the same account, you can use `CreatePermission` to grant permissions for ACM to carry out automatic certificate renewals.
     * + For automatic certificate renewal to succeed, the ACM service principal needs permissions to create, retrieve, and list certificates.
     * + If the private CA and the ACM certificates reside in different accounts, then permissions cannot be used to enable automatic renewals. Instead, the ACM certificate owner must set up a resource-based policy to enable cross-account issuance and renewals. For more information, see [Using a Resource Based Policy with ACM Private CA](https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html).
     */
    public suspend fun listPermissions(input: ListPermissionsRequest): ListPermissionsResponse

    /**
     * Lists the tags, if any, that are associated with your private CA or one that has been shared with you. Tags are labels that you can use to identify and organize your CAs. Each tag consists of a key and an optional value. Call the [TagCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_TagCertificateAuthority.html) action to add one or more tags to your CA. Call the [UntagCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UntagCertificateAuthority.html) action to remove tags.
     */
    public suspend fun listTags(input: ListTagsRequest): ListTagsResponse

    /**
     * Attaches a resource-based policy to a private CA.
     *
     * A policy can also be applied by sharing a private CA through Amazon Web Services Resource Access Manager (RAM). For more information, see [Attach a Policy for Cross-Account Access](https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-ram.html).
     *
     * The policy can be displayed with [GetPolicy](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetPolicy.html) and removed with [DeletePolicy](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePolicy.html).
     *
     * **About Policies**
     * + A policy grants access on a private CA to an Amazon Web Services customer account, to Amazon Web Services Organizations, or to an Amazon Web Services Organizations unit. Policies are under the control of a CA administrator. For more information, see [Using a Resource Based Policy with ACM Private CA](https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html).
     * + A policy permits a user of Certificate Manager (ACM) to issue ACM certificates signed by a CA in another account.
     * + For ACM to manage automatic renewal of these certificates, the ACM user must configure a Service Linked Role (SLR). The SLR allows the ACM service to assume the identity of the user, subject to confirmation against the ACM Private CA policy. For more information, see [Using a Service Linked Role with ACM](https://docs.aws.amazon.com/acm/latest/userguide/acm-slr.html).
     * + Updates made in Amazon Web Services Resource Manager (RAM) are reflected in policies. For more information, see [Attach a Policy for Cross-Account Access](https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-ram.html).
     */
    public suspend fun putPolicy(input: PutPolicyRequest): PutPolicyResponse

    /**
     * Restores a certificate authority (CA) that is in the `DELETED` state. You can restore a CA during the period that you defined in the **PermanentDeletionTimeInDays** parameter of the [DeleteCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeleteCertificateAuthority.html) action. Currently, you can specify 7 to 30 days. If you did not specify a **PermanentDeletionTimeInDays** value, by default you can restore the CA at any time in a 30 day period. You can check the time remaining in the restoration period of a private CA in the `DELETED` state by calling the [DescribeCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DescribeCertificateAuthority.html) or [ListCertificateAuthorities](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html) actions. The status of a restored CA is set to its pre-deletion status when the **RestoreCertificateAuthority** action returns. To change its status to `ACTIVE`, call the [UpdateCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html) action. If the private CA was in the `PENDING_CERTIFICATE` state at deletion, you must use the [ImportCertificateAuthorityCertificate](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ImportCertificateAuthorityCertificate.html) action to import a certificate authority into the private CA before it can be activated. You cannot restore a CA after the restoration period has ended.
     */
    public suspend fun restoreCertificateAuthority(input: RestoreCertificateAuthorityRequest): RestoreCertificateAuthorityResponse

    /**
     * Revokes a certificate that was issued inside ACM Private CA. If you enable a certificate revocation list (CRL) when you create or update your private CA, information about the revoked certificates will be included in the CRL. ACM Private CA writes the CRL to an S3 bucket that you specify. A CRL is typically updated approximately 30 minutes after a certificate is revoked. If for any reason the CRL update fails, ACM Private CA attempts makes further attempts every 15 minutes. With Amazon CloudWatch, you can create alarms for the metrics `CRLGenerated` and `MisconfiguredCRLBucket`. For more information, see [Supported CloudWatch Metrics](https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCloudWatch.html).
     *
     * Both PCA and the IAM principal must have permission to write to the S3 bucket that you specify. If the IAM principal making the call does not have permission to write to the bucket, then an exception is thrown. For more information, see [Access policies for CRLs in Amazon S3](https://docs.aws.amazon.com/acm-pca/latest/userguide/crl-planning.html#s3-policies).
     *
     * ACM Private CA also writes revocation information to the audit report. For more information, see [CreateCertificateAuthorityAuditReport](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html).
     *
     * You cannot revoke a root CA self-signed certificate.
     */
    public suspend fun revokeCertificate(input: RevokeCertificateRequest): RevokeCertificateResponse

    /**
     * Adds one or more tags to your private CA. Tags are labels that you can use to identify and organize your Amazon Web Services resources. Each tag consists of a key and an optional value. You specify the private CA on input by its Amazon Resource Name (ARN). You specify the tag by using a key-value pair. You can apply a tag to just one private CA if you want to identify a specific characteristic of that CA, or you can apply the same tag to multiple private CAs if you want to filter for a common relationship among those CAs. To remove one or more tags, use the [UntagCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UntagCertificateAuthority.html) action. Call the [ListTags](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListTags.html) action to see what tags are associated with your CA.
     */
    public suspend fun tagCertificateAuthority(input: TagCertificateAuthorityRequest): TagCertificateAuthorityResponse

    /**
     * Remove one or more tags from your private CA. A tag consists of a key-value pair. If you do not specify the value portion of the tag when calling this action, the tag will be removed regardless of value. If you specify a value, the tag is removed only if it is associated with the specified value. To add tags to a private CA, use the [TagCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_TagCertificateAuthority.html). Call the [ListTags](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListTags.html) action to see what tags are associated with your CA.
     */
    public suspend fun untagCertificateAuthority(input: UntagCertificateAuthorityRequest): UntagCertificateAuthorityResponse

    /**
     * Updates the status or configuration of a private certificate authority (CA). Your private CA must be in the `ACTIVE` or `DISABLED` state before you can update it. You can disable a private CA that is in the `ACTIVE` state or make a CA that is in the `DISABLED` state active again.
     *
     * Both PCA and the IAM principal must have permission to write to the S3 bucket that you specify. If the IAM principal making the call does not have permission to write to the bucket, then an exception is thrown. For more information, see [Access policies for CRLs in Amazon S3](https://docs.aws.amazon.com/acm-pca/latest/userguide/crl-planning.html#s3-policies).
     */
    public suspend fun updateCertificateAuthority(input: UpdateCertificateAuthorityRequest): UpdateCertificateAuthorityResponse
}

/**
 * Creates a root or subordinate private certificate authority (CA). You must specify the CA configuration, an optional configuration for Online Certificate Status Protocol (OCSP) and/or a certificate revocation list (CRL), the CA type, and an optional idempotency token to avoid accidental creation of multiple CAs. The CA configuration specifies the name of the algorithm and key size to be used to create the CA private key, the type of signing algorithm that the CA uses, and X.500 subject information. The OCSP configuration can optionally specify a custom URL for the OCSP responder. The CRL configuration specifies the CRL expiration period in days (the validity period of the CRL), the Amazon S3 bucket that will contain the CRL, and a CNAME alias for the S3 bucket that is included in certificates issued by the CA. If successful, this action returns the Amazon Resource Name (ARN) of the CA.
 *
 * ACM Private CA assets that are stored in Amazon S3 can be protected with encryption. For more information, see [Encrypting Your CRLs](https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCreateCa.html#crl-encryption).
 *
 * Both PCA and the IAM principal must have permission to write to the S3 bucket that you specify. If the IAM principal making the call does not have permission to write to the bucket, then an exception is thrown. For more information, see [Access policies for CRLs in Amazon S3](https://docs.aws.amazon.com/acm-pca/latest/userguide/crl-planning.html#s3-policies).
 */
public suspend inline fun AcmPcaClient.createCertificateAuthority(crossinline block: CreateCertificateAuthorityRequest.Builder.() -> Unit): CreateCertificateAuthorityResponse = createCertificateAuthority(CreateCertificateAuthorityRequest.Builder().apply(block).build())

/**
 * Creates an audit report that lists every time that your CA private key is used. The report is saved in the Amazon S3 bucket that you specify on input. The [IssueCertificate](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_IssueCertificate.html) and [RevokeCertificate](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_RevokeCertificate.html) actions use the private key.
 *
 * Both PCA and the IAM principal must have permission to write to the S3 bucket that you specify. If the IAM principal making the call does not have permission to write to the bucket, then an exception is thrown. For more information, see [Access policies for CRLs in Amazon S3](https://docs.aws.amazon.com/acm-pca/latest/userguide/crl-planning.html#s3-policies).
 *
 * ACM Private CA assets that are stored in Amazon S3 can be protected with encryption. For more information, see [Encrypting Your Audit Reports](https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaAuditReport.html#audit-report-encryption).
 *
 * You can generate a maximum of one report every 30 minutes.
 */
public suspend inline fun AcmPcaClient.createCertificateAuthorityAuditReport(crossinline block: CreateCertificateAuthorityAuditReportRequest.Builder.() -> Unit): CreateCertificateAuthorityAuditReportResponse = createCertificateAuthorityAuditReport(CreateCertificateAuthorityAuditReportRequest.Builder().apply(block).build())

/**
 * Grants one or more permissions on a private CA to the Certificate Manager (ACM) service principal (`acm.amazonaws.com`). These permissions allow ACM to issue and renew ACM certificates that reside in the same Amazon Web Services account as the CA.
 *
 * You can list current permissions with the [ListPermissions](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListPermissions.html) action and revoke them with the [DeletePermission](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePermission.html) action.
 *
 * **About Permissions**
 * + If the private CA and the certificates it issues reside in the same account, you can use `CreatePermission` to grant permissions for ACM to carry out automatic certificate renewals.
 * + For automatic certificate renewal to succeed, the ACM service principal needs permissions to create, retrieve, and list certificates.
 * + If the private CA and the ACM certificates reside in different accounts, then permissions cannot be used to enable automatic renewals. Instead, the ACM certificate owner must set up a resource-based policy to enable cross-account issuance and renewals. For more information, see [Using a Resource Based Policy with ACM Private CA](https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html).
 */
public suspend inline fun AcmPcaClient.createPermission(crossinline block: CreatePermissionRequest.Builder.() -> Unit): CreatePermissionResponse = createPermission(CreatePermissionRequest.Builder().apply(block).build())

/**
 * Deletes a private certificate authority (CA). You must provide the Amazon Resource Name (ARN) of the private CA that you want to delete. You can find the ARN by calling the [ListCertificateAuthorities](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html) action.
 *
 * Deleting a CA will invalidate other CAs and certificates below it in your CA hierarchy.
 *
 * Before you can delete a CA that you have created and activated, you must disable it. To do this, call the [UpdateCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html) action and set the **CertificateAuthorityStatus** parameter to `DISABLED`.
 *
 * Additionally, you can delete a CA if you are waiting for it to be created (that is, the status of the CA is `CREATING`). You can also delete it if the CA has been created but you haven't yet imported the signed certificate into ACM Private CA (that is, the status of the CA is `PENDING_CERTIFICATE`).
 *
 * When you successfully call [DeleteCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeleteCertificateAuthority.html), the CA's status changes to `DELETED`. However, the CA won't be permanently deleted until the restoration period has passed. By default, if you do not set the `PermanentDeletionTimeInDays` parameter, the CA remains restorable for 30 days. You can set the parameter from 7 to 30 days. The [DescribeCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DescribeCertificateAuthority.html) action returns the time remaining in the restoration window of a private CA in the `DELETED` state. To restore an eligible CA, call the [RestoreCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_RestoreCertificateAuthority.html) action.
 */
public suspend inline fun AcmPcaClient.deleteCertificateAuthority(crossinline block: DeleteCertificateAuthorityRequest.Builder.() -> Unit): DeleteCertificateAuthorityResponse = deleteCertificateAuthority(DeleteCertificateAuthorityRequest.Builder().apply(block).build())

/**
 * Revokes permissions on a private CA granted to the Certificate Manager (ACM) service principal (acm.amazonaws.com).
 *
 * These permissions allow ACM to issue and renew ACM certificates that reside in the same Amazon Web Services account as the CA. If you revoke these permissions, ACM will no longer renew the affected certificates automatically.
 *
 * Permissions can be granted with the [CreatePermission](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreatePermission.html) action and listed with the [ListPermissions](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListPermissions.html) action.
 *
 * **About Permissions**
 * + If the private CA and the certificates it issues reside in the same account, you can use `CreatePermission` to grant permissions for ACM to carry out automatic certificate renewals.
 * + For automatic certificate renewal to succeed, the ACM service principal needs permissions to create, retrieve, and list certificates.
 * + If the private CA and the ACM certificates reside in different accounts, then permissions cannot be used to enable automatic renewals. Instead, the ACM certificate owner must set up a resource-based policy to enable cross-account issuance and renewals. For more information, see [Using a Resource Based Policy with ACM Private CA](https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html).
 */
public suspend inline fun AcmPcaClient.deletePermission(crossinline block: DeletePermissionRequest.Builder.() -> Unit): DeletePermissionResponse = deletePermission(DeletePermissionRequest.Builder().apply(block).build())

/**
 * Deletes the resource-based policy attached to a private CA. Deletion will remove any access that the policy has granted. If there is no policy attached to the private CA, this action will return successful.
 *
 * If you delete a policy that was applied through Amazon Web Services Resource Access Manager (RAM), the CA will be removed from all shares in which it was included.
 *
 * The Certificate Manager Service Linked Role that the policy supports is not affected when you delete the policy.
 *
 * The current policy can be shown with [GetPolicy](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetPolicy.html) and updated with [PutPolicy](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_PutPolicy.html).
 *
 * **About Policies**
 * + A policy grants access on a private CA to an Amazon Web Services customer account, to Amazon Web Services Organizations, or to an Amazon Web Services Organizations unit. Policies are under the control of a CA administrator. For more information, see [Using a Resource Based Policy with ACM Private CA](https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html).
 * + A policy permits a user of Certificate Manager (ACM) to issue ACM certificates signed by a CA in another account.
 * + For ACM to manage automatic renewal of these certificates, the ACM user must configure a Service Linked Role (SLR). The SLR allows the ACM service to assume the identity of the user, subject to confirmation against the ACM Private CA policy. For more information, see [Using a Service Linked Role with ACM](https://docs.aws.amazon.com/acm/latest/userguide/acm-slr.html).
 * + Updates made in Amazon Web Services Resource Manager (RAM) are reflected in policies. For more information, see [Attach a Policy for Cross-Account Access](https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-ram.html).
 */
public suspend inline fun AcmPcaClient.deletePolicy(crossinline block: DeletePolicyRequest.Builder.() -> Unit): DeletePolicyResponse = deletePolicy(DeletePolicyRequest.Builder().apply(block).build())

/**
 * Lists information about your private certificate authority (CA) or one that has been shared with you. You specify the private CA on input by its ARN (Amazon Resource Name). The output contains the status of your CA. This can be any of the following:
 * + `CREATING` - ACM Private CA is creating your private certificate authority.
 * + `PENDING_CERTIFICATE` - The certificate is pending. You must use your ACM Private CA-hosted or on-premises root or subordinate CA to sign your private CA CSR and then import it into PCA.
 * + `ACTIVE` - Your private CA is active.
 * + `DISABLED` - Your private CA has been disabled.
 * + `EXPIRED` - Your private CA certificate has expired.
 * + `FAILED` - Your private CA has failed. Your CA can fail because of problems such a network outage or back-end Amazon Web Services failure or other errors. A failed CA can never return to the pending state. You must create a new CA.
 * + `DELETED` - Your private CA is within the restoration period, after which it is permanently deleted. The length of time remaining in the CA's restoration period is also included in this action's output.
 */
public suspend inline fun AcmPcaClient.describeCertificateAuthority(crossinline block: DescribeCertificateAuthorityRequest.Builder.() -> Unit): DescribeCertificateAuthorityResponse = describeCertificateAuthority(DescribeCertificateAuthorityRequest.Builder().apply(block).build())

/**
 * Lists information about a specific audit report created by calling the [CreateCertificateAuthorityAuditReport](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html) action. Audit information is created every time the certificate authority (CA) private key is used. The private key is used when you call the [IssueCertificate](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_IssueCertificate.html) action or the [RevokeCertificate](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_RevokeCertificate.html) action.
 */
public suspend inline fun AcmPcaClient.describeCertificateAuthorityAuditReport(crossinline block: DescribeCertificateAuthorityAuditReportRequest.Builder.() -> Unit): DescribeCertificateAuthorityAuditReportResponse = describeCertificateAuthorityAuditReport(DescribeCertificateAuthorityAuditReportRequest.Builder().apply(block).build())

/**
 * Retrieves a certificate from your private CA or one that has been shared with you. The ARN of the certificate is returned when you call the [IssueCertificate](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_IssueCertificate.html) action. You must specify both the ARN of your private CA and the ARN of the issued certificate when calling the **GetCertificate** action. You can retrieve the certificate if it is in the **ISSUED** state. You can call the [CreateCertificateAuthorityAuditReport](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html) action to create a report that contains information about all of the certificates issued and revoked by your private CA.
 */
public suspend inline fun AcmPcaClient.getCertificate(crossinline block: GetCertificateRequest.Builder.() -> Unit): GetCertificateResponse = getCertificate(GetCertificateRequest.Builder().apply(block).build())

/**
 * Retrieves the certificate and certificate chain for your private certificate authority (CA) or one that has been shared with you. Both the certificate and the chain are base64 PEM-encoded. The chain does not include the CA certificate. Each certificate in the chain signs the one before it.
 */
public suspend inline fun AcmPcaClient.getCertificateAuthorityCertificate(crossinline block: GetCertificateAuthorityCertificateRequest.Builder.() -> Unit): GetCertificateAuthorityCertificateResponse = getCertificateAuthorityCertificate(GetCertificateAuthorityCertificateRequest.Builder().apply(block).build())

/**
 * Retrieves the certificate signing request (CSR) for your private certificate authority (CA). The CSR is created when you call the [CreateCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html) action. Sign the CSR with your ACM Private CA-hosted or on-premises root or subordinate CA. Then import the signed certificate back into ACM Private CA by calling the [ImportCertificateAuthorityCertificate](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ImportCertificateAuthorityCertificate.html) action. The CSR is returned as a base64 PEM-encoded string.
 */
public suspend inline fun AcmPcaClient.getCertificateAuthorityCsr(crossinline block: GetCertificateAuthorityCsrRequest.Builder.() -> Unit): GetCertificateAuthorityCsrResponse = getCertificateAuthorityCsr(GetCertificateAuthorityCsrRequest.Builder().apply(block).build())

/**
 * Retrieves the resource-based policy attached to a private CA. If either the private CA resource or the policy cannot be found, this action returns a `ResourceNotFoundException`.
 *
 * The policy can be attached or updated with [PutPolicy](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_PutPolicy.html) and removed with [DeletePolicy](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePolicy.html).
 *
 * **About Policies**
 * + A policy grants access on a private CA to an Amazon Web Services customer account, to Amazon Web Services Organizations, or to an Amazon Web Services Organizations unit. Policies are under the control of a CA administrator. For more information, see [Using a Resource Based Policy with ACM Private CA](https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html).
 * + A policy permits a user of Certificate Manager (ACM) to issue ACM certificates signed by a CA in another account.
 * + For ACM to manage automatic renewal of these certificates, the ACM user must configure a Service Linked Role (SLR). The SLR allows the ACM service to assume the identity of the user, subject to confirmation against the ACM Private CA policy. For more information, see [Using a Service Linked Role with ACM](https://docs.aws.amazon.com/acm/latest/userguide/acm-slr.html).
 * + Updates made in Amazon Web Services Resource Manager (RAM) are reflected in policies. For more information, see [Attach a Policy for Cross-Account Access](https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-ram.html).
 */
public suspend inline fun AcmPcaClient.getPolicy(crossinline block: GetPolicyRequest.Builder.() -> Unit): GetPolicyResponse = getPolicy(GetPolicyRequest.Builder().apply(block).build())

/**
 * Imports a signed private CA certificate into ACM Private CA. This action is used when you are using a chain of trust whose root is located outside ACM Private CA. Before you can call this action, the following preparations must in place:
 * + In ACM Private CA, call the [CreateCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html) action to create the private CA that you plan to back with the imported certificate.
 * + Call the [GetCertificateAuthorityCsr](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificateAuthorityCsr.html) action to generate a certificate signing request (CSR).
 * + Sign the CSR using a root or intermediate CA hosted by either an on-premises PKI hierarchy or by a commercial CA.
 * + Create a certificate chain and copy the signed certificate and the certificate chain to your working directory.
 *
 * ACM Private CA supports three scenarios for installing a CA certificate:
 * + Installing a certificate for a root CA hosted by ACM Private CA.
 * + Installing a subordinate CA certificate whose parent authority is hosted by ACM Private CA.
 * + Installing a subordinate CA certificate whose parent authority is externally hosted.
 *
 * The following additional requirements apply when you import a CA certificate.
 * + Only a self-signed certificate can be imported as a root CA.
 * + A self-signed certificate cannot be imported as a subordinate CA.
 * + Your certificate chain must not include the private CA certificate that you are importing.
 * + Your root CA must be the last certificate in your chain. The subordinate certificate, if any, that your root CA signed must be next to last. The subordinate certificate signed by the preceding subordinate CA must come next, and so on until your chain is built.
 * + The chain must be PEM-encoded.
 * + The maximum allowed size of a certificate is 32 KB.
 * + The maximum allowed size of a certificate chain is 2 MB.
 *
 * *Enforcement of Critical Constraints*
 *
 * ACM Private CA allows the following extensions to be marked critical in the imported CA certificate or chain.
 * + Basic constraints (*must* be marked critical)
 * + Subject alternative names
 * + Key usage
 * + Extended key usage
 * + Authority key identifier
 * + Subject key identifier
 * + Issuer alternative name
 * + Subject directory attributes
 * + Subject information access
 * + Certificate policies
 * + Policy mappings
 * + Inhibit anyPolicy
 *
 * ACM Private CA rejects the following extensions when they are marked critical in an imported CA certificate or chain.
 * + Name constraints
 * + Policy constraints
 * + CRL distribution points
 * + Authority information access
 * + Freshest CRL
 * + Any other extension
 */
public suspend inline fun AcmPcaClient.importCertificateAuthorityCertificate(crossinline block: ImportCertificateAuthorityCertificateRequest.Builder.() -> Unit): ImportCertificateAuthorityCertificateResponse = importCertificateAuthorityCertificate(ImportCertificateAuthorityCertificateRequest.Builder().apply(block).build())

/**
 * Uses your private certificate authority (CA), or one that has been shared with you, to issue a client certificate. This action returns the Amazon Resource Name (ARN) of the certificate. You can retrieve the certificate by calling the [GetCertificate](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificate.html) action and specifying the ARN.
 *
 * You cannot use the ACM **ListCertificateAuthorities** action to retrieve the ARNs of the certificates that you issue by using ACM Private CA.
 */
public suspend inline fun AcmPcaClient.issueCertificate(crossinline block: IssueCertificateRequest.Builder.() -> Unit): IssueCertificateResponse = issueCertificate(IssueCertificateRequest.Builder().apply(block).build())

/**
 * Lists the private certificate authorities that you created by using the [CreateCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html) action.
 */
public suspend inline fun AcmPcaClient.listCertificateAuthorities(crossinline block: ListCertificateAuthoritiesRequest.Builder.() -> Unit): ListCertificateAuthoritiesResponse = listCertificateAuthorities(ListCertificateAuthoritiesRequest.Builder().apply(block).build())

/**
 * List all permissions on a private CA, if any, granted to the Certificate Manager (ACM) service principal (acm.amazonaws.com).
 *
 * These permissions allow ACM to issue and renew ACM certificates that reside in the same Amazon Web Services account as the CA.
 *
 * Permissions can be granted with the [CreatePermission](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreatePermission.html) action and revoked with the [DeletePermission](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePermission.html) action.
 *
 * **About Permissions**
 * + If the private CA and the certificates it issues reside in the same account, you can use `CreatePermission` to grant permissions for ACM to carry out automatic certificate renewals.
 * + For automatic certificate renewal to succeed, the ACM service principal needs permissions to create, retrieve, and list certificates.
 * + If the private CA and the ACM certificates reside in different accounts, then permissions cannot be used to enable automatic renewals. Instead, the ACM certificate owner must set up a resource-based policy to enable cross-account issuance and renewals. For more information, see [Using a Resource Based Policy with ACM Private CA](https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html).
 */
public suspend inline fun AcmPcaClient.listPermissions(crossinline block: ListPermissionsRequest.Builder.() -> Unit): ListPermissionsResponse = listPermissions(ListPermissionsRequest.Builder().apply(block).build())

/**
 * Lists the tags, if any, that are associated with your private CA or one that has been shared with you. Tags are labels that you can use to identify and organize your CAs. Each tag consists of a key and an optional value. Call the [TagCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_TagCertificateAuthority.html) action to add one or more tags to your CA. Call the [UntagCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UntagCertificateAuthority.html) action to remove tags.
 */
public suspend inline fun AcmPcaClient.listTags(crossinline block: ListTagsRequest.Builder.() -> Unit): ListTagsResponse = listTags(ListTagsRequest.Builder().apply(block).build())

/**
 * Attaches a resource-based policy to a private CA.
 *
 * A policy can also be applied by sharing a private CA through Amazon Web Services Resource Access Manager (RAM). For more information, see [Attach a Policy for Cross-Account Access](https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-ram.html).
 *
 * The policy can be displayed with [GetPolicy](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetPolicy.html) and removed with [DeletePolicy](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePolicy.html).
 *
 * **About Policies**
 * + A policy grants access on a private CA to an Amazon Web Services customer account, to Amazon Web Services Organizations, or to an Amazon Web Services Organizations unit. Policies are under the control of a CA administrator. For more information, see [Using a Resource Based Policy with ACM Private CA](https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html).
 * + A policy permits a user of Certificate Manager (ACM) to issue ACM certificates signed by a CA in another account.
 * + For ACM to manage automatic renewal of these certificates, the ACM user must configure a Service Linked Role (SLR). The SLR allows the ACM service to assume the identity of the user, subject to confirmation against the ACM Private CA policy. For more information, see [Using a Service Linked Role with ACM](https://docs.aws.amazon.com/acm/latest/userguide/acm-slr.html).
 * + Updates made in Amazon Web Services Resource Manager (RAM) are reflected in policies. For more information, see [Attach a Policy for Cross-Account Access](https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-ram.html).
 */
public suspend inline fun AcmPcaClient.putPolicy(crossinline block: PutPolicyRequest.Builder.() -> Unit): PutPolicyResponse = putPolicy(PutPolicyRequest.Builder().apply(block).build())

/**
 * Restores a certificate authority (CA) that is in the `DELETED` state. You can restore a CA during the period that you defined in the **PermanentDeletionTimeInDays** parameter of the [DeleteCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeleteCertificateAuthority.html) action. Currently, you can specify 7 to 30 days. If you did not specify a **PermanentDeletionTimeInDays** value, by default you can restore the CA at any time in a 30 day period. You can check the time remaining in the restoration period of a private CA in the `DELETED` state by calling the [DescribeCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DescribeCertificateAuthority.html) or [ListCertificateAuthorities](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html) actions. The status of a restored CA is set to its pre-deletion status when the **RestoreCertificateAuthority** action returns. To change its status to `ACTIVE`, call the [UpdateCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html) action. If the private CA was in the `PENDING_CERTIFICATE` state at deletion, you must use the [ImportCertificateAuthorityCertificate](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ImportCertificateAuthorityCertificate.html) action to import a certificate authority into the private CA before it can be activated. You cannot restore a CA after the restoration period has ended.
 */
public suspend inline fun AcmPcaClient.restoreCertificateAuthority(crossinline block: RestoreCertificateAuthorityRequest.Builder.() -> Unit): RestoreCertificateAuthorityResponse = restoreCertificateAuthority(RestoreCertificateAuthorityRequest.Builder().apply(block).build())

/**
 * Revokes a certificate that was issued inside ACM Private CA. If you enable a certificate revocation list (CRL) when you create or update your private CA, information about the revoked certificates will be included in the CRL. ACM Private CA writes the CRL to an S3 bucket that you specify. A CRL is typically updated approximately 30 minutes after a certificate is revoked. If for any reason the CRL update fails, ACM Private CA attempts makes further attempts every 15 minutes. With Amazon CloudWatch, you can create alarms for the metrics `CRLGenerated` and `MisconfiguredCRLBucket`. For more information, see [Supported CloudWatch Metrics](https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCloudWatch.html).
 *
 * Both PCA and the IAM principal must have permission to write to the S3 bucket that you specify. If the IAM principal making the call does not have permission to write to the bucket, then an exception is thrown. For more information, see [Access policies for CRLs in Amazon S3](https://docs.aws.amazon.com/acm-pca/latest/userguide/crl-planning.html#s3-policies).
 *
 * ACM Private CA also writes revocation information to the audit report. For more information, see [CreateCertificateAuthorityAuditReport](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html).
 *
 * You cannot revoke a root CA self-signed certificate.
 */
public suspend inline fun AcmPcaClient.revokeCertificate(crossinline block: RevokeCertificateRequest.Builder.() -> Unit): RevokeCertificateResponse = revokeCertificate(RevokeCertificateRequest.Builder().apply(block).build())

/**
 * Adds one or more tags to your private CA. Tags are labels that you can use to identify and organize your Amazon Web Services resources. Each tag consists of a key and an optional value. You specify the private CA on input by its Amazon Resource Name (ARN). You specify the tag by using a key-value pair. You can apply a tag to just one private CA if you want to identify a specific characteristic of that CA, or you can apply the same tag to multiple private CAs if you want to filter for a common relationship among those CAs. To remove one or more tags, use the [UntagCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UntagCertificateAuthority.html) action. Call the [ListTags](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListTags.html) action to see what tags are associated with your CA.
 */
public suspend inline fun AcmPcaClient.tagCertificateAuthority(crossinline block: TagCertificateAuthorityRequest.Builder.() -> Unit): TagCertificateAuthorityResponse = tagCertificateAuthority(TagCertificateAuthorityRequest.Builder().apply(block).build())

/**
 * Remove one or more tags from your private CA. A tag consists of a key-value pair. If you do not specify the value portion of the tag when calling this action, the tag will be removed regardless of value. If you specify a value, the tag is removed only if it is associated with the specified value. To add tags to a private CA, use the [TagCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_TagCertificateAuthority.html). Call the [ListTags](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListTags.html) action to see what tags are associated with your CA.
 */
public suspend inline fun AcmPcaClient.untagCertificateAuthority(crossinline block: UntagCertificateAuthorityRequest.Builder.() -> Unit): UntagCertificateAuthorityResponse = untagCertificateAuthority(UntagCertificateAuthorityRequest.Builder().apply(block).build())

/**
 * Updates the status or configuration of a private certificate authority (CA). Your private CA must be in the `ACTIVE` or `DISABLED` state before you can update it. You can disable a private CA that is in the `ACTIVE` state or make a CA that is in the `DISABLED` state active again.
 *
 * Both PCA and the IAM principal must have permission to write to the S3 bucket that you specify. If the IAM principal making the call does not have permission to write to the bucket, then an exception is thrown. For more information, see [Access policies for CRLs in Amazon S3](https://docs.aws.amazon.com/acm-pca/latest/userguide/crl-planning.html#s3-policies).
 */
public suspend inline fun AcmPcaClient.updateCertificateAuthority(crossinline block: UpdateCertificateAuthorityRequest.Builder.() -> Unit): UpdateCertificateAuthorityResponse = updateCertificateAuthority(UpdateCertificateAuthorityRequest.Builder().apply(block).build())
