// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.serde

import aws.sdk.kotlin.services.acmpca.model.AcmPcaException
import aws.sdk.kotlin.services.acmpca.model.UntagCertificateAuthorityResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class UntagCertificateAuthorityOperationDeserializer: HttpDeserialize<UntagCertificateAuthorityResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UntagCertificateAuthorityResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUntagCertificateAuthorityError(context, call)
        }
        val builder = UntagCertificateAuthorityResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUntagCertificateAuthorityError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AcmPcaException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidStateException" -> InvalidStateExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidArnException" -> InvalidArnExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidTagException" -> InvalidTagExceptionDeserializer().deserialize(context, wrappedCall)
        else -> AcmPcaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
