// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.serde

import aws.sdk.kotlin.services.acmpca.model.ApiPassthrough
import aws.sdk.kotlin.services.acmpca.model.IssueCertificateRequest
import aws.sdk.kotlin.services.acmpca.model.SigningAlgorithm
import aws.sdk.kotlin.services.acmpca.model.Validity
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.encodeBase64String


internal class IssueCertificateOperationSerializer: HttpSerialize<IssueCertificateRequest> {
    override suspend fun serialize(context: ExecutionContext, input: IssueCertificateRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeIssueCertificateOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeIssueCertificateOperationBody(context: ExecutionContext, input: IssueCertificateRequest): ByteArray {
    val serializer = JsonSerializer()
    val APIPASSTHROUGH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ApiPassthrough"))
    val CERTIFICATEAUTHORITYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CertificateAuthorityArn"))
    val CSR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Blob, JsonSerialName("Csr"))
    val IDEMPOTENCYTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IdempotencyToken"))
    val SIGNINGALGORITHM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("SigningAlgorithm"))
    val TEMPLATEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TemplateArn"))
    val VALIDITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Validity"))
    val VALIDITYNOTBEFORE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ValidityNotBefore"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APIPASSTHROUGH_DESCRIPTOR)
        field(CERTIFICATEAUTHORITYARN_DESCRIPTOR)
        field(CSR_DESCRIPTOR)
        field(IDEMPOTENCYTOKEN_DESCRIPTOR)
        field(SIGNINGALGORITHM_DESCRIPTOR)
        field(TEMPLATEARN_DESCRIPTOR)
        field(VALIDITY_DESCRIPTOR)
        field(VALIDITYNOTBEFORE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.apiPassthrough?.let { field(APIPASSTHROUGH_DESCRIPTOR, it, ::serializeApiPassthroughDocument) }
        input.certificateAuthorityArn?.let { field(CERTIFICATEAUTHORITYARN_DESCRIPTOR, it) }
        input.csr?.let { field(CSR_DESCRIPTOR, it.encodeBase64String()) }
        input.idempotencyToken?.let { field(IDEMPOTENCYTOKEN_DESCRIPTOR, it) }
        input.signingAlgorithm?.let { field(SIGNINGALGORITHM_DESCRIPTOR, it.value) }
        input.templateArn?.let { field(TEMPLATEARN_DESCRIPTOR, it) }
        input.validity?.let { field(VALIDITY_DESCRIPTOR, it, ::serializeValidityDocument) }
        input.validityNotBefore?.let { field(VALIDITYNOTBEFORE_DESCRIPTOR, it, ::serializeValidityDocument) }
    }
    return serializer.toByteArray()
}
