// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.paginators

import aws.sdk.kotlin.services.acmpca.AcmPcaClient
import aws.sdk.kotlin.services.acmpca.model.CertificateAuthority
import aws.sdk.kotlin.services.acmpca.model.ListCertificateAuthoritiesRequest
import aws.sdk.kotlin.services.acmpca.model.ListCertificateAuthoritiesResponse
import aws.sdk.kotlin.services.acmpca.model.ListPermissionsRequest
import aws.sdk.kotlin.services.acmpca.model.ListPermissionsResponse
import aws.sdk.kotlin.services.acmpca.model.ListTagsRequest
import aws.sdk.kotlin.services.acmpca.model.ListTagsResponse
import aws.sdk.kotlin.services.acmpca.model.Permission
import aws.sdk.kotlin.services.acmpca.model.Tag
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListCertificateAuthoritiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCertificateAuthoritiesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCertificateAuthoritiesResponse]
 */
public fun AcmPcaClient.listCertificateAuthoritiesPaginated(initialRequest: ListCertificateAuthoritiesRequest = ListCertificateAuthoritiesRequest { }): Flow<ListCertificateAuthoritiesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCertificateAuthoritiesPaginated.listCertificateAuthorities(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCertificateAuthoritiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCertificateAuthoritiesResponse]
 */
public fun AcmPcaClient.listCertificateAuthoritiesPaginated(block: ListCertificateAuthoritiesRequest.Builder.() -> Unit): Flow<ListCertificateAuthoritiesResponse> =
    listCertificateAuthoritiesPaginated(ListCertificateAuthoritiesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCertificateAuthoritiesPaginated]
 * to access the nested member [CertificateAuthority]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CertificateAuthority]
 */
@JvmName("listCertificateAuthoritiesResponseCertificateAuthority")
public fun Flow<ListCertificateAuthoritiesResponse>.certificateAuthorities(): Flow<CertificateAuthority> =
    transform() { response ->
        response.certificateAuthorities?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPermissionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPermissionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPermissionsResponse]
 */
public fun AcmPcaClient.listPermissionsPaginated(initialRequest: ListPermissionsRequest): Flow<ListPermissionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPermissionsPaginated.listPermissions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPermissionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPermissionsResponse]
 */
public fun AcmPcaClient.listPermissionsPaginated(block: ListPermissionsRequest.Builder.() -> Unit): Flow<ListPermissionsResponse> =
    listPermissionsPaginated(ListPermissionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPermissionsPaginated]
 * to access the nested member [Permission]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Permission]
 */
@JvmName("listPermissionsResponsePermission")
public fun Flow<ListPermissionsResponse>.permissions(): Flow<Permission> =
    transform() { response ->
        response.permissions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTagsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsResponse]
 */
public fun AcmPcaClient.listTagsPaginated(initialRequest: ListTagsRequest): Flow<ListTagsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTagsPaginated.listTags(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsResponse]
 */
public fun AcmPcaClient.listTagsPaginated(block: ListTagsRequest.Builder.() -> Unit): Flow<ListTagsResponse> =
    listTagsPaginated(ListTagsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTagsPaginated]
 * to access the nested member [Tag]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Tag]
 */
@JvmName("listTagsResponseTag")
public fun Flow<ListTagsResponse>.tags(): Flow<Tag> =
    transform() { response ->
        response.tags?.forEach {
            emit(it)
        }
    }
