// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



public class UpdateCertificateAuthorityRequest private constructor(builder: Builder) {
    /**
     * Amazon Resource Name (ARN) of the private CA that issued the certificate to be revoked. This must be of the form:
     *
     * `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `
     */
    public val certificateAuthorityArn: kotlin.String? = builder.certificateAuthorityArn
    /**
     * Contains information to enable Online Certificate Status Protocol (OCSP) support, to enable a certificate revocation list (CRL), to enable both, or to enable neither. If this parameter is not supplied, existing capibilites remain unchanged. For more information, see the [OcspConfiguration](https://docs.aws.amazon.com/privateca/latest/APIReference/API_OcspConfiguration.html) and [CrlConfiguration](https://docs.aws.amazon.com/privateca/latest/APIReference/API_CrlConfiguration.html) types.
     *
     * The following requirements apply to revocation configurations.
     * + A configuration disabling CRLs or OCSP must contain only the `Enabled=False` parameter, and will fail if other parameters such as `CustomCname` or `ExpirationInDays` are included.
     * + In a CRL configuration, the `S3BucketName` parameter must conform to [Amazon S3 bucket naming rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html).
     * + A configuration containing a custom Canonical Name (CNAME) parameter for CRLs or OCSP must conform to [RFC2396](https://www.ietf.org/rfc/rfc2396.txt) restrictions on the use of special characters in a CNAME.
     * + In a CRL or OCSP configuration, the value of a CNAME parameter must not include a protocol prefix such as "http://" or "https://".
     */
    public val revocationConfiguration: aws.sdk.kotlin.services.acmpca.model.RevocationConfiguration? = builder.revocationConfiguration
    /**
     * Status of your private CA.
     */
    public val status: aws.sdk.kotlin.services.acmpca.model.CertificateAuthorityStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acmpca.model.UpdateCertificateAuthorityRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateCertificateAuthorityRequest(")
        append("certificateAuthorityArn=$certificateAuthorityArn,")
        append("revocationConfiguration=$revocationConfiguration,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateAuthorityArn?.hashCode() ?: 0
        result = 31 * result + (revocationConfiguration?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateCertificateAuthorityRequest

        if (certificateAuthorityArn != other.certificateAuthorityArn) return false
        if (revocationConfiguration != other.revocationConfiguration) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acmpca.model.UpdateCertificateAuthorityRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Amazon Resource Name (ARN) of the private CA that issued the certificate to be revoked. This must be of the form:
         *
         * `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `
         */
        public var certificateAuthorityArn: kotlin.String? = null
        /**
         * Contains information to enable Online Certificate Status Protocol (OCSP) support, to enable a certificate revocation list (CRL), to enable both, or to enable neither. If this parameter is not supplied, existing capibilites remain unchanged. For more information, see the [OcspConfiguration](https://docs.aws.amazon.com/privateca/latest/APIReference/API_OcspConfiguration.html) and [CrlConfiguration](https://docs.aws.amazon.com/privateca/latest/APIReference/API_CrlConfiguration.html) types.
         *
         * The following requirements apply to revocation configurations.
         * + A configuration disabling CRLs or OCSP must contain only the `Enabled=False` parameter, and will fail if other parameters such as `CustomCname` or `ExpirationInDays` are included.
         * + In a CRL configuration, the `S3BucketName` parameter must conform to [Amazon S3 bucket naming rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html).
         * + A configuration containing a custom Canonical Name (CNAME) parameter for CRLs or OCSP must conform to [RFC2396](https://www.ietf.org/rfc/rfc2396.txt) restrictions on the use of special characters in a CNAME.
         * + In a CRL or OCSP configuration, the value of a CNAME parameter must not include a protocol prefix such as "http://" or "https://".
         */
        public var revocationConfiguration: aws.sdk.kotlin.services.acmpca.model.RevocationConfiguration? = null
        /**
         * Status of your private CA.
         */
        public var status: aws.sdk.kotlin.services.acmpca.model.CertificateAuthorityStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acmpca.model.UpdateCertificateAuthorityRequest) : this() {
            this.certificateAuthorityArn = x.certificateAuthorityArn
            this.revocationConfiguration = x.revocationConfiguration
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acmpca.model.UpdateCertificateAuthorityRequest = UpdateCertificateAuthorityRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.RevocationConfiguration] inside the given [block]
         */
        public fun revocationConfiguration(block: aws.sdk.kotlin.services.acmpca.model.RevocationConfiguration.Builder.() -> kotlin.Unit) {
            this.revocationConfiguration = aws.sdk.kotlin.services.acmpca.model.RevocationConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
