// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Permissions designate which private CA actions can be performed by an Amazon Web Services service or entity. In order for ACM to automatically renew private certificates, you must give the ACM service principal all available permissions (`IssueCertificate`, `GetCertificate`, and `ListPermissions`). Permissions can be assigned with the [CreatePermission](https://docs.aws.amazon.com/privateca/latest/APIReference/API_CreatePermission.html) action, removed with the [DeletePermission](https://docs.aws.amazon.com/privateca/latest/APIReference/API_DeletePermission.html) action, and listed with the [ListPermissions](https://docs.aws.amazon.com/privateca/latest/APIReference/API_ListPermissions.html) action.
 */
public class Permission private constructor(builder: Builder) {
    /**
     * The private CA actions that can be performed by the designated Amazon Web Services service.
     */
    public val actions: List<ActionType>? = builder.actions
    /**
     * The Amazon Resource Number (ARN) of the private CA from which the permission was issued.
     */
    public val certificateAuthorityArn: kotlin.String? = builder.certificateAuthorityArn
    /**
     * The time at which the permission was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The name of the policy that is associated with the permission.
     */
    public val policy: kotlin.String? = builder.policy
    /**
     * The Amazon Web Services service or entity that holds the permission. At this time, the only valid principal is `acm.amazonaws.com`.
     */
    public val principal: kotlin.String? = builder.principal
    /**
     * The ID of the account that assigned the permission.
     */
    public val sourceAccount: kotlin.String? = builder.sourceAccount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acmpca.model.Permission = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Permission(")
        append("actions=$actions,")
        append("certificateAuthorityArn=$certificateAuthorityArn,")
        append("createdAt=$createdAt,")
        append("policy=$policy,")
        append("principal=$principal,")
        append("sourceAccount=$sourceAccount")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (certificateAuthorityArn?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (policy?.hashCode() ?: 0)
        result = 31 * result + (principal?.hashCode() ?: 0)
        result = 31 * result + (sourceAccount?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Permission

        if (actions != other.actions) return false
        if (certificateAuthorityArn != other.certificateAuthorityArn) return false
        if (createdAt != other.createdAt) return false
        if (policy != other.policy) return false
        if (principal != other.principal) return false
        if (sourceAccount != other.sourceAccount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acmpca.model.Permission = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The private CA actions that can be performed by the designated Amazon Web Services service.
         */
        public var actions: List<ActionType>? = null
        /**
         * The Amazon Resource Number (ARN) of the private CA from which the permission was issued.
         */
        public var certificateAuthorityArn: kotlin.String? = null
        /**
         * The time at which the permission was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the policy that is associated with the permission.
         */
        public var policy: kotlin.String? = null
        /**
         * The Amazon Web Services service or entity that holds the permission. At this time, the only valid principal is `acm.amazonaws.com`.
         */
        public var principal: kotlin.String? = null
        /**
         * The ID of the account that assigned the permission.
         */
        public var sourceAccount: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acmpca.model.Permission) : this() {
            this.actions = x.actions
            this.certificateAuthorityArn = x.certificateAuthorityArn
            this.createdAt = x.createdAt
            this.policy = x.policy
            this.principal = x.principal
            this.sourceAccount = x.sourceAccount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acmpca.model.Permission = Permission(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
