// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



public class ImportCertificateAuthorityCertificateRequest private constructor(builder: Builder) {
    /**
     * The PEM-encoded certificate for a private CA. This may be a self-signed certificate in the case of a root CA, or it may be signed by another CA that you control.
     */
    public val certificate: kotlin.ByteArray? = builder.certificate
    /**
     * The Amazon Resource Name (ARN) that was returned when you called [CreateCertificateAuthority](https://docs.aws.amazon.com/privateca/latest/APIReference/API_CreateCertificateAuthority.html). This must be of the form:
     *
     * `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `
     */
    public val certificateAuthorityArn: kotlin.String? = builder.certificateAuthorityArn
    /**
     * A PEM-encoded file that contains all of your certificates, other than the certificate you're importing, chaining up to your root CA. Your Amazon Web Services Private CA-hosted or on-premises root certificate is the last in the chain, and each certificate in the chain signs the one preceding.
     *
     * This parameter must be supplied when you import a subordinate CA. When you import a root CA, there is no chain.
     */
    public val certificateChain: kotlin.ByteArray? = builder.certificateChain

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acmpca.model.ImportCertificateAuthorityCertificateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImportCertificateAuthorityCertificateRequest(")
        append("certificate=$certificate,")
        append("certificateAuthorityArn=$certificateAuthorityArn,")
        append("certificateChain=$certificateChain")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificate?.contentHashCode() ?: 0
        result = 31 * result + (certificateAuthorityArn?.hashCode() ?: 0)
        result = 31 * result + (certificateChain?.contentHashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImportCertificateAuthorityCertificateRequest

        if (certificate != null) {
            if (other.certificate == null) return false
            if (!certificate.contentEquals(other.certificate)) return false
        } else if (other.certificate != null) return false
        if (certificateAuthorityArn != other.certificateAuthorityArn) return false
        if (certificateChain != null) {
            if (other.certificateChain == null) return false
            if (!certificateChain.contentEquals(other.certificateChain)) return false
        } else if (other.certificateChain != null) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acmpca.model.ImportCertificateAuthorityCertificateRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The PEM-encoded certificate for a private CA. This may be a self-signed certificate in the case of a root CA, or it may be signed by another CA that you control.
         */
        public var certificate: kotlin.ByteArray? = null
        /**
         * The Amazon Resource Name (ARN) that was returned when you called [CreateCertificateAuthority](https://docs.aws.amazon.com/privateca/latest/APIReference/API_CreateCertificateAuthority.html). This must be of the form:
         *
         * `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `
         */
        public var certificateAuthorityArn: kotlin.String? = null
        /**
         * A PEM-encoded file that contains all of your certificates, other than the certificate you're importing, chaining up to your root CA. Your Amazon Web Services Private CA-hosted or on-premises root certificate is the last in the chain, and each certificate in the chain signs the one preceding.
         *
         * This parameter must be supplied when you import a subordinate CA. When you import a root CA, there is no chain.
         */
        public var certificateChain: kotlin.ByteArray? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acmpca.model.ImportCertificateAuthorityCertificateRequest) : this() {
            this.certificate = x.certificate
            this.certificateAuthorityArn = x.certificateAuthorityArn
            this.certificateChain = x.certificateChain
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acmpca.model.ImportCertificateAuthorityCertificateRequest = ImportCertificateAuthorityCertificateRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
