// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



public class CreateCertificateAuthorityRequest private constructor(builder: Builder) {
    /**
     * Name and bit size of the private key algorithm, the name of the signing algorithm, and X.500 certificate subject information.
     */
    public val certificateAuthorityConfiguration: aws.sdk.kotlin.services.acmpca.model.CertificateAuthorityConfiguration? = builder.certificateAuthorityConfiguration
    /**
     * The type of the certificate authority.
     */
    public val certificateAuthorityType: aws.sdk.kotlin.services.acmpca.model.CertificateAuthorityType? = builder.certificateAuthorityType
    /**
     * Custom string that can be used to distinguish between calls to the **CreateCertificateAuthority** action. Idempotency tokens for **CreateCertificateAuthority** time out after five minutes. Therefore, if you call **CreateCertificateAuthority** multiple times with the same idempotency token within five minutes, Amazon Web Services Private CA recognizes that you are requesting only certificate authority and will issue only one. If you change the idempotency token for each call, Amazon Web Services Private CA recognizes that you are requesting multiple certificate authorities.
     */
    public val idempotencyToken: kotlin.String? = builder.idempotencyToken
    /**
     * Specifies a cryptographic key management compliance standard used for handling CA keys.
     *
     * Default: FIPS_140_2_LEVEL_3_OR_HIGHER
     *
     * Some Amazon Web Services Regions do not support the default. When creating a CA in these Regions, you must provide `FIPS_140_2_LEVEL_2_OR_HIGHER` as the argument for `KeyStorageSecurityStandard`. Failure to do this results in an `InvalidArgsException` with the message, "A certificate authority cannot be created in this region with the specified security standard."
     *
     * For information about security standard support in various Regions, see [Storage and security compliance of Amazon Web Services Private CA private keys](https://docs.aws.amazon.com/privateca/latest/userguide/data-protection.html#private-keys).
     */
    public val keyStorageSecurityStandard: aws.sdk.kotlin.services.acmpca.model.KeyStorageSecurityStandard? = builder.keyStorageSecurityStandard
    /**
     * Contains information to enable Online Certificate Status Protocol (OCSP) support, to enable a certificate revocation list (CRL), to enable both, or to enable neither. The default is for both certificate validation mechanisms to be disabled.
     *
     * The following requirements apply to revocation configurations.
     * + A configuration disabling CRLs or OCSP must contain only the `Enabled=False` parameter, and will fail if other parameters such as `CustomCname` or `ExpirationInDays` are included.
     * + In a CRL configuration, the `S3BucketName` parameter must conform to [Amazon S3 bucket naming rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html).
     * + A configuration containing a custom Canonical Name (CNAME) parameter for CRLs or OCSP must conform to [RFC2396](https://www.ietf.org/rfc/rfc2396.txt) restrictions on the use of special characters in a CNAME.
     * + In a CRL or OCSP configuration, the value of a CNAME parameter must not include a protocol prefix such as "http://" or "https://".
     *  For more information, see the [OcspConfiguration](https://docs.aws.amazon.com/privateca/latest/APIReference/API_OcspConfiguration.html) and [CrlConfiguration](https://docs.aws.amazon.com/privateca/latest/APIReference/API_CrlConfiguration.html) types.
     */
    public val revocationConfiguration: aws.sdk.kotlin.services.acmpca.model.RevocationConfiguration? = builder.revocationConfiguration
    /**
     * Key-value pairs that will be attached to the new private CA. You can associate up to 50 tags with a private CA. For information using tags with IAM to manage permissions, see [Controlling Access Using IAM Tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html).
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Specifies whether the CA issues general-purpose certificates that typically require a revocation mechanism, or short-lived certificates that may optionally omit revocation because they expire quickly. Short-lived certificate validity is limited to seven days.
     *
     * The default value is GENERAL_PURPOSE.
     */
    public val usageMode: aws.sdk.kotlin.services.acmpca.model.CertificateAuthorityUsageMode? = builder.usageMode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acmpca.model.CreateCertificateAuthorityRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateCertificateAuthorityRequest(")
        append("certificateAuthorityConfiguration=$certificateAuthorityConfiguration,")
        append("certificateAuthorityType=$certificateAuthorityType,")
        append("idempotencyToken=$idempotencyToken,")
        append("keyStorageSecurityStandard=$keyStorageSecurityStandard,")
        append("revocationConfiguration=$revocationConfiguration,")
        append("tags=$tags,")
        append("usageMode=$usageMode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateAuthorityConfiguration?.hashCode() ?: 0
        result = 31 * result + (certificateAuthorityType?.hashCode() ?: 0)
        result = 31 * result + (idempotencyToken?.hashCode() ?: 0)
        result = 31 * result + (keyStorageSecurityStandard?.hashCode() ?: 0)
        result = 31 * result + (revocationConfiguration?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (usageMode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateCertificateAuthorityRequest

        if (certificateAuthorityConfiguration != other.certificateAuthorityConfiguration) return false
        if (certificateAuthorityType != other.certificateAuthorityType) return false
        if (idempotencyToken != other.idempotencyToken) return false
        if (keyStorageSecurityStandard != other.keyStorageSecurityStandard) return false
        if (revocationConfiguration != other.revocationConfiguration) return false
        if (tags != other.tags) return false
        if (usageMode != other.usageMode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acmpca.model.CreateCertificateAuthorityRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Name and bit size of the private key algorithm, the name of the signing algorithm, and X.500 certificate subject information.
         */
        public var certificateAuthorityConfiguration: aws.sdk.kotlin.services.acmpca.model.CertificateAuthorityConfiguration? = null
        /**
         * The type of the certificate authority.
         */
        public var certificateAuthorityType: aws.sdk.kotlin.services.acmpca.model.CertificateAuthorityType? = null
        /**
         * Custom string that can be used to distinguish between calls to the **CreateCertificateAuthority** action. Idempotency tokens for **CreateCertificateAuthority** time out after five minutes. Therefore, if you call **CreateCertificateAuthority** multiple times with the same idempotency token within five minutes, Amazon Web Services Private CA recognizes that you are requesting only certificate authority and will issue only one. If you change the idempotency token for each call, Amazon Web Services Private CA recognizes that you are requesting multiple certificate authorities.
         */
        public var idempotencyToken: kotlin.String? = null
        /**
         * Specifies a cryptographic key management compliance standard used for handling CA keys.
         *
         * Default: FIPS_140_2_LEVEL_3_OR_HIGHER
         *
         * Some Amazon Web Services Regions do not support the default. When creating a CA in these Regions, you must provide `FIPS_140_2_LEVEL_2_OR_HIGHER` as the argument for `KeyStorageSecurityStandard`. Failure to do this results in an `InvalidArgsException` with the message, "A certificate authority cannot be created in this region with the specified security standard."
         *
         * For information about security standard support in various Regions, see [Storage and security compliance of Amazon Web Services Private CA private keys](https://docs.aws.amazon.com/privateca/latest/userguide/data-protection.html#private-keys).
         */
        public var keyStorageSecurityStandard: aws.sdk.kotlin.services.acmpca.model.KeyStorageSecurityStandard? = null
        /**
         * Contains information to enable Online Certificate Status Protocol (OCSP) support, to enable a certificate revocation list (CRL), to enable both, or to enable neither. The default is for both certificate validation mechanisms to be disabled.
         *
         * The following requirements apply to revocation configurations.
         * + A configuration disabling CRLs or OCSP must contain only the `Enabled=False` parameter, and will fail if other parameters such as `CustomCname` or `ExpirationInDays` are included.
         * + In a CRL configuration, the `S3BucketName` parameter must conform to [Amazon S3 bucket naming rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html).
         * + A configuration containing a custom Canonical Name (CNAME) parameter for CRLs or OCSP must conform to [RFC2396](https://www.ietf.org/rfc/rfc2396.txt) restrictions on the use of special characters in a CNAME.
         * + In a CRL or OCSP configuration, the value of a CNAME parameter must not include a protocol prefix such as "http://" or "https://".
         *  For more information, see the [OcspConfiguration](https://docs.aws.amazon.com/privateca/latest/APIReference/API_OcspConfiguration.html) and [CrlConfiguration](https://docs.aws.amazon.com/privateca/latest/APIReference/API_CrlConfiguration.html) types.
         */
        public var revocationConfiguration: aws.sdk.kotlin.services.acmpca.model.RevocationConfiguration? = null
        /**
         * Key-value pairs that will be attached to the new private CA. You can associate up to 50 tags with a private CA. For information using tags with IAM to manage permissions, see [Controlling Access Using IAM Tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html).
         */
        public var tags: List<Tag>? = null
        /**
         * Specifies whether the CA issues general-purpose certificates that typically require a revocation mechanism, or short-lived certificates that may optionally omit revocation because they expire quickly. Short-lived certificate validity is limited to seven days.
         *
         * The default value is GENERAL_PURPOSE.
         */
        public var usageMode: aws.sdk.kotlin.services.acmpca.model.CertificateAuthorityUsageMode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acmpca.model.CreateCertificateAuthorityRequest) : this() {
            this.certificateAuthorityConfiguration = x.certificateAuthorityConfiguration
            this.certificateAuthorityType = x.certificateAuthorityType
            this.idempotencyToken = x.idempotencyToken
            this.keyStorageSecurityStandard = x.keyStorageSecurityStandard
            this.revocationConfiguration = x.revocationConfiguration
            this.tags = x.tags
            this.usageMode = x.usageMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acmpca.model.CreateCertificateAuthorityRequest = CreateCertificateAuthorityRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.CertificateAuthorityConfiguration] inside the given [block]
         */
        public fun certificateAuthorityConfiguration(block: aws.sdk.kotlin.services.acmpca.model.CertificateAuthorityConfiguration.Builder.() -> kotlin.Unit) {
            this.certificateAuthorityConfiguration = aws.sdk.kotlin.services.acmpca.model.CertificateAuthorityConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.RevocationConfiguration] inside the given [block]
         */
        public fun revocationConfiguration(block: aws.sdk.kotlin.services.acmpca.model.RevocationConfiguration.Builder.() -> kotlin.Unit) {
            this.revocationConfiguration = aws.sdk.kotlin.services.acmpca.model.RevocationConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
