// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.waiters

import aws.sdk.kotlin.services.acmpca.AcmPcaClient
import aws.sdk.kotlin.services.acmpca.model.DescribeCertificateAuthorityAuditReportRequest
import aws.sdk.kotlin.services.acmpca.model.DescribeCertificateAuthorityAuditReportResponse
import aws.sdk.kotlin.services.acmpca.model.GetCertificateAuthorityCsrRequest
import aws.sdk.kotlin.services.acmpca.model.GetCertificateAuthorityCsrResponse
import aws.sdk.kotlin.services.acmpca.model.GetCertificateRequest
import aws.sdk.kotlin.services.acmpca.model.GetCertificateResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType
import aws.smithy.kotlin.runtime.retries.policy.SuccessAcceptor
import kotlin.time.Duration.Companion.milliseconds


/**
 * Wait until a Audit Report is created
 */
public suspend fun AcmPcaClient.waitUntilAuditReportCreated(request: DescribeCertificateAuthorityAuditReportRequest): Outcome<DescribeCertificateAuthorityAuditReportResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 3_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeCertificateAuthorityAuditReportRequest, DescribeCertificateAuthorityAuditReportResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val auditReportStatus = it.auditReportStatus?.value
            auditReportStatus == "SUCCESS"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val auditReportStatus = it.auditReportStatus?.value
            auditReportStatus == "FAILED"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeCertificateAuthorityAuditReport(request) }
}

/**
 * Wait until a Audit Report is created
 */
public suspend fun AcmPcaClient.waitUntilAuditReportCreated(block: DescribeCertificateAuthorityAuditReportRequest.Builder.() -> Unit): Outcome<DescribeCertificateAuthorityAuditReportResponse> =
    waitUntilAuditReportCreated(DescribeCertificateAuthorityAuditReportRequest.Builder().apply(block).build())

/**
 * Wait until a certificate is issued
 */
public suspend fun AcmPcaClient.waitUntilCertificateIssued(request: GetCertificateRequest): Outcome<GetCertificateResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 3_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<GetCertificateRequest, GetCertificateResponse>>(
        SuccessAcceptor(RetryDirective.TerminateAndSucceed, true),
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "RequestInProgressException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { getCertificate(request) }
}

/**
 * Wait until a certificate is issued
 */
public suspend fun AcmPcaClient.waitUntilCertificateIssued(block: GetCertificateRequest.Builder.() -> Unit): Outcome<GetCertificateResponse> =
    waitUntilCertificateIssued(GetCertificateRequest.Builder().apply(block).build())

/**
 * Wait until a Certificate Authority CSR is created
 */
public suspend fun AcmPcaClient.waitUntilCertificateAuthorityCSRCreated(request: GetCertificateAuthorityCsrRequest): Outcome<GetCertificateAuthorityCsrResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 3_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<GetCertificateAuthorityCsrRequest, GetCertificateAuthorityCsrResponse>>(
        SuccessAcceptor(RetryDirective.TerminateAndSucceed, true),
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "RequestInProgressException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { getCertificateAuthorityCsr(request) }
}

/**
 * Wait until a Certificate Authority CSR is created
 */
public suspend fun AcmPcaClient.waitUntilCertificateAuthorityCSRCreated(block: GetCertificateAuthorityCsrRequest.Builder.() -> Unit): Outcome<GetCertificateAuthorityCsrResponse> =
    waitUntilCertificateAuthorityCSRCreated(GetCertificateAuthorityCsrRequest.Builder().apply(block).build())
