// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.serde

import aws.sdk.kotlin.services.acmpca.model.AcmPcaException
import aws.sdk.kotlin.services.acmpca.model.GetCertificateAuthorityCsrResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetCertificateAuthorityCsrOperationDeserializer: HttpDeserialize<GetCertificateAuthorityCsrResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetCertificateAuthorityCsrResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetCertificateAuthorityCsrError(context, call)
        }
        val builder = GetCertificateAuthorityCsrResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetCertificateAuthorityCsrOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetCertificateAuthorityCsrError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AcmPcaException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidArnException" -> InvalidArnExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidStateException" -> InvalidStateExceptionDeserializer().deserialize(context, wrappedCall)
        "RequestFailedException" -> RequestFailedExceptionDeserializer().deserialize(context, wrappedCall)
        "RequestInProgressException" -> RequestInProgressExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> AcmPcaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetCertificateAuthorityCsrOperationBody(builder: GetCertificateAuthorityCsrResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CSR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Csr"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CSR_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CSR_DESCRIPTOR.index -> builder.csr = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
