// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.serde

import aws.sdk.kotlin.services.acmpca.model.AcmPcaException
import aws.sdk.kotlin.services.acmpca.model.AuditReportStatus
import aws.sdk.kotlin.services.acmpca.model.DescribeCertificateAuthorityAuditReportResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeCertificateAuthorityAuditReportOperationDeserializer: HttpDeserialize<DescribeCertificateAuthorityAuditReportResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeCertificateAuthorityAuditReportResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeCertificateAuthorityAuditReportError(context, call)
        }
        val builder = DescribeCertificateAuthorityAuditReportResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeCertificateAuthorityAuditReportOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeCertificateAuthorityAuditReportError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AcmPcaException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidArgsException" -> InvalidArgsExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidArnException" -> InvalidArnExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> AcmPcaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeCertificateAuthorityAuditReportOperationBody(builder: DescribeCertificateAuthorityAuditReportResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUDITREPORTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("AuditReportStatus"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedAt"))
    val S3BUCKETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("S3BucketName"))
    val S3KEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("S3Key"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUDITREPORTSTATUS_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(S3BUCKETNAME_DESCRIPTOR)
        field(S3KEY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUDITREPORTSTATUS_DESCRIPTOR.index -> builder.auditReportStatus = deserializeString().let { AuditReportStatus.fromValue(it) }
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                S3BUCKETNAME_DESCRIPTOR.index -> builder.s3BucketName = deserializeString()
                S3KEY_DESCRIPTOR.index -> builder.s3Key = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
