// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



/**
 * Defines the X.509 `CertificatePolicies` extension.
 */
public class PolicyInformation private constructor(builder: Builder) {
    /**
     * Specifies the object identifier (OID) of the certificate policy under which the certificate was issued. For more information, see NIST's definition of [Object Identifier (OID)](https://csrc.nist.gov/glossary/term/Object_Identifier).
     */
    public val certPolicyId: kotlin.String = requireNotNull(builder.certPolicyId) { "A non-null value must be provided for certPolicyId" }
    /**
     * Modifies the given `CertPolicyId` with a qualifier. Amazon Web Services Private CA supports the certification practice statement (CPS) qualifier.
     */
    public val policyQualifiers: List<PolicyQualifierInfo>? = builder.policyQualifiers

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acmpca.model.PolicyInformation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PolicyInformation(")
        append("certPolicyId=$certPolicyId,")
        append("policyQualifiers=$policyQualifiers")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = certPolicyId.hashCode()
        result = 31 * result + (policyQualifiers?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PolicyInformation

        if (certPolicyId != other.certPolicyId) return false
        if (policyQualifiers != other.policyQualifiers) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acmpca.model.PolicyInformation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the object identifier (OID) of the certificate policy under which the certificate was issued. For more information, see NIST's definition of [Object Identifier (OID)](https://csrc.nist.gov/glossary/term/Object_Identifier).
         */
        public var certPolicyId: kotlin.String? = null
        /**
         * Modifies the given `CertPolicyId` with a qualifier. Amazon Web Services Private CA supports the certification practice statement (CPS) qualifier.
         */
        public var policyQualifiers: List<PolicyQualifierInfo>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acmpca.model.PolicyInformation) : this() {
            this.certPolicyId = x.certPolicyId
            this.policyQualifiers = x.policyQualifiers
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acmpca.model.PolicyInformation = PolicyInformation(this)

        internal fun correctErrors(): Builder {
            if (certPolicyId == null) certPolicyId = ""
            return this
        }
    }
}
