// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



public class IssueCertificateRequest private constructor(builder: Builder) {
    /**
     * Specifies X.509 certificate information to be included in the issued certificate. An `APIPassthrough` or `APICSRPassthrough` template variant must be selected, or else this parameter is ignored. For more information about using these templates, see [Understanding Certificate Templates](https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html).
     *
     * If conflicting or duplicate certificate information is supplied during certificate issuance, Amazon Web Services Private CA applies [order of operation rules](https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html#template-order-of-operations) to determine what information is used.
     */
    public val apiPassthrough: aws.sdk.kotlin.services.acmpca.model.ApiPassthrough? = builder.apiPassthrough
    /**
     * The Amazon Resource Name (ARN) that was returned when you called [CreateCertificateAuthority](https://docs.aws.amazon.com/privateca/latest/APIReference/API_CreateCertificateAuthority.html). This must be of the form:
     *
     * `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `
     */
    public val certificateAuthorityArn: kotlin.String? = builder.certificateAuthorityArn
    /**
     * The certificate signing request (CSR) for the certificate you want to issue. As an example, you can use the following OpenSSL command to create the CSR and a 2048 bit RSA private key.
     *
     * `openssl req -new -newkey rsa:2048 -days 365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr`
     *
     * If you have a configuration file, you can then use the following OpenSSL command. The `usr_cert` block in the configuration file contains your X509 version 3 extensions.
     *
     * `openssl req -new -config openssl_rsa.cnf -extensions usr_cert -newkey rsa:2048 -days 365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr`
     *
     * Note: A CSR must provide either a *subject name* or a *subject alternative name* or the request will be rejected.
     */
    public val csr: kotlin.ByteArray? = builder.csr
    /**
     * Alphanumeric string that can be used to distinguish between calls to the **IssueCertificate** action. Idempotency tokens for **IssueCertificate** time out after five minutes. Therefore, if you call **IssueCertificate** multiple times with the same idempotency token within five minutes, Amazon Web Services Private CA recognizes that you are requesting only one certificate and will issue only one. If you change the idempotency token for each call, Amazon Web Services Private CA recognizes that you are requesting multiple certificates.
     */
    public val idempotencyToken: kotlin.String? = builder.idempotencyToken
    /**
     * The name of the algorithm that will be used to sign the certificate to be issued.
     *
     * This parameter should not be confused with the `SigningAlgorithm` parameter used to sign a CSR in the `CreateCertificateAuthority` action.
     *
     * The specified signing algorithm family (RSA or ECDSA) must match the algorithm family of the CA's secret key.
     */
    public val signingAlgorithm: aws.sdk.kotlin.services.acmpca.model.SigningAlgorithm? = builder.signingAlgorithm
    /**
     * Specifies a custom configuration template to use when issuing a certificate. If this parameter is not provided, Amazon Web Services Private CA defaults to the `EndEntityCertificate/V1` template. For CA certificates, you should choose the shortest path length that meets your needs. The path length is indicated by the PathLen*N* portion of the ARN, where *N* is the [CA depth](https://docs.aws.amazon.com/privateca/latest/userguide/PcaTerms.html#terms-cadepth).
     *
     * Note: The CA depth configured on a subordinate CA certificate must not exceed the limit set by its parents in the CA hierarchy.
     *
     * For a list of `TemplateArn` values supported by Amazon Web Services Private CA, see [Understanding Certificate Templates](https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html).
     */
    public val templateArn: kotlin.String? = builder.templateArn
    /**
     * Information describing the end of the validity period of the certificate. This parameter sets the “Not After” date for the certificate.
     *
     * Certificate validity is the period of time during which a certificate is valid. Validity can be expressed as an explicit date and time when the certificate expires, or as a span of time after issuance, stated in days, months, or years. For more information, see [Validity](https://datatracker.ietf.org/doc/html/rfc5280#section-4.1.2.5) in RFC 5280.
     *
     * This value is unaffected when `ValidityNotBefore` is also specified. For example, if `Validity` is set to 20 days in the future, the certificate will expire 20 days from issuance time regardless of the `ValidityNotBefore` value.
     *
     * The end of the validity period configured on a certificate must not exceed the limit set on its parents in the CA hierarchy.
     */
    public val validity: aws.sdk.kotlin.services.acmpca.model.Validity? = builder.validity
    /**
     * Information describing the start of the validity period of the certificate. This parameter sets the “Not Before" date for the certificate.
     *
     * By default, when issuing a certificate, Amazon Web Services Private CA sets the "Not Before" date to the issuance time minus 60 minutes. This compensates for clock inconsistencies across computer systems. The `ValidityNotBefore` parameter can be used to customize the “Not Before” value.
     *
     * Unlike the `Validity` parameter, the `ValidityNotBefore` parameter is optional.
     *
     * The `ValidityNotBefore` value is expressed as an explicit date and time, using the `Validity` type value `ABSOLUTE`. For more information, see [Validity](https://docs.aws.amazon.com/privateca/latest/APIReference/API_Validity.html) in this API reference and [Validity](https://datatracker.ietf.org/doc/html/rfc5280#section-4.1.2.5) in RFC 5280.
     */
    public val validityNotBefore: aws.sdk.kotlin.services.acmpca.model.Validity? = builder.validityNotBefore

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acmpca.model.IssueCertificateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IssueCertificateRequest(")
        append("apiPassthrough=$apiPassthrough,")
        append("certificateAuthorityArn=$certificateAuthorityArn,")
        append("csr=$csr,")
        append("idempotencyToken=$idempotencyToken,")
        append("signingAlgorithm=$signingAlgorithm,")
        append("templateArn=$templateArn,")
        append("validity=$validity,")
        append("validityNotBefore=$validityNotBefore")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiPassthrough?.hashCode() ?: 0
        result = 31 * result + (certificateAuthorityArn?.hashCode() ?: 0)
        result = 31 * result + (csr?.contentHashCode() ?: 0)
        result = 31 * result + (idempotencyToken?.hashCode() ?: 0)
        result = 31 * result + (signingAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (templateArn?.hashCode() ?: 0)
        result = 31 * result + (validity?.hashCode() ?: 0)
        result = 31 * result + (validityNotBefore?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IssueCertificateRequest

        if (apiPassthrough != other.apiPassthrough) return false
        if (certificateAuthorityArn != other.certificateAuthorityArn) return false
        if (csr != null) {
            if (other.csr == null) return false
            if (!csr.contentEquals(other.csr)) return false
        } else if (other.csr != null) return false
        if (idempotencyToken != other.idempotencyToken) return false
        if (signingAlgorithm != other.signingAlgorithm) return false
        if (templateArn != other.templateArn) return false
        if (validity != other.validity) return false
        if (validityNotBefore != other.validityNotBefore) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acmpca.model.IssueCertificateRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies X.509 certificate information to be included in the issued certificate. An `APIPassthrough` or `APICSRPassthrough` template variant must be selected, or else this parameter is ignored. For more information about using these templates, see [Understanding Certificate Templates](https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html).
         *
         * If conflicting or duplicate certificate information is supplied during certificate issuance, Amazon Web Services Private CA applies [order of operation rules](https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html#template-order-of-operations) to determine what information is used.
         */
        public var apiPassthrough: aws.sdk.kotlin.services.acmpca.model.ApiPassthrough? = null
        /**
         * The Amazon Resource Name (ARN) that was returned when you called [CreateCertificateAuthority](https://docs.aws.amazon.com/privateca/latest/APIReference/API_CreateCertificateAuthority.html). This must be of the form:
         *
         * `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `
         */
        public var certificateAuthorityArn: kotlin.String? = null
        /**
         * The certificate signing request (CSR) for the certificate you want to issue. As an example, you can use the following OpenSSL command to create the CSR and a 2048 bit RSA private key.
         *
         * `openssl req -new -newkey rsa:2048 -days 365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr`
         *
         * If you have a configuration file, you can then use the following OpenSSL command. The `usr_cert` block in the configuration file contains your X509 version 3 extensions.
         *
         * `openssl req -new -config openssl_rsa.cnf -extensions usr_cert -newkey rsa:2048 -days 365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr`
         *
         * Note: A CSR must provide either a *subject name* or a *subject alternative name* or the request will be rejected.
         */
        public var csr: kotlin.ByteArray? = null
        /**
         * Alphanumeric string that can be used to distinguish between calls to the **IssueCertificate** action. Idempotency tokens for **IssueCertificate** time out after five minutes. Therefore, if you call **IssueCertificate** multiple times with the same idempotency token within five minutes, Amazon Web Services Private CA recognizes that you are requesting only one certificate and will issue only one. If you change the idempotency token for each call, Amazon Web Services Private CA recognizes that you are requesting multiple certificates.
         */
        public var idempotencyToken: kotlin.String? = null
        /**
         * The name of the algorithm that will be used to sign the certificate to be issued.
         *
         * This parameter should not be confused with the `SigningAlgorithm` parameter used to sign a CSR in the `CreateCertificateAuthority` action.
         *
         * The specified signing algorithm family (RSA or ECDSA) must match the algorithm family of the CA's secret key.
         */
        public var signingAlgorithm: aws.sdk.kotlin.services.acmpca.model.SigningAlgorithm? = null
        /**
         * Specifies a custom configuration template to use when issuing a certificate. If this parameter is not provided, Amazon Web Services Private CA defaults to the `EndEntityCertificate/V1` template. For CA certificates, you should choose the shortest path length that meets your needs. The path length is indicated by the PathLen*N* portion of the ARN, where *N* is the [CA depth](https://docs.aws.amazon.com/privateca/latest/userguide/PcaTerms.html#terms-cadepth).
         *
         * Note: The CA depth configured on a subordinate CA certificate must not exceed the limit set by its parents in the CA hierarchy.
         *
         * For a list of `TemplateArn` values supported by Amazon Web Services Private CA, see [Understanding Certificate Templates](https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html).
         */
        public var templateArn: kotlin.String? = null
        /**
         * Information describing the end of the validity period of the certificate. This parameter sets the “Not After” date for the certificate.
         *
         * Certificate validity is the period of time during which a certificate is valid. Validity can be expressed as an explicit date and time when the certificate expires, or as a span of time after issuance, stated in days, months, or years. For more information, see [Validity](https://datatracker.ietf.org/doc/html/rfc5280#section-4.1.2.5) in RFC 5280.
         *
         * This value is unaffected when `ValidityNotBefore` is also specified. For example, if `Validity` is set to 20 days in the future, the certificate will expire 20 days from issuance time regardless of the `ValidityNotBefore` value.
         *
         * The end of the validity period configured on a certificate must not exceed the limit set on its parents in the CA hierarchy.
         */
        public var validity: aws.sdk.kotlin.services.acmpca.model.Validity? = null
        /**
         * Information describing the start of the validity period of the certificate. This parameter sets the “Not Before" date for the certificate.
         *
         * By default, when issuing a certificate, Amazon Web Services Private CA sets the "Not Before" date to the issuance time minus 60 minutes. This compensates for clock inconsistencies across computer systems. The `ValidityNotBefore` parameter can be used to customize the “Not Before” value.
         *
         * Unlike the `Validity` parameter, the `ValidityNotBefore` parameter is optional.
         *
         * The `ValidityNotBefore` value is expressed as an explicit date and time, using the `Validity` type value `ABSOLUTE`. For more information, see [Validity](https://docs.aws.amazon.com/privateca/latest/APIReference/API_Validity.html) in this API reference and [Validity](https://datatracker.ietf.org/doc/html/rfc5280#section-4.1.2.5) in RFC 5280.
         */
        public var validityNotBefore: aws.sdk.kotlin.services.acmpca.model.Validity? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acmpca.model.IssueCertificateRequest) : this() {
            this.apiPassthrough = x.apiPassthrough
            this.certificateAuthorityArn = x.certificateAuthorityArn
            this.csr = x.csr
            this.idempotencyToken = x.idempotencyToken
            this.signingAlgorithm = x.signingAlgorithm
            this.templateArn = x.templateArn
            this.validity = x.validity
            this.validityNotBefore = x.validityNotBefore
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acmpca.model.IssueCertificateRequest = IssueCertificateRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.ApiPassthrough] inside the given [block]
         */
        public fun apiPassthrough(block: aws.sdk.kotlin.services.acmpca.model.ApiPassthrough.Builder.() -> kotlin.Unit) {
            this.apiPassthrough = aws.sdk.kotlin.services.acmpca.model.ApiPassthrough.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.Validity] inside the given [block]
         */
        public fun validity(block: aws.sdk.kotlin.services.acmpca.model.Validity.Builder.() -> kotlin.Unit) {
            this.validity = aws.sdk.kotlin.services.acmpca.model.Validity.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.Validity] inside the given [block]
         */
        public fun validityNotBefore(block: aws.sdk.kotlin.services.acmpca.model.Validity.Builder.() -> kotlin.Unit) {
            this.validityNotBefore = aws.sdk.kotlin.services.acmpca.model.Validity.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
