// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



/**
 * Specifies the X.509 extension information for a certificate.
 *
 * Extensions present in `CustomExtensions` follow the `ApiPassthrough`[template rules](https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html#template-order-of-operations).
 */
public class CustomExtension private constructor(builder: Builder) {
    /**
     * Specifies the critical flag of the X.509 extension.
     */
    public val critical: kotlin.Boolean? = builder.critical
    /**
     * Specifies the object identifier (OID) of the X.509 extension. For more information, see the [Global OID reference database.](https://oidref.com/2.5.29)
     */
    public val objectIdentifier: kotlin.String = requireNotNull(builder.objectIdentifier) { "A non-null value must be provided for objectIdentifier" }
    /**
     * Specifies the base64-encoded value of the X.509 extension.
     */
    public val value: kotlin.String = requireNotNull(builder.value) { "A non-null value must be provided for value" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acmpca.model.CustomExtension = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CustomExtension(")
        append("critical=$critical,")
        append("objectIdentifier=$objectIdentifier,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = critical?.hashCode() ?: 0
        result = 31 * result + (objectIdentifier.hashCode())
        result = 31 * result + (value.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CustomExtension

        if (critical != other.critical) return false
        if (objectIdentifier != other.objectIdentifier) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acmpca.model.CustomExtension = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the critical flag of the X.509 extension.
         */
        public var critical: kotlin.Boolean? = null
        /**
         * Specifies the object identifier (OID) of the X.509 extension. For more information, see the [Global OID reference database.](https://oidref.com/2.5.29)
         */
        public var objectIdentifier: kotlin.String? = null
        /**
         * Specifies the base64-encoded value of the X.509 extension.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acmpca.model.CustomExtension) : this() {
            this.critical = x.critical
            this.objectIdentifier = x.objectIdentifier
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acmpca.model.CustomExtension = CustomExtension(this)

        internal fun correctErrors(): Builder {
            if (objectIdentifier == null) objectIdentifier = ""
            if (value == null) value = ""
            return this
        }
    }
}
