// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm.model



class ExportCertificateRequest private constructor(builder: Builder) {
    /**
     * An Amazon Resource Name (ARN) of the issued certificate. This must be of the form:
     *
     * `arn:aws:acm:region:account:certificate/12345678-1234-1234-1234-123456789012`
     */
    val certificateArn: kotlin.String? = builder.certificateArn
    /**
     * Passphrase to associate with the encrypted exported private key. If you want to later decrypt the private key, you must have the passphrase. You can use the following OpenSSL command to decrypt a private key:
     *
     * `openssl rsa -in encrypted_key.pem -out decrypted_key.pem`
     */
    val passphrase: kotlin.ByteArray? = builder.passphrase

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acm.model.ExportCertificateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExportCertificateRequest(")
        append("certificateArn=$certificateArn,")
        append("passphrase=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateArn?.hashCode() ?: 0
        result = 31 * result + (passphrase?.contentHashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExportCertificateRequest

        if (certificateArn != other.certificateArn) return false
        if (passphrase != null) {
            if (other.passphrase == null) return false
            if (!passphrase.contentEquals(other.passphrase)) return false
        } else if (other.passphrase != null) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acm.model.ExportCertificateRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * An Amazon Resource Name (ARN) of the issued certificate. This must be of the form:
         *
         * `arn:aws:acm:region:account:certificate/12345678-1234-1234-1234-123456789012`
         */
        var certificateArn: kotlin.String? = null
        /**
         * Passphrase to associate with the encrypted exported private key. If you want to later decrypt the private key, you must have the passphrase. You can use the following OpenSSL command to decrypt a private key:
         *
         * `openssl rsa -in encrypted_key.pem -out decrypted_key.pem`
         */
        var passphrase: kotlin.ByteArray? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acm.model.ExportCertificateRequest) : this() {
            this.certificateArn = x.certificateArn
            this.passphrase = x.passphrase
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acm.model.ExportCertificateRequest = ExportCertificateRequest(this)
    }
}
