// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm.serde

import aws.sdk.kotlin.services.acm.model.CertificateOptions
import aws.sdk.kotlin.services.acm.model.DomainValidationOption
import aws.sdk.kotlin.services.acm.model.KeyAlgorithm
import aws.sdk.kotlin.services.acm.model.RequestCertificateRequest
import aws.sdk.kotlin.services.acm.model.Tag
import aws.sdk.kotlin.services.acm.model.ValidationMethod
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class RequestCertificateOperationSerializer: HttpSerializer.NonStreaming<RequestCertificateRequest> {
    override fun serialize(context: ExecutionContext, input: RequestCertificateRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeRequestCertificateOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeRequestCertificateOperationBody(context: ExecutionContext, input: RequestCertificateRequest): ByteArray {
    val serializer = JsonSerializer()
    val CERTIFICATEAUTHORITYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CertificateAuthorityArn"))
    val DOMAINNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DomainName"))
    val DOMAINVALIDATIONOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DomainValidationOptions"))
    val IDEMPOTENCYTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IdempotencyToken"))
    val KEYALGORITHM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("KeyAlgorithm"))
    val OPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Options"))
    val SUBJECTALTERNATIVENAMES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SubjectAlternativeNames"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val VALIDATIONMETHOD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ValidationMethod"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CERTIFICATEAUTHORITYARN_DESCRIPTOR)
        field(DOMAINNAME_DESCRIPTOR)
        field(DOMAINVALIDATIONOPTIONS_DESCRIPTOR)
        field(IDEMPOTENCYTOKEN_DESCRIPTOR)
        field(KEYALGORITHM_DESCRIPTOR)
        field(OPTIONS_DESCRIPTOR)
        field(SUBJECTALTERNATIVENAMES_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(VALIDATIONMETHOD_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.certificateAuthorityArn?.let { field(CERTIFICATEAUTHORITYARN_DESCRIPTOR, it) }
        input.domainName?.let { field(DOMAINNAME_DESCRIPTOR, it) }
        if (input.domainValidationOptions != null) {
            listField(DOMAINVALIDATIONOPTIONS_DESCRIPTOR) {
                for (el0 in input.domainValidationOptions) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeDomainValidationOptionDocument))
                }
            }
        }
        input.idempotencyToken?.let { field(IDEMPOTENCYTOKEN_DESCRIPTOR, it) }
        input.keyAlgorithm?.let { field(KEYALGORITHM_DESCRIPTOR, it.value) }
        input.options?.let { field(OPTIONS_DESCRIPTOR, it, ::serializeCertificateOptionsDocument) }
        if (input.subjectAlternativeNames != null) {
            listField(SUBJECTALTERNATIVENAMES_DESCRIPTOR) {
                for (el0 in input.subjectAlternativeNames) {
                    serializeString(el0)
                }
            }
        }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.validationMethod?.let { field(VALIDATIONMETHOD_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
