// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains a DNS record value that you can use to validate ownership or control of a domain. This is used by the DescribeCertificate action.
 */
public class ResourceRecord private constructor(builder: Builder) {
    /**
     * The name of the DNS record to create in your domain. This is supplied by ACM.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The type of DNS record. Currently this can be `CNAME`.
     */
    public val type: aws.sdk.kotlin.services.acm.model.RecordType = requireNotNull(builder.type) { "A non-null value must be provided for type" }
    /**
     * The value of the CNAME record to add to your DNS database. This is supplied by ACM.
     */
    public val value: kotlin.String = requireNotNull(builder.value) { "A non-null value must be provided for value" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acm.model.ResourceRecord = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceRecord(")
        append("name=$name,")
        append("type=$type,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name.hashCode()
        result = 31 * result + (type.hashCode())
        result = 31 * result + (value.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceRecord

        if (name != other.name) return false
        if (type != other.type) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acm.model.ResourceRecord = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the DNS record to create in your domain. This is supplied by ACM.
         */
        public var name: kotlin.String? = null
        /**
         * The type of DNS record. Currently this can be `CNAME`.
         */
        public var type: aws.sdk.kotlin.services.acm.model.RecordType? = null
        /**
         * The value of the CNAME record to add to your DNS database. This is supplied by ACM.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acm.model.ResourceRecord) : this() {
            this.name = x.name
            this.type = x.type
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acm.model.ResourceRecord = ResourceRecord(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (type == null) type = RecordType.SdkUnknown("no value provided")
            if (value == null) value = ""
            return this
        }
    }
}
