// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acm.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ExportCertificateRequest private constructor(builder: Builder) {
    /**
     * An Amazon Resource Name (ARN) of the issued certificate. This must be of the form:
     *
     * `arn:aws:acm:region:account:certificate/12345678-1234-1234-1234-123456789012`
     */
    public val certificateArn: kotlin.String? = builder.certificateArn
    /**
     * Passphrase to associate with the encrypted exported private key.
     *
     * When creating your passphrase, you can use any ASCII character except #, $, or %.
     *
     * If you want to later decrypt the private key, you must have the passphrase. You can use the following OpenSSL command to decrypt a private key. After entering the command, you are prompted for the passphrase.
     *
     * `openssl rsa -in encrypted_key.pem -out decrypted_key.pem`
     */
    public val passphrase: kotlin.ByteArray? = builder.passphrase

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acm.model.ExportCertificateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExportCertificateRequest(")
        append("certificateArn=$certificateArn,")
        append("passphrase=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateArn?.hashCode() ?: 0
        result = 31 * result + (passphrase?.contentHashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExportCertificateRequest

        if (certificateArn != other.certificateArn) return false
        if (passphrase != null) {
            if (other.passphrase == null) return false
            if (!passphrase.contentEquals(other.passphrase)) return false
        } else if (other.passphrase != null) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acm.model.ExportCertificateRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An Amazon Resource Name (ARN) of the issued certificate. This must be of the form:
         *
         * `arn:aws:acm:region:account:certificate/12345678-1234-1234-1234-123456789012`
         */
        public var certificateArn: kotlin.String? = null
        /**
         * Passphrase to associate with the encrypted exported private key.
         *
         * When creating your passphrase, you can use any ASCII character except #, $, or %.
         *
         * If you want to later decrypt the private key, you must have the passphrase. You can use the following OpenSSL command to decrypt a private key. After entering the command, you are prompted for the passphrase.
         *
         * `openssl rsa -in encrypted_key.pem -out decrypted_key.pem`
         */
        public var passphrase: kotlin.ByteArray? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acm.model.ExportCertificateRequest) : this() {
            this.certificateArn = x.certificateArn
            this.passphrase = x.passphrase
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acm.model.ExportCertificateRequest = ExportCertificateRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
